/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.ConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ConnectorConfiguration
extends ConfigurableObjectBase {
    private static final long serialVersionUID = 1L;
    private static final String TYPE_PROPERTY = "type";
    private static final String CONNECTOR_IDENTIFIER_OPTION_NAME_PROPERTY = "connectorIdentifierOptionName";
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="connectorIdentifierOptionName")
    private final String connectorIdentifierOptionName;

    @JsonCreator
    public ConnectorConfiguration(@JsonProperty(value="type") String type, @JsonProperty(value="connectorIdentifierOptionName") String connectorIdentifierOptionName) {
        this(null, type, connectorIdentifierOptionName);
    }

    public ConnectorConfiguration(ConnectorConfiguration connector) {
        this(connector, connector.type, connector.connectorIdentifierOptionName);
    }

    private ConnectorConfiguration(ConnectorConfiguration connector, String type, String connectorIdentifierOptionName) {
        super(connector);
        this.type = type;
        this.connectorIdentifierOptionName = connectorIdentifierOptionName;
    }

    public String getRawType() {
        return this.type;
    }

    public Optional<ERepositoryConnector> getRepositoryType() {
        return ERepositoryConnector.findByReadableName(this.getRawType());
    }

    public boolean isRepositoryType(ERepositoryConnector type) {
        return this.getRepositoryType().filter(type::equals).isPresent();
    }

    public Optional<EIssueTracker> getIssueTrackerType() {
        return EIssueTracker.findByReadableName(this.getRawType());
    }

    public boolean isIssueTrackerType(EIssueTracker type) {
        return this.getIssueTrackerType().filter(type::equals).isPresent();
    }

    public Optional<ERequirementsManagementTool> getRequirementsManagementToolType() {
        return ERequirementsManagementTool.findByReadableName(this.getRawType());
    }

    public boolean isRequirementsManagementToolType(ERequirementsManagementTool type) {
        return this.getRequirementsManagementToolType().filter(type::equals).isPresent();
    }

    public boolean isGitBased() {
        return this.getRepositoryType().filter(ERepositoryConnector::isGitBased).isPresent();
    }

    public String getIdentifier() {
        String connectorIdentifier = this.getOptionValue(this.connectorIdentifierOptionName);
        CCSMAssert.isNotNull((Object)connectorIdentifier, () -> String.format("Expected connector identifier (option name \"%s\") to be not null", this.connectorIdentifierOptionName));
        return connectorIdentifier;
    }

    public String getIdentifierOptionName() {
        return this.connectorIdentifierOptionName;
    }

    public void initializeDefaults(List<ConfigOptionDescriptorBase> configOptions) {
        for (ConfigOptionDescriptorBase configOption : configOptions) {
            String key = configOption.getName();
            String defaultValue = configOption.getDefaultValueAsString();
            if (this.getOptionValue(key) != null || defaultValue == null) continue;
            this.setOptionValue(key, defaultValue);
        }
    }

    public void setOptionsFromDescriptor(ConnectorDescriptorBase descriptor) {
        for (ConfigOptionDescriptorBase option : descriptor.getAllOptions()) {
            this.setOptionValue(option.getName(), option.retrieveValueAsString(CodeScopeAware.DEFAULT_CODE_SCOPE));
        }
    }
}

