/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.IConfigOptionDescriptorBehaviour;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class NumberListOptionDescriptor<NUMBER_TYPE extends Number>
extends ConfigOptionDescriptorBase {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private final Function<String, NUMBER_TYPE> mapper;

    public NumberListOptionDescriptor(String name, String description, IConfigOptionDescriptorBehaviour behaviour, Function<String, NUMBER_TYPE> mapper, String collectionType) {
        super(name, description, false, behaviour, collectionType);
        this.mapper = mapper;
    }

    @JsonCreator
    public NumberListOptionDescriptor(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description) {
        super(name, description);
        this.mapper = null;
    }

    @Override
    protected List<NUMBER_TYPE> parseValue(String optionValue) throws ProjectConfigurationException {
        try {
            List valueStringList = CollectionUtils.parseMultiValueStringToList((String)optionValue, (boolean)true);
            return (List)valueStringList.stream().map(this.mapper).collect(CollectionUtils.toArrayList());
        }
        catch (NumberFormatException e) {
            throw new ProjectConfigurationException("Invalid number for option %s: %s".formatted(this.getName(), optionValue), e);
        }
    }

    @Override
    public @Nullable String retrieveValueAsString(CodeScopeName codeScopeName) {
        Object value = this.retrieveValue(codeScopeName);
        if (value == null) {
            return null;
        }
        return this.getValueAsString((List)value);
    }

    @Override
    public @Nullable String getDefaultValueAsString() {
        if (this.defaultValue == null) {
            return null;
        }
        return this.getValueAsString((List)this.defaultValue);
    }

    private String getValueAsString(@NonNull List<NUMBER_TYPE> value) {
        return value.stream().map(Objects::toString).collect(Collectors.joining(","));
    }
}

