/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.trigger;

import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.runtime.impl.analysis.ISchedulingCommit;
import com.teamscale.core.runtime.impl.worker.WorkerJobExecutor;
import com.teamscale.core.utils.TempFileFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class AnalysisStepContext {
    private final String triggerName;
    private final ISchedulingCommit schedulingCommit;
    private final PublicProjectId projectId;
    private final Consumer<IPostTriggerAction> postTriggerActionsConsumer;
    private final TempFileFactory tempFileFactory;
    private final IProfilingMonitor profilingMonitor;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final ILockProvider lockProvider;

    public AnalysisStepContext(String triggerName, ISchedulingCommit schedulingCommit, PublicProjectId projectId, IProfilingMonitor profilingMonitor, Consumer<IPostTriggerAction> postTriggerActionsConsumer, Path tempDir, IParallelTaskExecutor parallelTaskExecutor, ILockProvider lockProvider) throws IOException {
        this.triggerName = triggerName;
        this.schedulingCommit = schedulingCommit;
        this.projectId = projectId;
        this.profilingMonitor = profilingMonitor;
        this.postTriggerActionsConsumer = postTriggerActionsConsumer;
        FileSystemUtils.ensureDirectoryExists((Path)tempDir);
        this.tempFileFactory = new TempFileFactory(tempDir.toFile());
        this.parallelTaskExecutor = parallelTaskExecutor;
        this.lockProvider = lockProvider;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public ISchedulingCommit getSchedulingCommit() {
        return this.schedulingCommit;
    }

    public IProfilingMonitor getProfilingMonitor() {
        return this.profilingMonitor;
    }

    public void addPostTriggerAction(IPostTriggerAction action) {
        this.postTriggerActionsConsumer.accept(Objects.requireNonNull(action, "action"));
    }

    public TempFileFactory getTempFileFactory() {
        return this.tempFileFactory;
    }

    public PublicProjectId getProjectId() {
        return this.projectId;
    }

    IParallelTaskExecutor getParallelTaskExecutor() {
        return this.parallelTaskExecutor;
    }

    public ILockProvider getLockProvider() {
        return this.lockProvider;
    }

    public void setLoggingContextInformation(String contextInformation) {
        WorkerJobExecutor.setAdditionalLog4jContext(contextInformation);
    }
}

