/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.trigger;

import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.impl.analysis.RateLimitableResource;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.jspecify.annotations.NullMarked;

@NullMarked
public sealed interface IPostTriggerAction {

    public record RequestRollback(RollbackRequest request) implements IChangeRetrieverPostTriggerAction,
    IPrivilegedPostTriggerAction
    {
        public RequestRollback {
            Objects.requireNonNull(request, "request");
        }
    }

    public record ScheduleExternalDataTriggers() implements IChangeRetrieverPostTriggerAction
    {
    }

    public record ApplyRateLimiting(RateLimitableResource remoteResource, Instant earliestAllowedAccess) implements IChangeRetrieverPostTriggerAction
    {
        public ApplyRateLimiting {
            Objects.requireNonNull(remoteResource, "remoteResource");
            Objects.requireNonNull(earliestAllowedAccess, "earliestAllowedAccess");
        }
    }

    public record AddPreAnnouncements(List<CommitDescriptor> preAnnouncements) implements IChangeRetrieverPostTriggerAction
    {
        public AddPreAnnouncements {
            Objects.requireNonNull(preAnnouncements, "preAnnouncements");
            if (preAnnouncements.isEmpty()) {
                throw new IllegalArgumentException();
            }
            preAnnouncements = List.copyOf(preAnnouncements);
        }
    }

    public record RescheduleWith(List<ParentedCommitDescriptor> schedulingHints) implements IChangeRetrieverPostTriggerAction
    {
        public RescheduleWith {
            Objects.requireNonNull(schedulingHints, "schedulingHints");
            if (schedulingHints.isEmpty()) {
                throw new IllegalArgumentException();
            }
            schedulingHints = List.copyOf(schedulingHints);
        }
    }

    public record ScheduleChangeRetriever(String changeRetrieverName) implements IChangeRetrieverPostTriggerAction
    {
        public ScheduleChangeRetriever {
            Objects.requireNonNull(changeRetrieverName, "changeRetrieverName");
        }
    }

    public record RunPostRevisionTriggers(CommitDescriptor schedulingCommit) implements IChangeRetrieverPostTriggerAction
    {
        public RunPostRevisionTriggers {
            Objects.requireNonNull(schedulingCommit, "schedulingCommit");
        }
    }

    public record RunPostBuildCompletenessTriggers() implements IChangeRetrieverPostTriggerAction
    {
    }

    public record SchedulePeriodicJobs() implements IPrivilegedPostTriggerAction
    {
    }

    public record DiscardScheduledJobs(Map<String, Long> timestampForBranch) implements IPrivilegedPostTriggerAction
    {
        public DiscardScheduledJobs {
            timestampForBranch = Map.copyOf(Objects.requireNonNull(timestampForBranch, "timestampForBranch"));
        }
    }

    public record IgnoreOutputDelta() implements IChangeRetrieverPostTriggerAction
    {
    }

    public static sealed interface IChangeRetrieverPostTriggerAction
    extends IPostTriggerAction
    permits IgnoreOutputDelta, RunPostBuildCompletenessTriggers, RunPostRevisionTriggers, ScheduleChangeRetriever, RescheduleWith, AddPreAnnouncements, ApplyRateLimiting, ScheduleExternalDataTriggers, RequestRollback {
    }

    public static sealed interface IPrivilegedPostTriggerAction
    extends IPostTriggerAction
    permits DiscardScheduledJobs, SchedulePeriodicJobs, RequestRollback {
    }
}

