/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import com.google.common.collect.ImmutableSet;
import com.nimbusds.jose.JOSEException;
import com.teamscale.core.authenticate.AuthenticationManager;
import com.teamscale.core.authenticate.BearerAuthenticationHelper;
import com.teamscale.core.authenticate.BearerTokenAuthenticationOption;
import com.teamscale.core.authenticate.CachedUser;
import com.teamscale.core.authenticate.SecurityUtils;
import com.teamscale.core.authenticate.SessionCookie;
import com.teamscale.core.authenticate.SessionDuration;
import com.teamscale.core.authenticate.SessionIndex;
import com.teamscale.core.authenticate.monitoring.PrometheusAuthenticationHelper;
import com.teamscale.core.authenticate.teamscale.HashedStoredPasswordAuthenticator;
import com.teamscale.core.authenticate.teamscale.accesskeys.AccessKey;
import com.teamscale.core.authenticate.teamscale.accesskeys.EncryptedAccessKeyIndex;
import com.teamscale.core.config.ServerConfiguration;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.PrometheusServiceOption;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.rest.IMultiPartFormDataProvider;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.text.ParseException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class AuthenticationRequestHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String INVALIDATE_SESSION_CACHE_FOR_USERS_MESSAGE = "invalidate-session-cache-user";
    public static final String INVALIDATE_SESSION_CACHE_FOR_TOKEN_MESSAGE = "invalidate-session-cache-token";
    private static final String INVALIDATE_ACCESS_TOKEN_CACHE_MESSAGE = "invalidate-access-token-cache";
    private static final String CSRF_HEADER_NAME = "X-Requested-By";
    private static final String MULTIPART_CSRF_TOKEN = "csrfToken";
    private static final Set<String> METHODS_TO_IGNORE = ImmutableSet.of((Object)"GET", (Object)"HEAD", (Object)"OPTIONS");
    private static final Duration SESSION_EXPIRATION_UPDATE_TIME = Duration.ofMinutes(TeamscaleSystemProperties.SESSION_EXPIRATION_UPDATE_TIME.getValue().intValue());
    private static final int MAXIMAL_SESSION_TOKENS_FOR_EXPIRATION = 100;
    private static final boolean AUTHENTICATION_DISABLED = TeamscaleSystemProperties.AUTHENTICATION_DISABLED.getValue();
    private static final String TOKEN_SUFFIX_SEPARATOR = "##";
    private static final Pattern SEMICOLON_SEPARATOR_PATTERN = Pattern.compile(";\\s*");
    private final Map<String, CachedUser> sessionCache = new LinkedHashMap<String, CachedUser>(this, 1000, 0.6f, true){
        final /* synthetic */ AuthenticationRequestHandler this$0;
        {
            AuthenticationRequestHandler authenticationRequestHandler = this$0;
            Objects.requireNonNull(authenticationRequestHandler);
            this.this$0 = authenticationRequestHandler;
            super(arg0, arg1, arg2);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CachedUser> eldest) {
            return this.size() > 500;
        }
    };
    private final Map<String, AccessKeyCacheEntry> accessKeyCache = new LinkedHashMap<String, AccessKeyCacheEntry>(this, 1000, 0.6f, true){
        final /* synthetic */ AuthenticationRequestHandler this$0;
        {
            AuthenticationRequestHandler authenticationRequestHandler = this$0;
            Objects.requireNonNull(authenticationRequestHandler);
            this.this$0 = authenticationRequestHandler;
            super(arg0, arg1, arg2);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, AccessKeyCacheEntry> eldest) {
            return this.size() > 500;
        }
    };
    private final Set<String> sessionTokensMarkedForExpirationUpdate = new HashSet<String>();
    private final UserIndex userIndex;
    private final SessionIndex sessionIndex;
    private final EncryptedAccessKeyIndex encryptedAccessKeyIndex;
    private final SessionCookie sessionCookie;
    private final ServerOptionIndex serverOptionIndex;
    private final PermissionIndex permissionIndex;

    public AuthenticationRequestHandler(GlobalStorageSystem globalStorageSystem, int tcpPort, ServerConfiguration serverConfiguration, IMessageBroker messageBroker) throws StorageException {
        this.userIndex = (UserIndex)globalStorageSystem.openGlobalIndex(UserIndex.class);
        this.sessionIndex = (SessionIndex)globalStorageSystem.openGlobalIndex(SessionIndex.class);
        this.encryptedAccessKeyIndex = (EncryptedAccessKeyIndex)globalStorageSystem.openGlobalIndex(EncryptedAccessKeyIndex.class);
        this.sessionCookie = new SessionCookie(tcpPort, serverConfiguration.getInstanceName());
        this.serverOptionIndex = (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        this.permissionIndex = (PermissionIndex)globalStorageSystem.openGlobalIndex(PermissionIndex.class);
        this.registerMessageHandlers(messageBroker);
    }

    private void registerMessageHandlers(IMessageBroker messageBroker) {
        messageBroker.registerListener(INVALIDATE_SESSION_CACHE_FOR_USERS_MESSAGE, usernames -> {
            Map<String, CachedUser> map = this.sessionCache;
            synchronized (map) {
                List<String> userList = Arrays.asList(StringUtils.splitLines((String)usernames));
                CaseInsensitiveStringSet usersToInvalidate = new CaseInsensitiveStringSet(userList);
                this.sessionCache.entrySet().stream().filter(arg_0 -> AuthenticationRequestHandler.lambda$registerMessageHandlers$1((Set)usersToInvalidate, arg_0)).forEach(entry -> this.sessionCache.remove(entry.getKey()));
            }
        });
        messageBroker.registerListener(INVALIDATE_SESSION_CACHE_FOR_TOKEN_MESSAGE, token -> {
            Object object = this.sessionCache;
            synchronized (object) {
                this.sessionCache.remove(token);
            }
            object = this.sessionTokensMarkedForExpirationUpdate;
            synchronized (object) {
                this.sessionTokensMarkedForExpirationUpdate.remove(token);
            }
        });
        messageBroker.registerListener(INVALIDATE_ACCESS_TOKEN_CACHE_MESSAGE, x -> {
            Map<String, AccessKeyCacheEntry> map = this.accessKeyCache;
            synchronized (map) {
                this.accessKeyCache.clear();
            }
        });
    }

    public @Nullable User authenticate(ContainerRequestContext requestContext, IMultiPartFormDataProvider multiPartFormDataProvider) {
        try {
            if (AUTHENTICATION_DISABLED) {
                return this.userIndex.getUser("admin");
            }
            User user = this.authenticateViaAuthHeader(requestContext);
            if (user != null) {
                return user;
            }
            user = this.authenticateUserViaBearerToken(requestContext);
            if (user != null) {
                return user;
            }
            return this.authenticateViaSessionCookie(requestContext, multiPartFormDataProvider);
        }
        catch (StorageException e) {
            throw new InternalServerErrorException("Failed to authenticate user due to storage problems: " + e.getMessage(), (Throwable)e);
        }
    }

    private @Nullable User authenticateViaAuthHeader(ContainerRequestContext requestContext) throws StorageException {
        Pair<String, String> basicAuthenticationCredentials;
        String authHeader = requestContext.getHeaderString("Authorization");
        User bearerUser = BearerAuthenticationHelper.ADMIN_LOGIN_INSTANCE.authenticate(authHeader, basicAuthenticationCredentials = SecurityUtils.getBasicAuthenticationCredentials(authHeader));
        if (bearerUser != null) {
            return bearerUser;
        }
        User prometheusUser = this.handlePrometheusServiceAuthentication(requestContext, authHeader);
        if (prometheusUser != null) {
            return prometheusUser;
        }
        if (basicAuthenticationCredentials == null) {
            return null;
        }
        return this.authenticateViaEncryptedAccessToken((String)basicAuthenticationCredentials.getFirst(), (String)basicAuthenticationCredentials.getSecond());
    }

    private @Nullable User handlePrometheusServiceAuthentication(ContainerRequestContext requestContext, @Nullable String authHeader) throws StorageException {
        if (!PrometheusAuthenticationHelper.isPrometheusRequest(requestContext)) {
            return null;
        }
        PrometheusServiceOption option = ServerOptionRegistry.getInstance().getServerOption("prometheus-service", PrometheusServiceOption.class, this.serverOptionIndex);
        return PrometheusAuthenticationHelper.authenticate(this.permissionIndex, authHeader, requestContext, option);
    }

    private @Nullable User authenticateUserViaBearerToken(ContainerRequestContext requestContext) throws StorageException {
        List<BearerTokenAuthenticationOption> bearerTokenLogins = this.getBearerTokenLogins();
        if (bearerTokenLogins.isEmpty()) {
            return null;
        }
        for (BearerTokenAuthenticationOption loginOption : bearerTokenLogins) {
            String username;
            Optional<String> bearerToken = AuthenticationRequestHandler.getBearerToken((MultivaluedMap<String, String>)requestContext.getHeaders(), loginOption);
            if (bearerToken.isEmpty() || (username = this.getUsername(loginOption, bearerToken.get())) == null) continue;
            return this.userIndex.getUser(username);
        }
        return null;
    }

    private @Nullable String getUsername(BearerTokenAuthenticationOption loginOption, String bearerToken) {
        BearerAuthenticationHelper helper = new BearerAuthenticationHelper(loginOption.getPublicKey());
        try {
            return helper.getUserNameFromJWT(bearerToken, loginOption.getUsernameClaim());
        }
        catch (JOSEException | ParseException e) {
            LOGGER.warn("Invalid token for Bearer token login.", e);
            return null;
        }
    }

    private List<BearerTokenAuthenticationOption> getBearerTokenLogins() throws StorageException {
        UnmodifiableList options = this.serverOptionIndex.getOptionsStartingWith("server:auth.bearer_token").getSecondList();
        return options.stream().map(BearerTokenAuthenticationOption.class::cast).toList();
    }

    private static Optional<String> getBearerToken(MultivaluedMap<String, String> headers, BearerTokenAuthenticationOption bearerTokenOption) {
        List<String> headerNames = bearerTokenOption.getAdditionalHeaders();
        headerNames.add("Authorization");
        for (String headerName : headerNames) {
            String headerValue = (String)headers.getFirst((Object)headerName);
            if (StringUtils.isEmpty((String)headerValue)) {
                LOGGER.debug("Header {} is empty.", (Object)headerName);
                continue;
            }
            LOGGER.debug("Found bearer token {} in header {}.", (Object)headerValue, (Object)headerName);
            return Optional.of(StringUtils.stripPrefix((String)headerValue, (String)"Bearer").trim());
        }
        return Optional.empty();
    }

    public @Nullable User authenticateViaEncryptedAccessToken(String username, String accessKey) throws StorageException {
        Optional<User> cachedUser = this.authenticateViaEncryptedAccessTokenFromCache(username, accessKey);
        if (cachedUser.isPresent()) {
            return cachedUser.get();
        }
        List<AccessKey> storedAccessKeys = this.encryptedAccessKeyIndex.getAccessKeys(username);
        if (storedAccessKeys.isEmpty()) {
            return null;
        }
        User user = this.userIndex.getUser(username);
        if (user == null) {
            return null;
        }
        if (AuthenticationManager.isDenyAll(user)) {
            user = null;
        }
        HashedStoredPasswordAuthenticator authenticator = new HashedStoredPasswordAuthenticator();
        for (AccessKey key : storedAccessKeys) {
            Optional<User> optionalUser = this.authenticateViaAccessKey(user, accessKey, key, authenticator);
            if (!optionalUser.isPresent()) continue;
            return optionalUser.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<User> authenticateViaEncryptedAccessTokenFromCache(String username, String accessKey) {
        Map<String, AccessKeyCacheEntry> map = this.accessKeyCache;
        synchronized (map) {
            AccessKeyCacheEntry cacheEntry = this.accessKeyCache.get(username);
            if (cacheEntry == null) {
                return Optional.empty();
            }
            CachedUser cachedUser = cacheEntry.user();
            if (cachedUser == null || !cachedUser.isValid()) {
                return Optional.empty();
            }
            byte[] bytes = StringUtils.stringToBytes((String)accessKey);
            HashedStoredPasswordAuthenticator authenticator = new HashedStoredPasswordAuthenticator();
            if (this.authenticateWithAccessKey(cacheEntry.key(), cachedUser.access(), authenticator, bytes)) {
                return Optional.of(cachedUser.access());
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<User> authenticateViaAccessKey(User user, String accessKeyHash, AccessKey storedAccessKey, HashedStoredPasswordAuthenticator authenticator) {
        byte[] bytes = StringUtils.stringToBytes((String)accessKeyHash);
        if (this.authenticateWithAccessKey(storedAccessKey, user, authenticator, bytes)) {
            Map<String, AccessKeyCacheEntry> map = this.accessKeyCache;
            synchronized (map) {
                this.accessKeyCache.put(user.getUsername(), new AccessKeyCacheEntry(storedAccessKey, new CachedUser(user)));
            }
            return Optional.of(user);
        }
        return Optional.empty();
    }

    private boolean authenticateWithAccessKey(AccessKey accessKey, User user, HashedStoredPasswordAuthenticator authenticator, byte[] bytes) {
        String tobe = accessKey.getHash();
        String[] split = tobe.split(":");
        if (split.length < 2) {
            return false;
        }
        return authenticator.authenticate(user, bytes, split[1], null);
    }

    public static void clearAccessTokenCache(IMessageBroker messageBroker) {
        messageBroker.sendMessage(INVALIDATE_ACCESS_TOKEN_CACHE_MESSAGE, "unused");
    }

    public static void invalidateSessionCacheForUsers(List<String> usernames, IMessageBroker messageBroker) {
        messageBroker.sendMessage(INVALIDATE_SESSION_CACHE_FOR_USERS_MESSAGE, StringUtils.concat(usernames, (String)"\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User authenticateViaSessionCookie(ContainerRequestContext requestContext, IMultiPartFormDataProvider multiPartFormDataProvider) throws StorageException {
        String sessionToken = this.getSessionTokenAndValidateCsrfHeader(requestContext, multiPartFormDataProvider);
        if (sessionToken == null) {
            return null;
        }
        Optional<SessionDuration> sessionDuration = this.sessionIndex.getSessionDuration(sessionToken);
        if (sessionDuration.isEmpty()) {
            return null;
        }
        this.markSessionForExtensionIfCloseToTimeout(sessionToken, sessionDuration.get());
        Map<String, CachedUser> map = this.sessionCache;
        synchronized (map) {
            CachedUser cachedUser = this.sessionCache.get(sessionToken);
            if (cachedUser != null && cachedUser.isValid()) {
                return cachedUser.access();
            }
        }
        if (!sessionDuration.get().isSessionActive()) {
            return null;
        }
        User user = AuthenticationRequestHandler.determineUserFromSessionToken(sessionToken, this.userIndex);
        if (user == null) {
            return null;
        }
        Map<String, CachedUser> map2 = this.sessionCache;
        synchronized (map2) {
            this.sessionCache.put(sessionToken, new CachedUser(user));
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markSessionForExtensionIfCloseToTimeout(String sessionToken, SessionDuration sessionDuration) {
        if (sessionDuration.isTimedOutBefore(DateTimeUtils.now().plus(SESSION_EXPIRATION_UPDATE_TIME))) {
            Set<String> set = this.sessionTokensMarkedForExpirationUpdate;
            synchronized (set) {
                this.sessionTokensMarkedForExpirationUpdate.add(sessionToken);
            }
        }
    }

    private static User determineUserFromSessionToken(String sessionToken, UserIndex userIndex) throws StorageException {
        String username = (String)SecurityUtils.splitUsernameAndPassword(sessionToken).getFirst();
        if (sessionToken.endsWith("BEARER")) {
            return BearerAuthenticationHelper.createAdminUser(username);
        }
        return userIndex.getUser(username);
    }

    public @Nullable String getCsrfToken(ContainerRequestContext requestContext) {
        return Optional.ofNullable((Cookie)requestContext.getCookies().get(this.sessionCookie.getSessionCookieName())).map(cookie -> RuntimeDelegate.getInstance().createHeaderDelegate(Cookie.class).toString(cookie)).orElse("");
    }

    private String getSessionTokenAndValidateCsrfHeader(ContainerRequestContext requestContext, IMultiPartFormDataProvider multiPartFormDataProvider) {
        boolean formParamMatchesSessionToken;
        String sessionToken = this.getSessionCookieValue(requestContext);
        if (sessionToken == null) {
            return null;
        }
        boolean csrfHeaderMatchesSessionToken = this.containsValidSessionToken(requestContext.getHeaderString(CSRF_HEADER_NAME), sessionToken);
        boolean bl = formParamMatchesSessionToken = !csrfHeaderMatchesSessionToken && multiPartFormDataProvider != null && this.containsValidSessionToken(multiPartFormDataProvider.getParameter(MULTIPART_CSRF_TOKEN).orElse(null), sessionToken);
        if (!(METHODS_TO_IGNORE.contains(requestContext.getMethod()) || csrfHeaderMatchesSessionToken || formParamMatchesSessionToken)) {
            throw new ForbiddenException("X-Requested-By header is missing for " + requestContext.getMethod() + " " + requestContext.getUriInfo().getPath() + " with session based authentication!");
        }
        return sessionToken;
    }

    private boolean containsValidSessionToken(String csrfToken, String sessionToken) {
        if (StringUtils.isEmpty((String)csrfToken)) {
            return false;
        }
        String expectedSessionCookie = this.sessionCookie.getSessionCookieName() + "=" + sessionToken;
        List<String> cookieStrings = Arrays.asList(SEMICOLON_SEPARATOR_PATTERN.split(csrfToken));
        return cookieStrings.contains(expectedSessionCookie);
    }

    public NewCookie createSessionCookie(User user, URI baseUri, SessionIndex sessionIndex, String sessionCookieSuffix, SessionDuration sessionDuration) throws StorageException {
        String token = user.getUsername() + ":" + SecurityUtils.getRandomString(32) + TOKEN_SUFFIX_SEPARATOR + StringUtils.emptyIfNull((String)sessionCookieSuffix);
        sessionIndex.storeSessionDuration(token, sessionDuration);
        return this.sessionCookie.createSessionCookie(baseUri, token, sessionDuration.getDurationUntilTimeout());
    }

    public Response.ResponseBuilder setSessionCookieHeader(User user, Response.ResponseBuilder responseBuilder, URI baseUri, SessionIndex sessionIndex, boolean stayLoggedIn) throws StorageException {
        return this.setSessionCookieHeader(user, responseBuilder, baseUri, sessionIndex, null, SessionDuration.withDefaultTimeout(stayLoggedIn));
    }

    public Response.ResponseBuilder setSessionCookieHeader(User user, Response.ResponseBuilder responseBuilder, URI baseUri, SessionIndex sessionIndex, String sessionSuffix, SessionDuration sessionDuration) throws StorageException {
        return responseBuilder.header("Set-Cookie", (Object)this.createSessionCookie(user, baseUri, sessionIndex, sessionSuffix, sessionDuration));
    }

    public void removeSessionCookie(ContainerRequestContext requestContext, Response.ResponseBuilder result, SessionIndex sessionIndex, IMessageBroker messageBroker, URI baseUri) throws StorageException {
        String token = this.getSessionCookieValue(requestContext);
        if (token != null) {
            sessionIndex.removeSession(token);
            messageBroker.sendMessage(INVALIDATE_SESSION_CACHE_FOR_TOKEN_MESSAGE, token);
        }
        result.header("Set-Cookie", (Object)this.sessionCookie.createSessionRemovalCookie(baseUri));
    }

    public boolean hasValidSessionCookie(ContainerRequestContext requestContext, SessionIndex sessionIndex) throws StorageException {
        return this.getSessionDuration(requestContext, sessionIndex).filter(SessionDuration::isSessionActive).isPresent();
    }

    public Optional<SessionDuration> getSessionDuration(ContainerRequestContext requestContext, SessionIndex sessionIndex) throws StorageException {
        String token = this.getSessionCookieValue(requestContext);
        if (token == null) {
            return Optional.empty();
        }
        return sessionIndex.getSessionDuration(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSessionExpiration(ContainerRequestContext requestContext, ContainerResponseContext result, URI baseUri) throws StorageException {
        boolean updateExpiration;
        String token = this.getSessionCookieValue(requestContext);
        if (token == null) {
            return;
        }
        Set<String> set = this.sessionTokensMarkedForExpirationUpdate;
        synchronized (set) {
            updateExpiration = this.sessionTokensMarkedForExpirationUpdate.remove(token);
            if (this.sessionTokensMarkedForExpirationUpdate.size() > 100) {
                this.sessionTokensMarkedForExpirationUpdate.clear();
            }
        }
        if (updateExpiration) {
            SessionDuration newDuration = this.sessionIndex.extendTimeout(token);
            NewCookie updatedCookie = this.sessionCookie.createSessionCookie(baseUri, token, newDuration.getDurationUntilTimeout());
            result.getHeaders().add((Object)"Set-Cookie", (Object)updatedCookie);
        }
    }

    private @Nullable String getSessionCookieValue(ContainerRequestContext requestContext) {
        return Optional.ofNullable((Cookie)requestContext.getCookies().get(this.sessionCookie.getSessionCookieName())).map(Cookie::getValue).orElse(null);
    }

    private static /* synthetic */ boolean lambda$registerMessageHandlers$1(Set usersToInvalidate, Map.Entry entry) {
        return usersToInvalidate.contains(((CachedUser)entry.getValue()).getUsernameWithoutAccess());
    }

    private record AccessKeyCacheEntry(AccessKey key, CachedUser user) {
    }
}

