/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.github.GitHubAuthenticationUtils;
import com.teamscale.core.authenticate.github.NamedApplication;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import com.teamscale.core.user.UserIndex;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;

class GitHubApplicationImportGroupsStrategy
implements IImportGroupsStrategy {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NamedApplication application;
    private final UserGroupIndex groupIndex;
    private final UserIndex userIndex;
    private final IMessageBroker messageBroker;
    private final AccessTokenIndex accessTokenIndex;
    private final PermissionIndex permissionIndex;

    public GitHubApplicationImportGroupsStrategy(NamedApplication application, UserGroupIndex groupIndex, UserIndex userIndex, IMessageBroker messageBroker, AccessTokenIndex accessTokenIndex, PermissionIndex permissionIndex) {
        this.application = application;
        this.groupIndex = groupIndex;
        this.userIndex = userIndex;
        this.messageBroker = messageBroker;
        this.accessTokenIndex = accessTokenIndex;
        this.permissionIndex = permissionIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> importGroup(String groupName) throws AuthenticationToolException, StorageException {
        UserGroup group = this.groupIndex.getUserGroup(groupName);
        if (group == null) {
            throw new AuthenticationEntityNotFoundException("Group " + groupName + " not found in Teamscale!");
        }
        Set<String> usersForGroup = this.findUsersForGroup(group);
        if (usersForGroup.isEmpty()) {
            UserGroupUtils.removeGroupAndRolesWithoutPermissionCheck(group, this.groupIndex, this.userIndex, this.messageBroker, this.permissionIndex);
            return Collections.emptyList();
        }
        Lock updateLock = this.groupIndex.getUpdateLock();
        updateLock.lock();
        try {
            UserGroup updatedGroup = new UserGroup(group.getName(), group.getAuthenticationTool(), group.getRemoteGroup(), group.getRemoteServer());
            updatedGroup.addUserNames(usersForGroup);
            UserGroupUtils.addToGroup(updatedGroup, usersForGroup, this.userIndex, this.groupIndex, this.messageBroker);
            AuditLogs.updateGroup(group, updatedGroup);
            List<String> list = usersForGroup.stream().toList();
            return list;
        }
        finally {
            updateLock.unlock();
        }
    }

    private Set<String> findUsersForGroup(UserGroup group) throws AuthenticationToolException, StorageException {
        LOGGER.debug("Importing group '{}' from GitHub application '{}'", (Object)group.getName(), (Object)this.application.name());
        Set<String> githubUsernames = GitHubAuthenticationUtils.getUserNamesFromApplicationGroup(this.application, group, this.accessTokenIndex);
        if (githubUsernames.isEmpty()) {
            UserGroupUtils.removeGroupAndRolesWithoutPermissionCheck(group, this.groupIndex, this.userIndex, this.messageBroker, this.permissionIndex);
            return Collections.emptySet();
        }
        LOGGER.debug("Found {} members in GitHub team '{}'", (Object)githubUsernames.size(), (Object)group.getName());
        HashSet<String> usersForGroup = new HashSet<String>();
        for (String username : githubUsernames) {
            try {
                User existingUser = this.userIndex.getUser(username);
                if (existingUser == null) continue;
                usersForGroup.add(username);
            }
            catch (StorageException e) {
                LOGGER.error("Failed to import user '{}' from GitHub: {}", (Object)username, (Object)e.getMessage(), (Object)e);
            }
        }
        return usersForGroup;
    }
}

