/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.IImportUsersStrategy;
import com.teamscale.core.authenticate.github.GitHubAuthenticationUtils;
import com.teamscale.core.authenticate.github.NamedApplication;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;

class GitHubApplicationImportUsersStrategy
implements IImportUsersStrategy {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NamedApplication application;
    private final UserIndex userIndex;
    private final UserGroupIndex groupIndex;
    private final IMessageBroker messageBroker;
    private final AccessTokenIndex accessTokenIndex;

    public GitHubApplicationImportUsersStrategy(NamedApplication application, UserIndex userIndex, UserGroupIndex groupIndex, IMessageBroker messageBroker, AccessTokenIndex accessTokenIndex) {
        this.application = application;
        this.userIndex = userIndex;
        this.groupIndex = groupIndex;
        this.messageBroker = messageBroker;
        this.accessTokenIndex = accessTokenIndex;
    }

    @Override
    public List<User> importUser(String username) throws AuthenticationToolException, StorageException {
        LOGGER.debug("Importing user '{}' from GitHub application '{}'", (Object)username, (Object)this.application.name());
        User userToCreate = GitHubAuthenticationUtils.findUserInApplication(username, this.application, this.accessTokenIndex).orElse(null);
        if (userToCreate == null) {
            LOGGER.warn("User '{}' not found in any allowed GitHub organization", (Object)username);
            return new ArrayList<User>();
        }
        User existingUser = this.userIndex.getUser(username);
        if (existingUser == null) {
            UserGroupUtils.addUserToGroups(userToCreate, this.application.applicationDescription().getGroups(), this.groupIndex);
            this.userIndex.setUser(userToCreate, this.messageBroker);
            LOGGER.info("Created user '{}' from GitHub", (Object)username);
        } else {
            if (existingUser.getAuthenticator() == null || !existingUser.getAuthenticator().endsWith("GitHubOAuth")) {
                LOGGER.warn("User '{}' is already present in Teamscale, but has different authenticator {}. Skipping import", (Object)username, (Object)existingUser.getAuthenticator());
                return new ArrayList<User>();
            }
            UserUtils.updateUserInIndex(this.userIndex, userToCreate, null, this.messageBroker);
            LOGGER.debug("Updated user '{}' from GitHub", (Object)username);
        }
        return List.of(userToCreate);
    }
}

