/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolClientException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.IAutoCompletionStrategy;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.IImportUsersStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUsersStrategy;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.GitHubApplicationImportGroupsStrategy;
import com.teamscale.core.authenticate.github.GitHubApplicationImportUsersStrategy;
import com.teamscale.core.authenticate.github.GitHubApplicationSynchronizeGroupsStrategy;
import com.teamscale.core.authenticate.github.GitHubApplicationSynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.github.GitHubApplicationSynchronizeUsersStrategy;
import com.teamscale.core.authenticate.github.NamedApplication;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class GitHubApplicationProvider
implements IAuthenticationToolProvider {
    private final GlobalStorageSystem globalStorageSystem;
    private final IMessageBroker messageBroker;

    public GitHubApplicationProvider(GlobalStorageSystem globalStorageSystem, IMessageBroker messageBroker) {
        this.globalStorageSystem = globalStorageSystem;
        this.messageBroker = messageBroker;
    }

    private <T extends IGlobalIndex> T openGlobalIndex(Class<T> globalIndex) throws StorageException {
        return (T)this.globalStorageSystem.openGlobalIndex(globalIndex);
    }

    private NamedApplication getApplication(String applicationName) throws StorageException, AuthenticationToolException {
        ServerOptionIndex serverIndex = this.openGlobalIndex(ServerOptionIndex.class);
        GitHubApplicationDescription description = ServerOptionRegistry.getInstance().getOption("server", "auth.github.application", applicationName, GitHubApplicationDescription.class, serverIndex);
        if (description == null) {
            throw new AuthenticationToolClientException("GitHub Application does not exist: " + applicationName);
        }
        return new NamedApplication(applicationName, description);
    }

    @Override
    public IImportUsersStrategy createImportUsersStrategy(String applicationName) throws StorageException, AuthenticationToolException {
        return new GitHubApplicationImportUsersStrategy(this.getApplication(applicationName), this.openGlobalIndex(UserIndex.class), this.openGlobalIndex(UserGroupIndex.class), this.messageBroker, this.openGlobalIndex(AccessTokenIndex.class));
    }

    @Override
    public IImportGroupsStrategy createImportGroupsStrategy(String applicationName) throws StorageException, AuthenticationToolException {
        return new GitHubApplicationImportGroupsStrategy(this.getApplication(applicationName), this.openGlobalIndex(UserGroupIndex.class), this.openGlobalIndex(UserIndex.class), this.messageBroker, this.openGlobalIndex(AccessTokenIndex.class), this.openGlobalIndex(PermissionIndex.class));
    }

    @Override
    public ISynchronizeUsersStrategy createSynchronizeUsersStrategy(String applicationName) throws StorageException, AuthenticationToolException {
        return new GitHubApplicationSynchronizeUsersStrategy(this.getApplication(applicationName), this.openGlobalIndex(UserGroupIndex.class), this.openGlobalIndex(UserIndex.class), this.openGlobalIndex(AccessTokenIndex.class), this.messageBroker);
    }

    @Override
    public ISynchronizeGroupsStrategy createSynchronizeGroupsStrategy(String applicationName) throws StorageException, AuthenticationToolException {
        return new GitHubApplicationSynchronizeGroupsStrategy(this.getApplication(applicationName), this.openGlobalIndex(UserIndex.class), this.openGlobalIndex(UserGroupIndex.class), this.createImportGroupsStrategy(applicationName), this.openGlobalIndex(AccessTokenIndex.class));
    }

    @Override
    public ISynchronizeUserGroupsStrategy createSynchronizeUserGroupsStrategy(String applicationName) throws StorageException, AuthenticationToolException {
        return new GitHubApplicationSynchronizeUserGroupsStrategy(this.getApplication(applicationName), this.openGlobalIndex(UserGroupIndex.class), this.openGlobalIndex(AccessTokenIndex.class));
    }

    @Override
    public IAutoCompletionStrategy createUserAutoCompletionStrategy(String applicationName) throws StorageException, AuthenticationToolException {
        return IAutoCompletionStrategy.empty();
    }

    @Override
    public IAutoCompletionStrategy createGroupAutoCompletionStrategy(String applicationName) throws StorageException, AuthenticationToolException {
        return IAutoCompletionStrategy.empty();
    }

    @Override
    public List<String> getServerList() throws StorageException {
        ServerOptionIndex serverIndex = this.openGlobalIndex(ServerOptionIndex.class);
        ServerOptionRegistry registry = ServerOptionRegistry.getInstance();
        String optionId = "auth.github.application";
        ArrayList<String> applicationNames = new ArrayList<String>();
        for (String key : registry.getServerOptions(optionId, serverIndex).keySet()) {
            if (!key.contains("/")) continue;
            String name = key.substring(key.indexOf("/") + 1);
            applicationNames.add(name);
        }
        return applicationNames;
    }

    @Override
    public EAuthenticationTool getAuthenticationTool() {
        return EAuthenticationTool.GITHUB;
    }
}

