/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeGroupsStrategy;
import com.teamscale.core.authenticate.github.GitHubAuthenticationUtils;
import com.teamscale.core.authenticate.github.NamedApplication;
import com.teamscale.core.authenticate.github.client.GitHubAuthClient;
import com.teamscale.core.authenticate.github.dto.Account;
import com.teamscale.core.authenticate.github.dto.GitHubTeam;
import com.teamscale.core.authenticate.github.dto.GitHubUser;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

class GitHubApplicationSynchronizeGroupsStrategy
implements ISynchronizeGroupsStrategy {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NamedApplication application;
    private final UserIndex userIndex;
    private final UserGroupIndex groupIndex;
    private final IImportGroupsStrategy importGroupsStrategy;
    private final AccessTokenIndex accessTokenIndex;

    public GitHubApplicationSynchronizeGroupsStrategy(NamedApplication application, UserIndex userIndex, UserGroupIndex groupIndex, IImportGroupsStrategy importGroupsStrategy, AccessTokenIndex accessTokenIndex) {
        this.application = application;
        this.userIndex = userIndex;
        this.groupIndex = groupIndex;
        this.importGroupsStrategy = importGroupsStrategy;
        this.accessTokenIndex = accessTokenIndex;
    }

    @Override
    public void synchronizeSingleGroup(String groupName) throws StorageException, AuthenticationToolException {
        this.synchronizeSingleGroupNow(groupName);
    }

    @Override
    public void synchronizeSingleGroupNow(String groupName) throws StorageException, AuthenticationToolException {
        UserGroup group = this.groupIndex.getUserGroup(groupName);
        if (group == null) {
            throw new AuthenticationToolException("Group " + groupName + " not found!");
        }
        String remoteGroup = group.getRemoteGroup();
        if (remoteGroup == null) {
            throw new AuthenticationToolException("Remote group for " + groupName + " not found!");
        }
        this.synchronizeGroup(group.getName());
    }

    @Override
    public List<String> synchronizeAllGroups() throws StorageException, AuthenticationToolException {
        return this.synchronizeAllGroupsNow();
    }

    @Override
    public List<String> synchronizeAllGroupsNow() throws StorageException {
        List<String> allowedOrganizations = this.application.applicationDescription().getAllowedOrganizations();
        if (allowedOrganizations.isEmpty()) {
            LOGGER.warn("No allowed organizations configured for GitHub application {}, skipping team synchronization", (Object)this.application.name());
            return new ArrayList<String>();
        }
        List<UserGroup> allGroupsForThisGitHubApp = this.createGroupsForGithubTeams(allowedOrganizations);
        for (UserGroup group : allGroupsForThisGitHubApp) {
            try {
                this.synchronizeGroup(group.getName());
            }
            catch (AuthenticationToolException e) {
                LOGGER.warn("Synchronizing group '{}' failed: {}", (Object)group, (Object)e.getMessage(), (Object)e);
            }
        }
        return allGroupsForThisGitHubApp.stream().map(UserGroup::getName).toList();
    }

    private List<UserGroup> createGroupsForGithubTeams(List<String> allowedOrganizations) throws StorageException {
        List allGroups = this.groupIndex.getAllUserGroups().extractSecondList();
        List allGroupsForThisApp = (List)allGroups.stream().filter(group -> group.originatesFrom(EAuthenticationTool.GITHUB, allowedOrganizations)).collect(CollectionUtils.toArrayList());
        if (!this.application.applicationDescription().createTeamGroupsAutomatically) {
            return allGroupsForThisApp;
        }
        for (String organization : allowedOrganizations) {
            allGroupsForThisApp.addAll(this.processOrganization(organization, allGroupsForThisApp, allGroups));
        }
        return allGroupsForThisApp;
    }

    private List<UserGroup> processOrganization(String organization, List<UserGroup> allGroupsForThisApp, List<UserGroup> allGroups) throws StorageException {
        ArrayList<UserGroup> groupsForThisAppAndOrg = new ArrayList<UserGroup>();
        try {
            GitHubAuthClient client = GitHubAuthenticationUtils.createApplicationClientForOrganization(this.application, organization, this.accessTokenIndex);
            List<GitHubTeam> gitHubTeams = client.getOrganizationTeams(organization);
            gitHubTeams.removeIf(team -> allGroupsForThisApp.stream().anyMatch(existingGroup -> existingGroup.getRemoteGroup() != null && existingGroup.getRemoteGroup().equals(team.name())));
            for (GitHubTeam team2 : gitHubTeams) {
                List<GitHubUser> members = this.getTeamMembersWithUserInTeamscale(organization, team2, client);
                if (members.isEmpty()) continue;
                Optional<UserGroup> group = GitHubAuthenticationUtils.createTeamscaleGroupForGitHubTeamSafe(this.application.applicationDescription(), this.groupIndex, team2.name(), organization, allGroups, allGroupsForThisApp);
                group.ifPresent(groupsForThisAppAndOrg::add);
            }
        }
        catch (ServiceCallException | AuthenticationToolException e) {
            LOGGER.error("Error fetching GitHub teams for organization {}. Groups may be not be synced fully.", (Object)organization, e);
        }
        return groupsForThisAppAndOrg;
    }

    private List<GitHubUser> getTeamMembersWithUserInTeamscale(String organization, GitHubTeam team, GitHubAuthClient client) throws ServiceCallException, StorageException {
        List<GitHubUser> members = client.getTeamMembers(organization, team);
        List<@Nullable E> tsUsers = this.userIndex.getUsers(members.stream().map(Account::getLogin).toList()).stream().toList();
        return IntStream.range(0, members.size()).filter(i -> tsUsers.get(i) != null).mapToObj(members::get).toList();
    }

    private void synchronizeGroup(String groupName) throws AuthenticationToolException, StorageException {
        this.importGroupsStrategy.importGroup(groupName);
    }
}

