/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.ISynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.github.GitHubAuthenticationUtils;
import com.teamscale.core.authenticate.github.NamedApplication;
import com.teamscale.core.authenticate.github.client.GitHubAuthClient;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

class GitHubApplicationSynchronizeUserGroupsStrategy
implements ISynchronizeUserGroupsStrategy {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NamedApplication application;
    private final UserGroupIndex groupIndex;
    private final AccessTokenIndex accessTokenIndex;

    public GitHubApplicationSynchronizeUserGroupsStrategy(NamedApplication application, UserGroupIndex groupIndex, AccessTokenIndex accessTokenIndex) {
        this.application = application;
        this.groupIndex = groupIndex;
        this.accessTokenIndex = accessTokenIndex;
    }

    @Override
    public List<String> synchronizeUserGroups(User user) throws StorageException {
        LOGGER.debug("Synchronizing groups for user '{}' from GitHub application '{}'", (Object)user.getUsername(), (Object)this.application.name());
        List<String> allowedOrganizations = this.application.applicationDescription().getAllowedOrganizations();
        if (allowedOrganizations.isEmpty()) {
            LOGGER.debug("No allowed organizations configured for GitHub app {}, skipping team synchronization", (Object)this.application.name());
            return CollectionUtils.emptyList();
        }
        HashSet<String> groupsUserIsMemberOf = new HashSet<String>();
        UnmodifiableList allGroups = this.groupIndex.getAllUserGroups().getSecondList();
        List allTsGroupsForThisApp = (List)allGroups.stream().filter(group -> group.originatesFrom(EAuthenticationTool.GITHUB, allowedOrganizations)).collect(CollectionUtils.toArrayList());
        for (String organizationName : allowedOrganizations) {
            this.processOrganization(user, organizationName, (List<UserGroup>)allGroups, allTsGroupsForThisApp, groupsUserIsMemberOf);
        }
        GitHubAuthenticationUtils.UserGroupCheckResult userMembershipCheck = GitHubAuthenticationUtils.checkGroupMembershipForSingleUser(user, groupsUserIsMemberOf, allTsGroupsForThisApp);
        UserGroupUtils.addUserToGroups(user, userMembershipCheck.groupsToAdd(), this.groupIndex);
        UserGroupUtils.removeUserFromGroups(user, userMembershipCheck.groupsToRemove(), this.groupIndex);
        LOGGER.debug("Synchronized team memberships for user {}: added to {} groups, removed from {} groups", (Object)user.getUsername(), (Object)userMembershipCheck.groupsToAdd().size(), (Object)userMembershipCheck.groupsToRemove().size());
        return new ArrayList<String>(groupsUserIsMemberOf);
    }

    private void processOrganization(User user, String organizationName, List<UserGroup> allGroups, List<UserGroup> allTsGroupsForThisApp, Set<String> groupsUserIsMemberOf) throws StorageException {
        try {
            GitHubAuthClient client = GitHubAuthenticationUtils.createApplicationClientForOrganization(this.application, organizationName, this.accessTokenIndex);
            List<GitHubAuthClient.OrganizationTeam> userTeams = client.getUserTeams(List.of(organizationName), user.getUsername());
            for (GitHubAuthClient.OrganizationTeam orgTeam : userTeams) {
                Optional<UserGroup> groupForThisTeam = GitHubAuthenticationUtils.createTeamscaleGroupForGitHubTeamSafe(this.application.applicationDescription(), this.groupIndex, orgTeam.team().name(), orgTeam.organizationName(), allGroups, allTsGroupsForThisApp);
                groupForThisTeam.ifPresent(group -> {
                    groupsUserIsMemberOf.add(group.getName());
                    groupForThisTeam.ifPresent(allTsGroupsForThisApp::add);
                });
            }
        }
        catch (ServiceCallException | AuthenticationToolException e) {
            LOGGER.warn("Failed to fetch team memberships for user {} from organization {}: {}", (Object)user.getUsername(), (Object)organizationName, (Object)((Throwable)e).getMessage(), e);
        }
    }
}

