/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.ISynchronizeUsersStrategy;
import com.teamscale.core.authenticate.github.GitHubAuthenticationUtils;
import com.teamscale.core.authenticate.github.NamedApplication;
import com.teamscale.core.authenticate.github.client.GitHubAuthClient;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;

class GitHubApplicationSynchronizeUsersStrategy
implements ISynchronizeUsersStrategy {
    private final NamedApplication application;
    private final UserIndex userIndex;
    private final UserGroupIndex userGroupIndex;
    private final AccessTokenIndex accessTokenIndex;
    private final IMessageBroker messageBroker;

    public GitHubApplicationSynchronizeUsersStrategy(NamedApplication application, UserGroupIndex userGroupIndex, UserIndex userIndex, AccessTokenIndex accessTokenIndex, IMessageBroker messageBroker) {
        this.application = application;
        this.userIndex = userIndex;
        this.userGroupIndex = userGroupIndex;
        this.accessTokenIndex = accessTokenIndex;
        this.messageBroker = messageBroker;
    }

    @Override
    public List<User> getUsersForServer() throws StorageException {
        List<UserGroup> groupsForThisGitHubApp = this.userGroupIndex.getAllUserGroups().extractSecondList().stream().filter(group -> group.getRemoteGroup() != null && group.originatesFrom(EAuthenticationTool.GITHUB, this.application.applicationDescription().getAllowedOrganizations())).toList();
        Set userNames = groupsForThisGitHubApp.stream().flatMap(group -> group.getUserNames().stream()).collect(Collectors.toSet());
        return this.userIndex.getUsers(new ArrayList<String>(userNames)).stream().filter(Objects::nonNull).toList();
    }

    @Override
    public Optional<String> synchronizeUser(User user) throws StorageException, AuthenticationToolException {
        Optional<String> result = Optional.empty();
        for (String organization : this.application.applicationDescription().getAllowedOrganizations()) {
            GitHubAuthClient client = GitHubAuthenticationUtils.createApplicationClientForOrganization(this.application, organization, this.accessTokenIndex);
            User userInOrganization = GitHubAuthenticationUtils.findUser(user.getUsername(), organization, client);
            if (userInOrganization == null) continue;
            UserUtils.updateUserInIndex(this.userIndex, user, null, this.messageBroker);
            result = Optional.of(user.getUsername());
            break;
        }
        return result;
    }
}

