/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github.client;

import com.teamscale.core.rest.client.HttpRequestRateLimiter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.TestOnly;

public class GitHubRateLimiter
extends HttpRequestRateLimiter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String RATE_LIMIT_REMAINING_HEADER_NAME = "X-RateLimit-Remaining";
    private static final String RATE_LIMIT_RESET_HEADER_NAME = "X-RateLimit-Reset";

    public GitHubRateLimiter() {
        super(Duration.ofMinutes(1L));
    }

    @TestOnly
    protected GitHubRateLimiter(Duration initialRetryDelay) {
        super(initialRetryDelay);
    }

    protected boolean isRequestRateLimited(Response httpResponse) {
        return super.isRequestRateLimited(httpResponse) || GitHubRateLimiter.isRequestRateLimitedWith403(httpResponse);
    }

    private static boolean isRequestRateLimitedWith403(Response httpResponse) {
        if (httpResponse.code() != Response.Status.FORBIDDEN.getStatusCode()) {
            return false;
        }
        if (GitHubRateLimiter.isRateLimitRemainingExceeded(httpResponse)) {
            return true;
        }
        if (GitHubRateLimiter.getRetryAfterHeaderValue((Response)httpResponse).isPresent()) {
            return true;
        }
        try {
            return httpResponse.body() != null && httpResponse.body().string().contains("exceeded a secondary rate limit");
        }
        catch (IOException e) {
            LOGGER.error("Failed to read response body to determine if the request was forbidden due to rate limiting", (Throwable)e);
            return false;
        }
    }

    protected Optional<Duration> getRetryDelayFromHeaders(Response httpResponse) {
        Optional durationFromRetryAfter = super.getRetryDelayFromHeaders(httpResponse);
        if (durationFromRetryAfter.isPresent()) {
            return durationFromRetryAfter;
        }
        if (GitHubRateLimiter.isRateLimitRemainingExceeded(httpResponse)) {
            GitHubRateLimiter gitHubRateLimiter = this;
            return GitHubRateLimiter.getRateLimitResetHeaderValue(httpResponse).map(x$0 -> gitHubRateLimiter.parseRetryDelayHeaderValue((String)x$0));
        }
        return Optional.empty();
    }

    private static boolean isRateLimitRemainingExceeded(Response httpResponse) {
        return GitHubRateLimiter.getRateLimitRemainingHeaderValue(httpResponse).map(headerValue -> headerValue.equals("0")).orElse(false);
    }

    private static Optional<String> getRateLimitRemainingHeaderValue(Response httpResponse) {
        return GitHubRateLimiter.getHeaderValue((Response)httpResponse, (String)RATE_LIMIT_REMAINING_HEADER_NAME);
    }

    private static Optional<String> getRateLimitResetHeaderValue(Response httpResponse) {
        return GitHubRateLimiter.getHeaderValue((Response)httpResponse, (String)RATE_LIMIT_RESET_HEADER_NAME);
    }
}

