/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.dto.App;
import com.teamscale.core.authenticate.github.dto.Installation;
import com.teamscale.core.authenticate.github.dto.InstallationRepositories;
import com.teamscale.core.authenticate.github.dto.InstallationToken;
import com.teamscale.core.rest.client.IRetrofitApi;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface IGitHubAppApi
extends IRetrofitApi {
    public static final String RESPONSE_CONTENT_TYPE_HEADER = "Accept: application/vnd.github.machine-man-preview+json";
    public static final String INSTALLATION_ID_PARAMETER_NAME = "installationId";
    public static final String APP_ENDPOINT = "app";
    public static final String APP_INSTALLATIONS_ENDPOINT = "app/installations";
    public static final String INSTALLATION_TOKEN_ENDPOINT = "app/installations/{installationId}/access_tokens";
    public static final String INSTALLATION_REPOSITORIES_ENDPOINT = "installation/repositories";

    @GET(value="app")
    @Headers(value={"Accept: application/vnd.github.machine-man-preview+json"})
    public App getApp(@Header(value="Authorization") String var1) throws ServiceCallException;

    @GET(value="app/installations")
    @Headers(value={"Accept: application/vnd.github.machine-man-preview+json"})
    public Call<Installation[]> getAppInstallations(@Header(value="Authorization") String var1, @Query(value="per_page") int var2);

    @GET
    @Headers(value={"Accept: application/vnd.github.machine-man-preview+json"})
    public Call<Installation[]> getAppInstallationsFromNextPage(@Url String var1, @Header(value="Authorization") String var2, @Query(value="per_page") int var3);

    @POST(value="app/installations/{installationId}/access_tokens")
    @Headers(value={"Accept: application/vnd.github.machine-man-preview+json"})
    public InstallationToken createInstallationToken(@Header(value="Authorization") String var1, @Path(value="installationId") long var2) throws ServiceCallException;

    @GET(value="installation/repositories")
    @Headers(value={"Accept: application/vnd.github.machine-man-preview+json"})
    public Call<InstallationRepositories> getInstallationRepositories(@Header(value="Authorization") String var1, @Query(value="per_page") int var2);

    @GET
    @Headers(value={"Accept: application/vnd.github.machine-man-preview+json"})
    public Call<InstallationRepositories> getInstallationRepositoriesFromNextPage(@Url String var1, @Header(value="Authorization") String var2, @Query(value="per_page") int var3);
}

