/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.dto.Email;
import com.teamscale.core.authenticate.github.dto.GitHubOrganization;
import com.teamscale.core.authenticate.github.dto.GitHubTeam;
import com.teamscale.core.authenticate.github.dto.GitHubTeamMembership;
import com.teamscale.core.authenticate.github.dto.GitHubUser;
import com.teamscale.core.authenticate.github.dto.GitHubUserAccessToken;
import com.teamscale.core.rest.client.IRetrofitApi;
import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface IGitHubAuthApi
extends IRetrofitApi {
    public static final String ORGANIZATION_NAME_PARAM_NAME = "organization";
    public static final String TEAM_SLUG_PARAM_NAME = "teamSlug";
    public static final String USERS_ENDPOINT = "users";
    public static final String SINGLE_USER_ENDPOINT = "users/{username}";
    public static final String AUTHENTICATED_USER_EMAILS_ENDPOINT = "user/emails";
    public static final String ORGANIZATIONS_ENDPOINT = "user/orgs";
    public static final String ORGANIZATION_ENDPOINT = "orgs/{organization}";
    public static final String USER_ORGANIZATIONS_ENDPOINT = "users/{username}/orgs";
    public static final String ORGANIZATION_MEMBER_ENDPOINT = "orgs/{organization}/members/{username}";
    public static final String TEAMS_ENDPOINT = "orgs/{organization}/teams";
    public static final String TEAM_ENDPOINT = "orgs/{organization}/teams/{teamSlug}";
    public static final String TEAM_MEMBERS_ENDPOINT = "orgs/{organization}/teams/{teamSlug}/members";
    public static final String TEAM_MEMBERSHIP_ENDPOINT = "orgs/{organization}/teams/{teamSlug}/memberships/{username}";
    public static final String USER_ACCESS_TOKEN_ENDPOINT = "login/oauth/access_token";

    @GET(value="user")
    @Headers(value={"Accept: application/vnd.github+json"})
    public GitHubUser getUser() throws ServiceCallException;

    @GET(value="users/{username}")
    @Headers(value={"Accept: application/vnd.github+json"})
    public GitHubUser getUser(@Path(value="username") String var1) throws ServiceCallException;

    @GET(value="user/emails")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<Email[]> getUserEmails(@Query(value="per_page") int var1);

    @GET
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<Email[]> getUserEmailsFromNextPage(@Url String var1);

    @GET(value="user/orgs")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubOrganization[]> getOrganizations(@Query(value="per_page") int var1);

    @GET
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubOrganization[]> getOrganizationsFromNextPage(@Url String var1);

    @GET(value="users/{username}/orgs")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubOrganization[]> getUserOrganizations(@Path(value="username") String var1, @Query(value="per_page") int var2);

    @GET(value="orgs/{organization}/members/{username}")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Void checkUserIsOrganizationMember(@Path(value="organization") String var1, @Path(value="username") String var2) throws ServiceCallException;

    @GET(value="orgs/{organization}/teams")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubTeam[]> getOrganizationTeams(@Path(value="organization") String var1, @Query(value="per_page") int var2);

    @GET
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubTeam[]> getOrganizationTeamsFromNextPage(@Url String var1);

    @GET(value="orgs/{organization}/teams/{teamSlug}/members")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubUser[]> getTeamMembers(@Path(value="organization") String var1, @Path(value="teamSlug") String var2, @Query(value="per_page") int var3);

    @GET
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubUser[]> getTeamMembersFromNextPage(@Url String var1);

    @GET(value="orgs/{organization}/teams/{teamSlug}/memberships/{username}")
    @Headers(value={"Accept: application/vnd.github+json"})
    public GitHubTeamMembership getTeamMembership(@Path(value="organization") String var1, @Path(value="teamSlug") String var2, @Path(value="username") String var3) throws ServiceCallException;

    @FormUrlEncoded
    @POST(value="login/oauth/access_token")
    @Headers(value={"Accept: application/json"})
    public GitHubUserAccessToken requestUserAccessToken(@Field(value="client_id") String var1, @Field(value="client_secret") String var2, @Field(value="code") String var3) throws ServiceCallException;
}

