/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github.index;

import java.io.Serializable;
import java.util.Optional;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="oauth-tokens", options={EStorageOption.BACKUP, EStorageOption.ENCRYPTED}, valueClasses={OAuthToken.class})
public class OAuthTokenIndex
extends IndexBase
implements IGlobalIndex {
    public static final String NAME = "oauth-tokens";
    private static final String GITHUB_USER_KEY_SUFFIX = ":github-oauth-token";

    public OAuthTokenIndex(IStore store) {
        super(store);
    }

    public Optional<OAuthToken> getUserOAuthToken(String username) throws StorageException {
        return Optional.ofNullable((OAuthToken)StorageUtils.deserialize((byte[])this.store.getWithString(OAuthTokenIndex.getGitHubKey(username))));
    }

    public void storeUserOAuthToken(String username, OAuthToken token) throws StorageException {
        this.store.putWithString(OAuthTokenIndex.getGitHubKey(username), StorageUtils.serialize((Serializable)token));
    }

    public void removeToken(String tokenName) throws StorageException {
        this.store.removeWithString(OAuthTokenIndex.getGitHubKey(tokenName));
    }

    private static String getGitHubKey(String username) {
        return username + GITHUB_USER_KEY_SUFFIX;
    }

    @IndexValueClass(containedInBackup=true)
    public static class OAuthToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String username;
        private final String token;

        public OAuthToken(String username, String token) {
            this.username = username;
            this.token = token;
        }

        public String getUsername() {
            return this.username;
        }

        public String getToken() {
            return this.token;
        }
    }
}

