/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.ldap;

import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.ImportUsersStrategyBase;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.ldap.LDAPServerDescription;
import com.teamscale.core.authenticate.ldap.LDAPUtils;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

class LDAPImportUsersStrategy
extends ImportUsersStrategyBase<LDAPServerDescription> {
    private final ServerOptionIndex optionIndex;
    private final UserIndex userIndex;
    private final IMessageBroker messageBroker;

    public LDAPImportUsersStrategy(NamedServer<LDAPServerDescription> server, ServerOptionIndex optionIndex, UserIndex userIndex, IMessageBroker messageBroker) {
        super(server);
        this.optionIndex = optionIndex;
        this.userIndex = userIndex;
        this.messageBroker = messageBroker;
    }

    @Override
    public List<User> importUser(String userName) throws StorageException, AuthenticationToolException {
        return CollectionUtils.emptyListIfEmpty(LDAPUtils.updateOrImportUser(userName, (LDAPServerDescription)this.getServer().serverDescription(), this.getServer().name(), this.userIndex, this.optionIndex, this.messageBroker));
    }
}

