/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.committree;

import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.committree.CommitSchedulingResult;
import com.teamscale.core.committree.CommitTreeCloneHelper;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.precommit.PreCommitUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class CommitTree
implements IChangeRetrieverCommitTree {
    private static final long serialVersionUID = 1L;
    private Map<CommitTreeRevision, CommitTreeNode> nodesByRevision = new HashMap<CommitTreeRevision, CommitTreeNode>();
    private Map<String, CommitTreeNode> latestContainedNodeByBranch = new HashMap<String, CommitTreeNode>();
    private Map<CommitDescriptor, CommitTreeNode> nodesByAdjustedCommit = new HashMap<CommitDescriptor, CommitTreeNode>();
    private long lastExpandedTimestampInMs = 0L;
    private CommitTreeIndex commitTreeIndex;
    private Set<String> liveBranchNames = new HashSet<String>();
    private static final Logger LOGGER = LogManager.getLogger();

    CommitTree(CommitTreeIndex commitTreeIndex) {
        this.initAfterDeserialization(commitTreeIndex);
    }

    CommitTree(Map<CommitTreeRevision, CommitTreeNode> nodesByRevision, Map<String, CommitTreeNode> latestContainedNodeByBranch, Map<CommitDescriptor, CommitTreeNode> nodesByAdjustedCommit, long lastExpandedTimestampInMs, CommitTreeIndex commitTreeIndex, Set<String> liveBranchNames) {
        this(commitTreeIndex);
        this.nodesByRevision = nodesByRevision;
        this.latestContainedNodeByBranch = latestContainedNodeByBranch;
        this.nodesByAdjustedCommit = nodesByAdjustedCommit;
        this.lastExpandedTimestampInMs = lastExpandedTimestampInMs;
        this.liveBranchNames = liveBranchNames;
    }

    void initAfterDeserialization(CommitTreeIndex commitTreeIndex) {
        this.commitTreeIndex = commitTreeIndex;
    }

    @Override
    public boolean nodeExists(CommitTreeRevision revision) {
        return this.nodesByRevision.get(revision) != null;
    }

    @Override
    public UnmodifiableSet<String> getLiveBranchNames() {
        return CollectionUtils.asUnmodifiable(this.liveBranchNames);
    }

    @Override
    public void setLiveBranchNames(Collection<String> branchNames) {
        this.liveBranchNames.clear();
        this.liveBranchNames.addAll(branchNames);
    }

    @Override
    public CommitTreeNode findScheduledNodeByAdjustedCommitDescriptor(CommitDescriptor commit, @Nullable UUID rollbackId) throws RepositoryNeedsRollbackException {
        CommitTreeNode node = this.nodesByAdjustedCommit.get(commit);
        if (node != null && node.getState() == ECommitTreeNodeState.SCHEDULED) {
            return node;
        }
        String error = node == null ? "Did not find scheduled revision for commit " + String.valueOf(commit) + " and also no dangling node!" : "Did not find scheduled revision for commit " + String.valueOf(commit) + ", but found node in state " + String.valueOf((Object)node.getState());
        LOGGER.error(error);
        HashMap<String, Long> rollbackTo = new HashMap<String, Long>();
        rollbackTo.put(commit.getBranchName(), commit.getTimestamp() - 1L);
        throw new RepositoryNeedsRollbackException(error + ". Rollback to " + String.valueOf(commit), rollbackTo, rollbackId);
    }

    @Override
    public CommitTreeNode getNextSchedulableNode() {
        for (CommitTreeNode node : this.nodesByRevision.values()) {
            if (!node.isSchedulable()) continue;
            return node;
        }
        return null;
    }

    @Override
    public boolean hasScheduledNodes() {
        return this.nodesByRevision.values().stream().anyMatch(node -> node.getState() == ECommitTreeNodeState.SCHEDULED);
    }

    @Override
    public boolean hasSchedulableNodes() {
        return this.getNextSchedulableNode() != null;
    }

    @Override
    public CommitSchedulingResult extractAndUpdateSchedulableCommits(Predicate<CommitTreeNode> skipOracle) {
        ArrayList<ParentedCommitDescriptor> schedulableCommits = new ArrayList<ParentedCommitDescriptor>();
        ArrayList<CommitDescriptor> schedulingAnnouncements = new ArrayList<CommitDescriptor>();
        List sortedByTimestamp = CollectionUtils.sort(this.nodesByRevision.values(), Comparator.comparingLong(node -> node.getAdjustedTimestamp().orElse(node.getOriginalTimestamp())));
        for (CommitTreeNode node2 : sortedByTimestamp) {
            if (!node2.isSchedulable()) {
                if (!node2.isPreAnnounceable() || skipOracle.test(node2)) continue;
                schedulingAnnouncements.add(node2.getCommitDescriptorWithAdjustedTimestamp());
                continue;
            }
            if (skipOracle.test(node2)) {
                node2.setSkipped();
                continue;
            }
            node2.setScheduled();
            List<CommitTreeNode> parents = node2.getNonEmptyParents();
            List parentCommits = Stream.concat(parents.stream().map(CommitTreeNode::getCommitDescriptorWithAdjustedTimestamp), Stream.ofNullable(node2.getInjectedParent())).collect(Collectors.toList());
            ParentedCommitDescriptor parentedDescriptor = new ParentedCommitDescriptor(node2.getCommitDescriptorWithAdjustedTimestamp(), parentCommits);
            schedulableCommits.add(parentedDescriptor);
        }
        return new CommitSchedulingResult(schedulableCommits, schedulingAnnouncements);
    }

    @Override
    public void persist() throws StorageException {
        this.commitTreeIndex.storeTree(this);
    }

    public Set<String> getKnownBranchNames() {
        return new HashSet<String>(CollectionUtils.map(this.nodesByRevision.values(), CommitTreeNode::getBranchName));
    }

    public List<CommitTreeNode> getAllNodes() {
        return new ArrayList<CommitTreeNode>(this.nodesByRevision.values());
    }

    @Override
    public List<CommitTreeNode> getAllRawNodes() {
        return this.getAllNodes();
    }

    @Override
    public ICommitTreeNode addNode(CommitTreeRevision revision, long timestamp, List<CommitTreeRevision> parentRevisions, Consumer<String> errorHandler, CommitDescriptor injectedParent, long commitDiscoveryTime) {
        if (this.nodesByRevision.containsKey(revision)) {
            errorHandler.accept("Adding node already added: " + String.valueOf(revision));
        }
        CommitTreeNode node = new CommitTreeNode(revision, timestamp, commitDiscoveryTime);
        for (CommitTreeRevision parentRevision : parentRevisions) {
            CommitTreeNode parent = this.nodesByRevision.get(parentRevision);
            if (parent == null) {
                errorHandler.accept("Passed in unknown parent revision " + String.valueOf(parentRevision));
                continue;
            }
            node.addParent(parent);
        }
        node.forceLatestFirstParent();
        if (injectedParent != null) {
            node.setInjectedParent(injectedParent);
        }
        node.adopt(this);
        CommitTreeRevision nodeRevision = node.getRevision();
        this.nodesByRevision.put(nodeRevision, node);
        String branchName = nodeRevision.getBranchName();
        CommitTreeNode latestNode = this.latestContainedNodeByBranch.get(branchName);
        if (latestNode != null) {
            CommitTreeRevision latestRevision = latestNode.getRevision();
            if (!node.getParentRevisions().contains(latestRevision)) {
                CommitTreeRevision latest = latestNode.getRevision();
                String message = CommitTree.buildBranchConsistencyWarningMessage(node, latest);
                errorHandler.accept(message);
            }
        }
        this.latestContainedNodeByBranch.put(branchName, node);
        return node;
    }

    private static String buildBranchConsistencyWarningMessage(CommitTreeNode node, CommitTreeRevision latestRevision) {
        return "Added revision " + String.valueOf(node.getRevision()) + " should reference latest revision " + String.valueOf(latestRevision) + " but does only reference " + String.valueOf(node.getParentRevisions()) + "!";
    }

    private CommitTreeNode resolveLatestNodeForBranch(String branchName) {
        return this.latestContainedNodeByBranch.get(branchName);
    }

    @Override
    public ICommitTreeNode getNodeByBranchAndAdjustedTimestamp(String branchName, long timestamp) {
        return this.nodesByAdjustedCommit.get(new CommitDescriptor(branchName, timestamp));
    }

    void updateAdjustment(CommitTreeNode node) {
        CommitDescriptor adjustedCommitDescriptor = node.getCommitDescriptorWithAdjustedTimestamp();
        for (CommitTreeNode parent : node.getParents()) {
            long adjustedTimestampOfParent = parent.getAdjustedTimestamp().orElseThrow(() -> new IllegalStateException("Cannot adjust a node with non-adjusted parent " + String.valueOf(parent)));
            if (adjustedCommitDescriptor.getTimestamp() >= adjustedTimestampOfParent) continue;
            LOGGER.error("{} is inconsistent, because its adjusted timestamp is earlier than the adjusted timestamp of the parent {}.", (Object)node, (Object)parent);
        }
        this.nodesByAdjustedCommit.put(adjustedCommitDescriptor, node);
    }

    @Override
    public ICommitTreeNode getNodeByRevision(CommitTreeRevision commitTreeRevision) {
        return this.nodesByRevision.get(commitTreeRevision);
    }

    @Override
    public Optional<String> getLatestContainedRevisionForBranch(String branchName) {
        return Optional.ofNullable(this.latestContainedNodeByBranch.get(branchName)).map(node -> node.getRevision().getRevision());
    }

    @Override
    public Optional<String> getLatestContainedRevisionForBranch(ICommitTreeNode commitTreeNode) {
        return this.getLatestContainedRevisionForBranch(commitTreeNode.getBranchName());
    }

    @Override
    public Set<String> getAllKnownBranchNames() {
        return CollectionUtils.asUnmodifiable(this.latestContainedNodeByBranch.keySet());
    }

    @Override
    public boolean isEmpty() {
        return this.latestContainedNodeByBranch.isEmpty();
    }

    void performRollback(Map<String, Long> timestampByBranch) {
        Map<String, Long> normalRollbacks;
        if (timestampByBranch.isEmpty()) {
            return;
        }
        Map<Boolean, Map<String, Long>> timestampByBranchByPreCommitGrouping = timestampByBranch.entrySet().stream().collect(Collectors.partitioningBy(entry -> PreCommitUtils.isPrecommitBranch((String)entry.getKey()), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        Map<String, Long> preCommitRollbacks = timestampByBranchByPreCommitGrouping.get(true);
        if (!preCommitRollbacks.isEmpty()) {
            this.applyPreCommitRollback(preCommitRollbacks.keySet());
        }
        if (!(normalRollbacks = timestampByBranchByPreCommitGrouping.get(false)).isEmpty()) {
            this.applyNormalRollback(normalRollbacks);
        }
    }

    private void applyPreCommitRollback(Set<String> preCommitRollbackBranchNames) {
        this.nodesByRevision.keySet().removeIf(revision -> preCommitRollbackBranchNames.contains(revision.getBranchName()));
        preCommitRollbackBranchNames.forEach(this.latestContainedNodeByBranch::remove);
        this.nodesByAdjustedCommit.keySet().removeIf(commit -> preCommitRollbackBranchNames.contains(commit.getBranchName()));
    }

    private void applyNormalRollback(Map<String, Long> timestampByBranch) {
        HashSet<CommitTreeRevision> deletedRevisions = new HashSet<CommitTreeRevision>();
        for (CommitTreeNode node : this.nodesByRevision.values()) {
            String branchName;
            Long deletionTimestamp;
            if (!CommitTree.containedInRollbackDeletion(node, deletionTimestamp = timestampByBranch.get(branchName = node.getRevision().getBranchName()), deletedRevisions)) continue;
            deletedRevisions.add(node.getRevision());
        }
        this.nodesByRevision.keySet().removeAll(deletedRevisions);
        this.lastExpandedTimestampInMs = 0L;
        this.rebuildDerivedDataStructures();
    }

    private static boolean containedInRollbackDeletion(CommitTreeNode node, Long deletionTimestamp, Set<CommitTreeRevision> deletedRevisions) {
        if (node.getAdjustedTimestamp().isEmpty()) {
            return true;
        }
        if (deletionTimestamp != null && node.getAdjustedTimestamp().getAsLong() > deletionTimestamp) {
            return true;
        }
        for (CommitTreeRevision parentRevision : node.getParentRevisions()) {
            CCSMAssert.isFalse((boolean)deletedRevisions.contains(parentRevision), (String)"Non-deleted node is not expected to have deleted parents!");
        }
        return false;
    }

    @Override
    public Optional<String> resolveLatestRevisionBefore(String branchName, long timestamp) {
        CommitTreeNode latestNode = this.resolveLatestNodeForBranch(branchName);
        if (latestNode == null) {
            return Optional.empty();
        }
        if (latestNode.getOriginalTimestamp() <= timestamp) {
            return Optional.of(latestNode.getRevision().getRevision());
        }
        return this.getAllNodes().stream().filter(node -> node.getBranchName().equals(branchName) && node.getOriginalTimestamp() <= timestamp).max(Comparator.comparing(CommitTreeNode::getOriginalTimestamp)).map(node -> node.getRevision().getRevision());
    }

    public boolean hasScheduledAdjustedCommit(CommitDescriptor adjustedCommit) {
        CommitTreeNode node = this.nodesByAdjustedCommit.get(adjustedCommit);
        return node != null && node.getState() == ECommitTreeNodeState.SCHEDULED;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Map<String, Integer> branchToIndex = this.writeBranchNames(out);
        ArrayList<CommitTreeNode> allNodes = new ArrayList<CommitTreeNode>(this.nodesByRevision.values());
        HashMap<CommitTreeRevision, Integer> revisionToIndex = new HashMap<CommitTreeRevision, Integer>();
        out.writeInt(allNodes.size());
        for (int i = 0; i < allNodes.size(); ++i) {
            CommitTreeNode node = (CommitTreeNode)allNodes.get(i);
            revisionToIndex.put(node.getRevision(), i);
            out.writeInt(branchToIndex.get(node.getRevision().getBranchName()));
            out.writeUTF(node.getRevision().getRevision());
            out.writeByte(node.getState().ordinal());
            out.writeLong(node.getOriginalTimestamp());
            out.writeLong(node.getAdjustedTimestamp().orElse(-1L));
            out.writeLong(node.getDiscoveryTimestamp());
            out.writeObject(node.getInjectedParent());
        }
        for (CommitTreeNode node : allNodes) {
            out.writeInt(node.getParentRevisions().size());
            for (CommitTreeNode parent : node.getParents()) {
                out.writeInt((Integer)revisionToIndex.get(parent.getRevision()));
            }
        }
        out.writeInt(this.liveBranchNames.size());
        for (String liveBranchName : CollectionUtils.sort(this.liveBranchNames)) {
            out.writeInt(branchToIndex.get(liveBranchName));
        }
        out.writeLong(this.lastExpandedTimestampInMs);
    }

    private Map<String, Integer> writeBranchNames(ObjectOutputStream out) throws IOException {
        List<String> branchNames = new ArrayList(CollectionUtils.unionSet(this.getKnownBranchNames(), (Collection[])new Collection[]{this.liveBranchNames})).stream().filter(Objects::nonNull).toList();
        HashMap<String, Integer> branchToIndex = new HashMap<String, Integer>();
        branchToIndex.put(null, -1);
        for (int i = 0; i < branchNames.size(); ++i) {
            branchToIndex.put(branchNames.get(i), i);
        }
        out.writeInt(branchNames.size());
        for (String branchName : branchNames) {
            out.writeUTF(branchName);
        }
        return branchToIndex;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ArrayList<String> branchNames = new ArrayList<String>();
        int branchCount = in.readInt();
        for (int i = 0; i < branchCount; ++i) {
            branchNames.add(in.readUTF());
        }
        this.nodesByAdjustedCommit = new HashMap<CommitDescriptor, CommitTreeNode>();
        this.latestContainedNodeByBranch = new HashMap<String, CommitTreeNode>();
        this.nodesByRevision = new HashMap<CommitTreeRevision, CommitTreeNode>();
        this.liveBranchNames = new HashSet<String>();
        List<CommitTreeNode> allNodes = this.readNodes(in, branchNames);
        for (CommitTreeNode node : allNodes) {
            int parentCount = in.readInt();
            for (int i = 0; i < parentCount; ++i) {
                node.addParent(allNodes.get(in.readInt()));
            }
            this.nodesByRevision.put(node.getRevision(), node);
        }
        int liveBranchCount = in.readInt();
        for (int i = 0; i < liveBranchCount; ++i) {
            this.liveBranchNames.add((String)branchNames.get(in.readInt()));
        }
        if (in.available() >= 8) {
            this.lastExpandedTimestampInMs = in.readLong();
        }
        this.rebuildDerivedDataStructures();
    }

    private List<CommitTreeNode> readNodes(ObjectInputStream in, List<String> branchNames) throws IOException, ClassNotFoundException {
        ArrayList<CommitTreeNode> allNodes = new ArrayList<CommitTreeNode>();
        int nodeCount = in.readInt();
        for (int i = 0; i < nodeCount; ++i) {
            int branchNameIndex = in.readInt();
            String branchName = null;
            if (branchNameIndex >= 0) {
                branchName = branchNames.get(branchNameIndex);
            }
            String revision = in.readUTF();
            ECommitTreeNodeState state = ECommitTreeNodeState.values()[in.readByte()];
            long originalTimestamp = in.readLong();
            long adjustedTimestamp = in.readLong();
            long discoveryTimestamp = in.readLong();
            CommitDescriptor injectedParent = (CommitDescriptor)in.readObject();
            CommitTreeNode node = new CommitTreeNode(new CommitTreeRevision(revision, branchName), originalTimestamp, discoveryTimestamp);
            allNodes.add(node);
            node.adopt(this);
            if (adjustedTimestamp != -1L) {
                node.setAdjustedTimestamp(adjustedTimestamp);
            }
            if (injectedParent != null) {
                node.setInjectedParent(injectedParent);
            }
            node.setStateUnchecked(state);
        }
        return allNodes;
    }

    private void rebuildDerivedDataStructures() {
        this.nodesByAdjustedCommit.clear();
        this.latestContainedNodeByBranch.clear();
        SetMap childNodesByNode = new SetMap();
        Collection<CommitTreeNode> nodes = this.nodesByRevision.values();
        for (CommitTreeNode node : nodes) {
            if (node.getAdjustedTimestamp().isPresent()) {
                CCSMAssert.isTrue((node.getState() != ECommitTreeNodeState.UNPROCESSED ? 1 : 0) != 0, () -> "Encountered unprocessed node that has adjusted timestamp: " + String.valueOf(node));
                this.nodesByAdjustedCommit.put(node.getCommitDescriptorWithAdjustedTimestamp(), node);
            }
            node.getParents().forEach(parent -> childNodesByNode.add(parent, (Object)node));
        }
        for (CommitTreeNode node : nodes) {
            Set children = (Set)childNodesByNode.getCollectionOrEmpty((Object)node);
            this.updateLatestContainedNode(node, children);
        }
    }

    private void updateLatestContainedNode(CommitTreeNode node, Set<CommitTreeNode> children) {
        String branchName = node.getBranchName();
        for (CommitTreeNode child : children) {
            if (!branchName.equals(child.getBranchName())) continue;
            return;
        }
        this.latestContainedNodeByBranch.merge(branchName, node, (currentLatestNode, newNode) -> {
            long newNodeTimestamp;
            long currentNodeTimestamp = currentLatestNode.getAdjustedTimestamp().orElse(node.getOriginalTimestamp());
            if (currentNodeTimestamp < (newNodeTimestamp = newNode.getAdjustedTimestamp().orElse(node.getOriginalTimestamp()))) {
                return newNode;
            }
            return currentLatestNode;
        });
    }

    @Override
    public void setLastExpanded(long expansionTimestamp) {
        this.lastExpandedTimestampInMs = expansionTimestamp;
    }

    @Override
    public void resetLastExpandedTimestamp() {
        this.lastExpandedTimestampInMs = 0L;
    }

    @Override
    public boolean wasExpandedWithinTimespan(int timespanSeconds) {
        if (this.lastExpandedTimestampInMs <= 0L) {
            return false;
        }
        return Instant.ofEpochMilli(this.lastExpandedTimestampInMs).plus((long)timespanSeconds, ChronoUnit.SECONDS).isAfter(Instant.now());
    }

    @Override
    public boolean isForceExpansionPending() {
        return this.lastExpandedTimestampInMs <= 0L;
    }

    @Override
    public IChangeRetrieverCommitTree deepAnonymizedCopy(Function<String, String> branchNameAnonymizer) {
        return CommitTreeCloneHelper.deepCopy(this.nodesByRevision, this.latestContainedNodeByBranch, this.nodesByAdjustedCommit, this.liveBranchNames, this.lastExpandedTimestampInMs, branchNameAnonymizer);
    }
}

