/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.findings.FindingTypeDescription;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.cache.StorageCacheBase;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.FileExtensionFilter;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class FindingsDescriptionOverrideCache
extends StorageCacheBase {
    public static final String FINDING_DESCRIPTION_FOLDER = "finding-descriptions";
    protected static final String CUSTOM_DESCRIPTION_EXTENSION = ".md";
    private final LoadingCache<Pair<EAnalysisTool, String>, String> cache = CacheBuilder.newBuilder().maximumSize(2000L).build((CacheLoader)new CacheLoader<Pair<EAnalysisTool, String>, String>(this){
        final /* synthetic */ FindingsDescriptionOverrideCache this$0;
        {
            FindingsDescriptionOverrideCache findingsDescriptionOverrideCache = this$0;
            Objects.requireNonNull(findingsDescriptionOverrideCache);
            this.this$0 = findingsDescriptionOverrideCache;
        }

        public String load(@NonNull Pair<EAnalysisTool, String> key) {
            return this.this$0.fetchDescriptionFromFile((EAnalysisTool)((Object)key.getFirst()), (String)key.getSecond());
        }
    });
    private Set<Pair<EAnalysisTool, String>> availableDescriptionsKeys = null;
    private static final Logger LOGGER = LogManager.getLogger();

    public void invalidateThreadSafe() {
        this.cache.invalidateAll();
        this.availableDescriptionsKeys = null;
    }

    public FindingTypeDescription adjustDescription(FindingTypeDescription typeDescription) {
        String description = this.getDescription(typeDescription.getTool(), typeDescription.getName());
        if (description != null) {
            return new FindingTypeDescription(typeDescription.getName(), FindingsDescriptionOverrideCache.handlePrefixCustomFindingDescriptionFeatureToggle(description, typeDescription.getDescription()), typeDescription.getTool());
        }
        return typeDescription;
    }

    public FindingDescriptor adjustDescription(FindingDescriptor descriptor) {
        String description = this.getDescription(descriptor.getTool(), descriptor.getReadableName());
        if (description != null) {
            return new FindingDescriptor(descriptor.getName(), descriptor.getReadableName(), descriptor.getTool(), descriptor.getLanguages(), descriptor.getEnablement(), FindingsDescriptionOverrideCache.handlePrefixCustomFindingDescriptionFeatureToggle(description, descriptor.getDescription()));
        }
        return descriptor;
    }

    private @Nullable String getDescription(EAnalysisTool tool, String name) {
        this.ensureCacheIsValid();
        try {
            String escapedName = FileSystemUtils.toValidFileName((String)name);
            if (this.availableDescriptionsKeys.contains(Pair.createPair((Object)((Object)tool), (Object)escapedName))) {
                return (String)this.cache.get((Object)Pair.createPair((Object)((Object)tool), (Object)escapedName));
            }
            return null;
        }
        catch (ExecutionException e) {
            LOGGER.catching((Throwable)e);
            return null;
        }
    }

    private static String handlePrefixCustomFindingDescriptionFeatureToggle(String customDescription, String originalDescirption) {
        if (EFeatureToggle.PREFIX_CUSTOM_FINDING_DESCRIPTION.isEnabled()) {
            return customDescription + "\n\n---\n\n" + originalDescirption;
        }
        return customDescription;
    }

    public Set<Pair<EAnalysisTool, String>> getAllCacheKeys() {
        this.ensureCacheIsValid();
        return this.availableDescriptionsKeys;
    }

    private void ensureCacheIsValid() {
        if (this.availableDescriptionsKeys == null) {
            this.initializeCache();
        }
    }

    protected @Nullable String fetchDescriptionFromFile(EAnalysisTool tool, String name) {
        Optional pathOptional = TeamscaleInstallationUtils.locateConfigFile((String)FINDING_DESCRIPTION_FOLDER);
        if (pathOptional.isPresent()) {
            Path descriptionPath = Paths.get(((File)pathOptional.get()).getAbsolutePath(), tool.name(), name + CUSTOM_DESCRIPTION_EXTENSION);
            if (Files.exists(descriptionPath, new LinkOption[0])) {
                try {
                    return FileSystemUtils.readFileUTF8((Path)descriptionPath.toAbsolutePath());
                }
                catch (IOException e) {
                    LOGGER.catching((Throwable)e);
                }
            } else {
                LOGGER.warn(String.format("File %s cannot be found in %s", descriptionPath, pathOptional.get()));
            }
        }
        return null;
    }

    private void initializeCache() {
        if (this.availableDescriptionsKeys == null) {
            this.availableDescriptionsKeys = new HashSet<Pair<EAnalysisTool, String>>();
        }
        for (File descriptionFile : this.getCustomDescriptionFiles()) {
            FindingsDescriptionOverrideCache.getKeyFromPath(descriptionFile).ifPresent(this.availableDescriptionsKeys::add);
        }
        this.availableDescriptionsKeys = CollectionUtils.asUnmodifiable(this.availableDescriptionsKeys);
    }

    protected List<File> getCustomDescriptionFiles() {
        Optional pathOptional = TeamscaleInstallationUtils.locateConfigFile((String)FINDING_DESCRIPTION_FOLDER);
        if (pathOptional.isPresent()) {
            File path = (File)pathOptional.get();
            return FileSystemUtils.listFilesRecursively((File)path, (FileFilter)new FileExtensionFilter(new String[]{"md"}));
        }
        return CollectionUtils.emptyList();
    }

    private static Optional<Pair<EAnalysisTool, String>> getKeyFromPath(File file) {
        List<String> segments = Arrays.asList(FileSystemUtils.getPathSegments((String)file.getPath()));
        List<String> findingDescriptionList = segments.subList(segments.indexOf(FINDING_DESCRIPTION_FOLDER), segments.size());
        if (findingDescriptionList.size() == 3) {
            EAnalysisTool tool = (EAnalysisTool)EnumUtils.valueOfIgnoreCase(EAnalysisTool.class, (String)file.getParentFile().getName());
            return Optional.of(Pair.createPair((Object)((Object)tool), (Object)FileSystemUtils.getFilenameWithoutExtension((Path)file.toPath())));
        }
        return Optional.empty();
    }

    String addCustomDescriptionTestOnly(FindingTypeDescription typeDescription) {
        this.ensureCacheIsValid();
        Pair key = Pair.createPair((Object)((Object)typeDescription.getTool()), (Object)typeDescription.getName());
        HashSet<Pair<EAnalysisTool, String>> keys = new HashSet<Pair<EAnalysisTool, String>>(this.availableDescriptionsKeys);
        keys.add((Pair<EAnalysisTool, String>)key);
        this.availableDescriptionsKeys = CollectionUtils.asUnmodifiable(keys);
        this.cache.asMap().put(key, typeDescription.getDescription());
        return "";
    }
}

