/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings;

import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.findings.FindingsSchemaEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class FindingsSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, FindingsSchemaEntry> mappings = new HashMap<String, FindingsSchemaEntry>();

    private FindingsSchemaEntry getMapping(String findingTypeId) {
        return this.mappings.get(findingTypeId);
    }

    public void addMapping(String findingTypeId, FindingDescriptor findingDescriptor) {
        this.mappings.put(findingTypeId, new FindingsSchemaEntry(findingDescriptor));
    }

    public IndexFinding adaptFinding(IndexFinding finding) {
        FindingsSchemaEntry mapping = this.getMapping(finding.getTypeId());
        if (mapping == null) {
            return null;
        }
        ETrafficLightColor color = finding.getAssessment();
        switch (mapping.getFindingEnablement()) {
            case RED: {
                color = ETrafficLightColor.RED;
                break;
            }
            case YELLOW: {
                color = ETrafficLightColor.YELLOW;
                break;
            }
            case AUTO: {
                break;
            }
            case OFF: 
            case UNDECIDED: {
                return null;
            }
            default: {
                CCSMAssert.fail((String)("Unknown finding enablement: " + String.valueOf(mapping.getFindingEnablement())));
            }
        }
        IndexFinding result = new IndexFinding(finding);
        result.setCategoryName(mapping.getCategory());
        result.setGroupName(mapping.getGroup());
        result.setAssessment(color);
        return result;
    }

    public List<String> getEnabledFindingTypeIds() {
        ArrayList<String> enabledFindingTypes = new ArrayList<String>();
        for (Map.Entry<String, FindingsSchemaEntry> entry : this.mappings.entrySet()) {
            if (!entry.getValue().getFindingEnablement().isEnabled()) continue;
            enabledFindingTypes.add(entry.getKey());
        }
        return enabledFindingTypes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.mappings.forEach((key, value) -> builder.append((String)key).append(" -> ").append(value).append("\n"));
        return builder.toString();
    }
}

