/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings.metrics;

import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.string.StringUtils;

public abstract class FindingsMetricBase {
    private static final Pattern SPACES = Pattern.compile("\\s+");
    private static final Pattern NON_WORDS = Pattern.compile("[^A-Za-z0-9-]");
    protected final String id;
    protected final String name;
    protected final String description;
    protected final ETrafficLightColor color;

    protected FindingsMetricBase(String id, String name, String description, ETrafficLightColor color) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.color = color;
    }

    public abstract void registerInSchema(MetricSchemaProxy var1) throws ProjectConfigurationException;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ETrafficLightColor getColor() {
        return this.color;
    }

    protected static String generateIdFromName(String name, String ... suffixesToAppend) {
        StringBuilder generatedId = new StringBuilder(name);
        for (String suffix : suffixesToAppend) {
            generatedId.append("-");
            generatedId.append(suffix);
        }
        return FindingsMetricBase.normalizeId(generatedId.toString());
    }

    private static String normalizeId(String id) {
        return FindingsMetricBase.normalizeNonWords(FindingsMetricBase.normalizeSpaces(id.toLowerCase()));
    }

    private static String normalizeSpaces(String id) {
        return SPACES.matcher(id).replaceAll("-");
    }

    private static String normalizeNonWords(String id) {
        return NON_WORDS.matcher(id).replaceAll("");
    }

    protected static String getColorString(ETrafficLightColor color, String prefix, String suffix) {
        return FindingsMetricBase.getColorString(color, prefix, suffix, false);
    }

    protected static String getColorString(ETrafficLightColor color, String prefix, String suffix, boolean capitalize) {
        if (color == ETrafficLightColor.UNKNOWN) {
            return "";
        }
        CCSMAssert.isTrue((color == ETrafficLightColor.YELLOW || color == ETrafficLightColor.RED ? 1 : 0) != 0, (String)"Only yellow and red findings are supported.");
        String colorString = color.toString().toLowerCase();
        if (capitalize) {
            colorString = StringUtils.capitalize((String)colorString);
        }
        return prefix + colorString + suffix;
    }

    public static String getColorString(ETrafficLightColor color) {
        return FindingsMetricBase.getColorString(color, "", "");
    }
}

