/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.NonNull;

final class CompactParentedCommitDescriptorSerializer
implements ISerializer<ParentedCommitDescriptor, byte[]> {
    CompactParentedCommitDescriptorSerializer() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte @NonNull [] serialize(@NonNull ParentedCommitDescriptor value) throws StorageException {
        try (ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(byteBuffer);){
                CompactParentedCommitDescriptorSerializer.write(value, out);
                byArray = byteBuffer.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new StorageException("Unexpected exception while serializing ParentedCommitDescriptor", (Throwable)e);
        }
    }

    private static void write(ParentedCommitDescriptor value, DataOutput out) throws IOException {
        CompactParentedCommitDescriptorSerializer.writeCommit(out, value.getCommit());
        UnmodifiableList parentCommits = value.getParentCommits();
        out.writeInt(parentCommits.size());
        for (CommitDescriptor parent : parentCommits) {
            CompactParentedCommitDescriptorSerializer.writeCommit(out, parent);
        }
    }

    private static void writeCommit(DataOutput out, CommitDescriptor commit) throws IOException {
        out.writeUTF(commit.getBranchName());
        out.writeLong(commit.getTimestamp());
    }

    public @NonNull ParentedCommitDescriptor deserialize(byte @NonNull [] value) throws StorageException {
        ParentedCommitDescriptor parentedCommitDescriptor;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(value));
        try {
            parentedCommitDescriptor = CompactParentedCommitDescriptorSerializer.read(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new StorageException("Unexpected exception while deserializing ParentedCommitDescriptor", (Throwable)e);
            }
        }
        in.close();
        return parentedCommitDescriptor;
    }

    private static ParentedCommitDescriptor read(DataInput in) throws IOException {
        CommitDescriptor commit = CompactParentedCommitDescriptorSerializer.readCommit(in);
        int parentCount = in.readInt();
        ArrayList<CommitDescriptor> parentCommits = new ArrayList<CommitDescriptor>(parentCount);
        for (int i = 0; i < parentCount; ++i) {
            parentCommits.add(CompactParentedCommitDescriptorSerializer.readCommit(in));
        }
        return new ParentedCommitDescriptor(commit, parentCommits);
    }

    private static CommitDescriptor readCommit(DataInput in) throws IOException {
        String branchName = in.readUTF();
        long timestamp = in.readLong();
        return new CommitDescriptor(branchName, timestamp);
    }
}

