/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.worker;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.log.LogCount;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.worker.DetailedWorkerLog;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.core.runtime.impl.analysis.ETriggerExecutionResultState;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.jetbrains.annotations.VisibleForTesting;

public class WorkerLogData {
    final ShortWorkerLog shortWorkerLog;
    final DetailedWorkerLog detailedWorkerLog;

    @VisibleForTesting
    public WorkerLogData(ShortWorkerLog shortWorkerLog, DetailedWorkerLog detailedWorkerLog) {
        Preconditions.checkNotNull((Object)shortWorkerLog);
        Preconditions.checkState((shortWorkerLog.hasDetailedLog == (detailedWorkerLog != null) ? 1 : 0) != 0, (Object)"Must supply detailed worker log if short worker indicates  that a detailed worker log exists.");
        this.shortWorkerLog = shortWorkerLog;
        this.detailedWorkerLog = detailedWorkerLog;
    }

    @VisibleForTesting
    public WorkerLogData(ShortWorkerLog shortWorkerLog) {
        this(shortWorkerLog, null);
    }

    public static WorkerLogData create(String workerId, long startTime, JobDescriptor job, InternalProjectId publicProjectId, List<LoggingEventTransport> loggingEvents, Collection<IIndexDelta> inputDeltas, ETriggerExecutionResultState result) {
        return WorkerLogData.create(workerId, startTime, job, publicProjectId, job.getSchedulingCommitDescriptor(), loggingEvents, inputDeltas, result);
    }

    public static WorkerLogData create(String workerId, long startTime, JobDescriptor job, InternalProjectId publicProjectId, CommitDescriptor commit, List<LoggingEventTransport> loggingEvents, Collection<IIndexDelta> inputDeltas, ETriggerExecutionResultState result) {
        DetailedWorkerLog detailedWorkerLog = WorkerLogData.createDetailedWorkerLog(LogEntryIdentifier.freshWithTimestamp(startTime), loggingEvents, result, inputDeltas, job.getSchedulingReason(), job.getRollbackId());
        return new WorkerLogData(WorkerLogData.createShortWorkerLog(workerId, startTime, job, publicProjectId, commit, loggingEvents, inputDeltas, result, detailedWorkerLog != null), detailedWorkerLog);
    }

    private static int getInputDeltaSize(Collection<IIndexDelta> inputDeltas) {
        int inputDeltaSize = 0;
        for (IIndexDelta delta : inputDeltas) {
            inputDeltaSize += delta.size();
        }
        return inputDeltaSize;
    }

    private static ShortWorkerLog createShortWorkerLog(String workerId, long startTime, JobDescriptor job, InternalProjectId publicProjectId, CommitDescriptor commit, Collection<LoggingEventTransport> loggingEvents, Collection<IIndexDelta> inputDeltas, ETriggerExecutionResultState result, boolean hasDetailedLog) {
        int debugCount = 0;
        int fatalCount = 0;
        int errorCount = 0;
        int warningCount = 0;
        int infoCount = 0;
        block6: for (LoggingEventTransport event : loggingEvents) {
            switch (event.getLevel()) {
                case DEBUG: {
                    ++debugCount;
                    continue block6;
                }
                case FATAL: {
                    ++fatalCount;
                    continue block6;
                }
                case ERROR: {
                    ++errorCount;
                    continue block6;
                }
                case WARN: {
                    ++warningCount;
                    continue block6;
                }
            }
            ++infoCount;
        }
        boolean hasFailed = result == ETriggerExecutionResultState.FAILED_BADLY;
        int inputDeltaSize = WorkerLogData.getInputDeltaSize(inputDeltas);
        return new ShortWorkerLog(workerId, publicProjectId, job.getTriggerName(), LogEntryIdentifier.freshWithTimestamp(startTime), System.currentTimeMillis(), hasFailed, new LogCount(debugCount, infoCount, warningCount, errorCount, fatalCount), commit, inputDeltaSize, hasDetailedLog);
    }

    private static DetailedWorkerLog createDetailedWorkerLog(LogEntryIdentifier entryIdentifier, List<LoggingEventTransport> loggingEvents, ETriggerExecutionResultState result, Collection<IIndexDelta> inputDeltas, String schedulingReason, UUID rollbackId) {
        if (loggingEvents.isEmpty() && result == ETriggerExecutionResultState.RUN_SUCCESSFULLY) {
            return null;
        }
        return new DetailedWorkerLog(entryIdentifier, loggingEvents, result, inputDeltas, schedulingReason, rollbackId);
    }

    public boolean hasErrorsOrWarnings() {
        return this.shortWorkerLog.getLogCount().warningAndHigher() > 0;
    }
}

