/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.source;

import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.math.MathUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

final class MetricAggregationUtils {
    public static Double aggregateDouble(List<Double> values, MetricDirectorySchemaEntry.EAggregation aggregation) {
        return switch (aggregation) {
            case MetricDirectorySchemaEntry.EAggregation.MIN -> MathUtils.min(values);
            case MetricDirectorySchemaEntry.EAggregation.MAX -> MathUtils.max(values);
            case MetricDirectorySchemaEntry.EAggregation.SUM -> MathUtils.sum(values);
            default -> throw new AssertionError((Object)("Unsupported aggregation: " + String.valueOf((Object)aggregation)));
        };
    }

    public static <T> CounterSet<T> aggregateCounterSet(List<CounterSet<T>> values) {
        CounterSet result = new CounterSet();
        for (CounterSet<T> counterSet : values) {
            result.add(counterSet);
        }
        return result;
    }

    public static Assessment aggregateAssessment(List<Assessment> assessments) {
        Assessment result = new Assessment();
        for (Assessment assessment : assessments) {
            result.add(assessment);
        }
        return result;
    }

    public static Long aggregateTimestamp(List<Long> values, MetricDirectorySchemaEntry.EAggregation aggregation) {
        return switch (aggregation) {
            case MetricDirectorySchemaEntry.EAggregation.MIN -> Collections.min(values);
            case MetricDirectorySchemaEntry.EAggregation.MAX -> Collections.max(values);
            default -> throw new AssertionError((Object)("Unsupported aggregation: " + String.valueOf((Object)aggregation)));
        };
    }

    public static String aggregateStrings(List<String> values) {
        return values.stream().map(value -> value.split(",")).flatMap(Arrays::stream).map(String::trim).filter(Predicate.not(String::isEmpty)).distinct().sorted().collect(Collectors.joining(", "));
    }

    private MetricAggregationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

