/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.IJsonMigration;
import com.teamscale.core.migration.IJsonMigrator;
import com.teamscale.core.migration.MigrationException;
import java.util.Arrays;
import java.util.List;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.NonNull;

public final class JsonMigrator
implements IJsonMigrator {
    private final List<? extends IJsonMigration> migrations;
    public static final JsonMigrator NO_OP_MIGRATOR = new JsonMigrator(new IJsonMigration[0]);

    public JsonMigrator(IJsonMigration ... migrations) {
        this(Arrays.asList(migrations));
    }

    public JsonMigrator(List<? extends IJsonMigration> migrations) {
        this.migrations = migrations;
    }

    @Override
    public @NonNull String migrate(@Language(value="JSON") String json) throws MigrationException {
        try {
            ObjectNode objectNode = (ObjectNode)CCSMAssert.checkedCast((Object)JsonUtils.deserializeFromJson((String)json), ObjectNode.class);
            for (IJsonMigration iJsonMigration : this.migrations) {
                iJsonMigration.migrateJson(objectNode);
            }
            return JsonUtils.serializeToJSON((Object)objectNode);
        }
        catch (JsonSerializationException e) {
            throw new MigrationException(e);
        }
    }

    public UnmodifiableList<? extends IJsonMigration> getMigrations() {
        return CollectionUtils.asUnmodifiable(this.migrations);
    }
}

