/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.options;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import java.util.regex.Pattern;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="instance-label", name="Teamscale instance label", type=EOptionType.SERVER, category=EOptionCategory.SERVER, visibilityFeatureToggle=EFeatureToggle.INSTANCE_LABEL_OPTION_VISIBLE, orderingHint=1000)
@IndexValueClass(containedInBackup=true)
public class InstanceLabelOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "instance-label";
    public static final String OPTION_NAME = "Teamscale instance label";
    @JsonProperty(value="label")
    @OptionFieldDescription(name="A label for the Teamscale instance")
    public String label = "";
    private static final String VALIDATION_PATTERN_STRING = "[a-z0-9]*(?:-[a-z0-9]+)*";
    private static final Pattern VALIDATION_PATTERN = Pattern.compile("[a-z0-9]*(?:-[a-z0-9]+)*");

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (StringUtils.isEmpty((String)this.label) || VALIDATION_PATTERN.matcher(this.label).matches()) {
            return null;
        }
        return "Label format invalid. Teamscale instance labels must conform to this pattern: [a-z0-9]*(?:-[a-z0-9]+)* For Example: instance-label-3";
    }

    public static String getLabel(GlobalStorageSystem globalStorageSystem) throws StorageException {
        ServerOptionIndex optionIndex = (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        InstanceLabelOption option = ServerOptionRegistry.getInstance().getOption("server", OPTION_ID, null, InstanceLabelOption.class, optionIndex);
        if (option == null) {
            return null;
        }
        return option.label;
    }
}

