/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.ISubject;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.RoleAssignment;
import com.teamscale.core.permissions.RoleAssignmentWithGlobalInfo;
import com.teamscale.core.permissions.RoleChange;
import com.teamscale.core.permissions.UserPermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.permissions.roles.GlobalRole;
import com.teamscale.core.permissions.roles.ProjectRole;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class PermissionModifier {
    private final PermissionIndex permissionIndex;
    private final ProjectIndex projectIndex;
    private final UserPermissions userPermissions;

    public PermissionModifier(ProjectIndex projectIndex, PermissionIndex permissionIndex, UserPermissions userPermissions) {
        this.permissionIndex = permissionIndex;
        this.userPermissions = userPermissions;
        this.projectIndex = projectIndex;
    }

    public void makeCurrentUserOwner(EBasicPermissionScope permissionScope, String instanceId) throws StorageException {
        if (permissionScope.createPermission != null) {
            this.userPermissions.checkGlobalPermission(permissionScope.createPermission);
        }
        this.permissionIndex.makeOwner(this.userPermissions.getLoggedInUserChecked(), permissionScope, instanceId);
    }

    public void makeCurrentUserProjectAdmin(ProjectInfo projectInfo) throws StorageException {
        this.userPermissions.checkGlobalPermission(EGlobalPermission.CREATE_PROJECTS);
        this.makeUserProjectAdmin(this.userPermissions.getLoggedInUserChecked(), projectInfo);
    }

    public void removeCurrentUserAsProjectAdmin(ProjectInfo projectInfo) throws StorageException {
        this.permissionIndex.removeProjectAdmin(this.userPermissions.getLoggedInUserChecked(), projectInfo);
    }

    private void makeUserProjectAdmin(ISubject subject, ProjectInfo projectInfo) throws StorageException {
        this.permissionIndex.makeProjectAdmin(subject, projectInfo);
    }

    public void changeGlobalRoleAssignments(RoleChange change) throws StorageException {
        if (change.hasChange()) {
            this.userPermissions.checkGlobalPermission(EGlobalPermission.EDIT_GLOBAL_ROLES);
            this.permissionIndex.changeGlobalRoleAssignments(change);
        }
    }

    public void changeProjectRoleAssignments(IProjectId projectId, RoleChange change) throws StorageException {
        this.userPermissions.getProjectPermissions().checkProjectPermission(this.projectIndex, projectId, EProjectPermission.EDIT_ROLES);
        this.permissionIndex.changeProjectRoleAssignments(projectId, change);
    }

    public void changeProjectRoleAssignments(RoleChange change) throws StorageException {
        this.userPermissions.checkGlobalPermission(EGlobalPermission.EDIT_ROLES);
        this.permissionIndex.changeGlobalProjectRoleAssignments(change);
    }

    public void changeBasicRoleAssignments(EBasicPermissionScope permissionScope, String instanceId, RoleChange change) throws StorageException {
        this.userPermissions.getBasicPermissions().checkBasicPermission(permissionScope, instanceId, EBasicPermission.EDIT_ROLES);
        this.permissionIndex.changeBasicRoleAssignments(permissionScope, instanceId, change);
    }

    public void changeBasicRoleAssignments(EBasicPermissionScope permissionScope, RoleChange change) throws StorageException {
        this.userPermissions.checkGlobalPermission(EGlobalPermission.EDIT_GLOBAL_ROLES);
        this.permissionIndex.changeGlobalBasicRoleAssignments(permissionScope, change);
    }

    public void removeBasicRoleInstanceAssignments(EBasicPermissionScope permissionScope, String instanceId) throws StorageException {
        HashSet<RoleAssignment> instanceSpecificRemovals = new HashSet<RoleAssignment>();
        Set<RoleAssignmentWithGlobalInfo> roles = this.permissionIndex.getBasicRoles(permissionScope, instanceId);
        roles.forEach(role -> {
            if (!role.isGlobal) {
                instanceSpecificRemovals.add(new RoleAssignment(role.subjectType, role.subjectId, role.roleName));
            }
        });
        if (!instanceSpecificRemovals.isEmpty()) {
            this.changeBasicRoleAssignments(permissionScope, instanceId, new RoleChange(Collections.emptySet(), instanceSpecificRemovals));
        }
    }

    public void removeAllBasicRoleAssignmentsForSubject(ISubject subject) throws StorageException {
        this.permissionIndex.deleteAllBasicRoleAssignmentsForSubject(subject.getSubjectType(), subject.getSubjectId());
    }

    public void setGlobalRole(GlobalRole globalRole, String oldGlobalRoleName) throws StorageException {
        this.userPermissions.checkGlobalPermission(EGlobalPermission.EDIT_ROLES);
        this.permissionIndex.setGlobalRole(oldGlobalRoleName, globalRole);
    }

    public void setProjectRole(ProjectRole projectRole, String oldProjectRoleName) throws StorageException {
        this.userPermissions.checkGlobalPermission(EGlobalPermission.EDIT_ROLES);
        this.permissionIndex.setProjectRole(oldProjectRoleName, projectRole);
    }

    public void removeGlobalRole(String globalRoleName) throws StorageException {
        this.userPermissions.checkGlobalPermission(EGlobalPermission.EDIT_ROLES);
        this.permissionIndex.removeGlobalRole(globalRoleName);
    }

    public void removeProjectRole(String projectRoleName) throws StorageException {
        this.userPermissions.checkGlobalPermission(EGlobalPermission.EDIT_ROLES);
        this.permissionIndex.removeProjectRole(projectRoleName);
    }

    public void removeAllProjectRoleAssignments(ProjectInfo project) throws StorageException {
        PublicProjectId primaryId = project.getPrimaryPublicId();
        this.userPermissions.getProjectPermissions().checkProjectPermission(this.projectIndex, (IProjectId)primaryId, EProjectPermission.EDIT_ROLES);
        for (IProjectId projectId : project.getPublicIds()) {
            Set<RoleAssignmentWithGlobalInfo> roles = this.permissionIndex.getProjectRoles(projectId);
            HashSet<RoleAssignment> removedRoles = new HashSet<RoleAssignment>();
            for (RoleAssignmentWithGlobalInfo projectRole : roles) {
                if (projectRole.isGlobal) continue;
                removedRoles.add(projectRole);
            }
            RoleChange change = new RoleChange((Set<RoleAssignment>)CollectionUtils.emptySet(), removedRoles);
            this.permissionIndex.changeProjectRoleAssignments(projectId, change);
        }
    }

    public void deleteRolesForGroup(String groupName) throws StorageException {
        this.permissionIndex.deleteProjectRolesForGroup(groupName);
        this.permissionIndex.deleteGlobalRolesForGroup(groupName);
    }
}

