/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.permissions.PermissionLookup;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.permissions.roles.ProjectRole;
import jakarta.ws.rs.ForbiddenException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

class ProjectPermissions {
    private final Set<EProjectPermission> globalProjectPermissions = new HashSet<EProjectPermission>();
    private final Map<IProjectId, Set<EProjectPermission>> projectPermissionsByProject = new HashMap<IProjectId, Set<EProjectPermission>>();

    ProjectPermissions() {
    }

    public void addGlobalProjectPermissions(ProjectRole role) {
        this.globalProjectPermissions.addAll(role.getPermissions());
    }

    public Set<EProjectPermission> getGlobalEProjectPermissions() {
        return CollectionUtils.asUnmodifiable(this.globalProjectPermissions);
    }

    public Map<IProjectId, Set<EProjectPermission>> getProjectPermissionsByProject() {
        return CollectionUtils.asUnmodifiable(this.projectPermissionsByProject);
    }

    public void addProjectPermission(IProjectId projectId, ProjectRole role) {
        Set permissions = this.projectPermissionsByProject.computeIfAbsent(projectId, key -> new HashSet());
        permissions.addAll(role.getPermissions());
    }

    private Set<EProjectPermission> getProjectPermissions(IProjectId projectId) {
        HashSet<EProjectPermission> result = new HashSet<EProjectPermission>();
        result.addAll(this.globalProjectPermissions);
        result.addAll((Collection)Optional.ofNullable(this.projectPermissionsByProject.get(projectId)).orElse((Set<EProjectPermission>)CollectionUtils.emptySet()));
        return result;
    }

    private boolean hasProjectPermission(IProjectId projectId, EProjectPermission permission) {
        return this.getProjectPermissions(projectId).contains(permission);
    }

    public PermissionLookup<EProjectPermission> getProjectPermissionLookup() {
        HashMap projectPermissionsByProjectAsStrings = new HashMap();
        this.projectPermissionsByProject.forEach((projectId, projectPermissions) -> projectPermissionsByProjectAsStrings.put(projectId.toString(), projectPermissions));
        return new PermissionLookup<EProjectPermission>(this.globalProjectPermissions, projectPermissionsByProjectAsStrings);
    }

    public boolean hasAnyProjectPermission(EProjectPermission projectPermission) {
        return this.globalProjectPermissions.contains(projectPermission) || this.projectPermissionsByProject.values().stream().anyMatch(projectPermissions -> projectPermissions.contains(projectPermission));
    }

    public boolean hasProjectPermission(ProjectIndex projectIndex, IProjectId projectId, EProjectPermission projectPermission) throws StorageException {
        if (projectId == null) {
            throw new StorageException("Can't test project permissions without project.");
        }
        Optional<ProjectInfo> projectInfo = projectIndex.tryResolveProject(projectId);
        if (projectInfo.isEmpty()) {
            return false;
        }
        return this.hasProjectPermission((IProjectId)projectInfo.get().getInternalId(), projectPermission) || projectInfo.get().getPublicIds().stream().anyMatch(id -> this.hasProjectPermission((IProjectId)id, projectPermission));
    }

    public void checkProjectPermission(ProjectIndex projectIndex, IProjectId projectId, EProjectPermission projectPermission) throws StorageException, ForbiddenException {
        if (!this.hasProjectPermission(projectIndex, projectId, projectPermission)) {
            String message = "User doesn't have permission '" + projectPermission.readableName + "' on project " + String.valueOf(projectId) + ".";
            AuditLogs.failedProjectPermissionCheck(projectPermission, message);
            throw new ForbiddenException(message);
        }
    }

    public List<ProjectInfo> getVisibleProjects(ProjectIndex projectIndex, boolean includeDeleting, boolean includeReanalyzing) throws StorageException {
        return ProjectPermissions.getAllProjectInfos(projectIndex, includeDeleting, includeReanalyzing).stream().filter(this::isProjectVisible).sorted(Comparator.comparing(ProjectInfo::getPrimaryPublicId)).collect(Collectors.toList());
    }

    public List<IProjectId> getVisibleProjectIds() {
        ArrayList<IProjectId> visibleProjectIds = new ArrayList<IProjectId>();
        this.projectPermissionsByProject.forEach((projectId, permissions) -> {
            if (permissions.contains(EProjectPermission.VIEW)) {
                visibleProjectIds.add((IProjectId)projectId);
            }
        });
        return visibleProjectIds;
    }

    private boolean isProjectVisible(ProjectInfo project) {
        return project.getPublicIds().stream().map(this::getProjectPermissions).anyMatch(permissions -> permissions.contains(EProjectPermission.VIEW));
    }

    private static Set<ProjectInfo> getAllProjectInfos(ProjectIndex projectIndex, boolean includeDeleting, boolean includeReanalyzing) throws StorageException {
        return CollectionUtils.filterToSet(projectIndex.getAllProjectInfos(), project -> !(!includeDeleting && project.isDeleting() || !includeReanalyzing && project.isReanalyzing()));
    }
}

