/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.api.rollback;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record RollbackRequest(Set<CommitDescriptor> rollbackCommits, String reason, UUID id, boolean neverPostpone) {
    private static final String ROLLBACK_REQUEST_BRANCH_NAME = "###rollback-to###";
    public static final CommitDescriptor ROLLBACK_REQUESTED_COMMIT = new CommitDescriptor("###rollback-to###", 1L);

    public RollbackRequest(CommitDescriptor rollbackCommit, String reason) {
        this(Set.of(rollbackCommit), reason);
    }

    public RollbackRequest(Collection<CommitDescriptor> rollbackCommits, String reason) {
        this(rollbackCommits, reason, null, false);
    }

    public RollbackRequest(CommitDescriptor rollbackCommit, String reason, boolean neverPostpone) {
        this(Set.of(rollbackCommit), reason, neverPostpone);
    }

    public RollbackRequest(Collection<CommitDescriptor> rollbackCommits, String reason, boolean neverPostpone) {
        this(rollbackCommits, reason, null, neverPostpone);
    }

    public RollbackRequest(CommitDescriptor rollbackCommit, String reason, @Nullable UUID id) {
        this(Set.of(rollbackCommit), reason, id);
    }

    public RollbackRequest(Collection<CommitDescriptor> rollbackCommits, String reason, @Nullable UUID id) {
        this(rollbackCommits, reason, id, false);
    }

    public RollbackRequest(CommitDescriptor rollbackCommit, String reason, @Nullable UUID id, boolean neverPostpone) {
        this(Set.of(rollbackCommit), reason, id, neverPostpone);
    }

    public RollbackRequest(Collection<CommitDescriptor> rollbackCommits, String reason, @Nullable UUID id, boolean neverPostpone) {
        this(Set.copyOf(rollbackCommits), reason, id, neverPostpone);
    }

    public RollbackRequest(Set<CommitDescriptor> rollbackCommits, String reason, @Nullable UUID id, boolean neverPostpone) {
        if (rollbackCommits.isEmpty()) {
            throw new IllegalArgumentException("Cannot request rollback to no commits");
        }
        if (StringUtils.isEmpty((String)reason)) {
            throw new IllegalArgumentException("reason must not be empty");
        }
        this.rollbackCommits = Set.copyOf(rollbackCommits);
        this.reason = reason;
        this.id = Objects.requireNonNullElseGet(id, UUID::randomUUID);
        this.neverPostpone = neverPostpone;
    }

    public CommitDescriptor schedulingCommit() {
        if (this.rollbackCommits.size() == 1) {
            return this.rollbackCommits.iterator().next();
        }
        return ROLLBACK_REQUESTED_COMMIT;
    }
}

