/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.findings.DerivedFindingsIndex;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.findings.metrics.EFindingsMetricCategory;
import com.teamscale.core.findings.metrics.FindingsCountForAllCategoriesMetric;
import com.teamscale.core.findings.metrics.FindingsCountForSingleCategoryMetric;
import com.teamscale.core.findings.metrics.FindingsCountMetric;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.log.interaction.ProjectInteractionLogIndex;
import com.teamscale.core.log.js.ProjectJavaScriptErrorLogIndex;
import com.teamscale.core.log.service.ProjectCriticalEventServiceLogIndex;
import com.teamscale.core.log.service.ProjectServiceLogIndex;
import com.teamscale.core.log.worker.ProjectCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogDigestIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogIndex;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.directory.HiddenMetricDirectoryIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryIndexSynchronizer;
import com.teamscale.core.metrics.directory.MetricTrendIndex;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.runtime.impl.CommitChildrenIndex;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.core.runtime.impl.performance.ProjectPerformanceIndex;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.core.runtime.impl.rollback.RollbackLogIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.StorageStringAbbreviationIndex;

public class CoreConfiguration
extends AnalysisConfigurationBase {
    @ConfigExposed(name="Number of Findings", description="Enables metric for the number of findings for this quality indicator.")
    public boolean qualityIndicatorFindingsCountMetric = false;
    @ConfigExposed(name="Number of Findings (Red)", description="Enables metric for the number of red findings for this quality indicator.")
    public boolean qualityIndicatorFindingsCountRedMetric = false;
    @ConfigExposed(name="Number of Findings (Yellow)", description="Enables metric for the number of yellow findings for this quality indicator.")
    public boolean qualityIndicatorFindingsCountYellowMetric = false;

    public CoreConfiguration() {
        this.autoExpose();
    }

    @Override
    public void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CoreConfiguration.configureSystemIndexes(proxy);
        CoreConfiguration.configureMetricIndexes(proxy);
        CoreConfiguration.createFindingsMetrics(proxy.getCodeMetricSchema());
        CoreConfiguration.configureTriggers(proxy);
    }

    private static void configureSystemIndexes(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(MetaIndex.class);
        proxy.createProjectIndex(TriggerIndex.class);
        proxy.createProjectIndex(StorageStringAbbreviationIndex.class);
        proxy.createProjectIndex(CommitDescriptorIndex.class);
        proxy.createProjectIndex(CommitChildrenIndex.class);
        proxy.createProjectIndex(PostponedRollbackIndex.class);
        proxy.createProjectIndex(ProjectWorkerLogIndex.class);
        proxy.createProjectIndex(ProjectWorkerLogDigestIndex.class);
        proxy.createProjectIndex(ProjectCriticalEventWorkerLogIndex.class);
        proxy.createProjectIndex(ProjectServiceLogIndex.class);
        proxy.createProjectIndex(ProjectCriticalEventServiceLogIndex.class);
        proxy.createProjectIndex(ProjectJavaScriptErrorLogIndex.class);
        proxy.createProjectIndex(ProjectInteractionLogIndex.class);
        proxy.createProjectIndex(FindingsIndex.class);
        proxy.createProjectIndex(DerivedFindingsIndex.class);
        proxy.createProjectIndex(FindingsSchemaIndex.class);
        proxy.createProjectIndex(ProjectAnalysisProgressIndex.class);
        proxy.createProjectIndex(BranchAnalysisStateIndex.class);
        proxy.createProjectIndex(ProjectPerformanceIndex.class);
        proxy.createProjectIndex(RollbackLogIndex.class);
    }

    private static void configureMetricIndexes(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(MetricsIndex.class, "metrics");
        proxy.createProjectIndex(MetricSchemaIndex.class, "metric-schema");
        proxy.createProjectIndex(MetricDirectoryIndex.class, "metric-directory");
        proxy.createProjectIndex(HiddenMetricDirectoryIndex.class);
        proxy.createProjectIndex(MetricTrendIndex.class, "metric-trend");
    }

    private static void configureTriggers(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createTrigger(new TriggerBuilder(MetricDirectoryIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.CHEAP).resolveIndexNamePlaceholder("metrics-placeholder", "metrics").resolveIndexNamePlaceholder("metric-schema-placeholder", "metric-schema").resolveIndexNamePlaceholder("metric-trend-placeholder", "metric-trend").resolveIndexNamePlaceholder("metric-directory-placeholder", "metric-directory"));
    }

    private static void createFindingsMetrics(MetricSchemaProxy schema) throws ProjectConfigurationException {
        CoreConfiguration.addFindingsCounts(schema);
        CoreConfiguration.addFindingsSummaries(schema);
    }

    private static void addFindingsCounts(MetricSchemaProxy schema) throws ProjectConfigurationException {
        FindingsCountMetric.FINDINGS_COUNT.registerInSchema(schema);
        FindingsCountMetric.FINDINGS_COUNT_RED.registerInSchema(schema);
        FindingsCountMetric.FINDINGS_COUNT_YELLOW.registerInSchema(schema);
    }

    private static void addFindingsSummaries(MetricSchemaProxy schema) throws ProjectConfigurationException {
        FindingsCountForAllCategoriesMetric.FINDINGS_COUNT_FOR_ALL_CATEGORIES.registerInSchema(schema);
        FindingsCountForAllCategoriesMetric.FINDINGS_COUNT_FOR_ALL_CATEGORIES_RED.registerInSchema(schema);
        FindingsCountForAllCategoriesMetric.FINDINGS_COUNT_FOR_ALL_CATEGORIES_YELLOW.registerInSchema(schema);
    }

    @Override
    public void applyQualityIndicatorOptions(String qualityIndicatorName, ProjectCreationProxy proxy) throws ProjectConfigurationException {
        MetricSchemaProxy schema = proxy.getCodeMetricSchema();
        this.addFindingsCountMetricsForQualityIndicator(qualityIndicatorName, schema);
    }

    private void addFindingsCountMetricsForQualityIndicator(String qualityIndicatorName, MetricSchemaProxy schema) throws ProjectConfigurationException {
        if (this.qualityIndicatorFindingsCountMetric) {
            CoreConfiguration.addFindingsCountByCategoryToSchema(schema, qualityIndicatorName, false, EFindingsMetricCategory.ALL);
        }
        if (this.qualityIndicatorFindingsCountRedMetric) {
            CoreConfiguration.addFindingsCountByCategoryToSchema(schema, qualityIndicatorName, false, EFindingsMetricCategory.RED);
        }
        if (this.qualityIndicatorFindingsCountYellowMetric) {
            CoreConfiguration.addFindingsCountByCategoryToSchema(schema, qualityIndicatorName, false, EFindingsMetricCategory.YELLOW);
        }
    }

    public static void addFindingsCountByCategoryToSchema(MetricSchemaProxy schema, String category, boolean hidden, EFindingsMetricCategory metricColor) throws ProjectConfigurationException {
        FindingsCountForAllCategoriesMetric findingsCountForAllCategoriesMetric = metricColor.getFindingsSummaryMetric();
        FindingsCountForSingleCategoryMetric findingsCountMetricForCategory = findingsCountForAllCategoriesMetric.createFindingsCountMetricForCategory(category, hidden);
        if (!schema.hasMetric(findingsCountMetricForCategory.getId())) {
            findingsCountMetricForCategory.registerInSchema(schema);
        }
    }

    @Override
    public boolean isCoreConfiguration() {
        return true;
    }

    @Override
    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration(this);
        template.registerQualityIndicatorOption(this.getOptionForField("qualityIndicatorFindingsCountMetric"));
        template.registerQualityIndicatorOption(this.getOptionForField("qualityIndicatorFindingsCountRedMetric"));
        template.registerQualityIndicatorOption(this.getOptionForField("qualityIndicatorFindingsCountYellowMetric"));
    }
}

