/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.ISchedulingCommit;
import com.teamscale.core.runtime.impl.analysis.RateLimitableResource;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.PrivilegedTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.rollback.IRollbackTrigger;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class JobDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InternalProjectId internalProjectId;
    private final ETriggerType triggerType;
    private final String triggerName;
    private final @Nullable ISchedulingCommit schedulingCommit;
    private final @Nullable String parameter;
    private final boolean rollbackRelevant;
    private final boolean isCritical;
    private final String schedulingReason;
    private final @Nullable UUID rollbackId;
    private final boolean cancelable;
    private final @Nullable RateLimitableResource remoteResource;

    public static JobDescriptor forRollback(InternalProjectId internalProjectId, RollbackRequest rollbackRequest, Class<? extends IRollbackTrigger> rollbackTriggerClass) {
        return JobDescriptor.forProject(internalProjectId).withTrigger(ETriggerType.PRIVILEGED, rollbackTriggerClass.getName()).withSchedulingReason(rollbackRequest.reason()).withCommit(ISchedulingCommit.plain(rollbackRequest.schedulingCommit())).markRollbackRelevant().markCritical().withParameter(rollbackRequest).withRollbackId(rollbackRequest.id()).withCancelable(JobDescriptor.isTriggerCancelable(rollbackTriggerClass.asSubclass(PrivilegedTriggerBase.class))).build();
    }

    private JobDescriptor(InternalProjectId internalProjectId, ETriggerType triggerType, String triggerName, @Nullable ISchedulingCommit schedulingCommit, boolean rollbackRelevant, @Nullable Object parameter, boolean isCritical, String schedulingReason, @Nullable UUID rollbackId, boolean cancelable, @Nullable RateLimitableResource remoteResource) {
        this.internalProjectId = internalProjectId;
        this.triggerType = triggerType;
        this.triggerName = triggerName;
        this.schedulingCommit = schedulingCommit;
        this.rollbackRelevant = rollbackRelevant;
        this.parameter = parameter == null || parameter instanceof String ? (String)parameter : JsonUtils.serializeToJSON((Object)parameter);
        this.isCritical = isCritical;
        this.schedulingReason = schedulingReason;
        this.rollbackId = rollbackId;
        this.cancelable = cancelable;
        this.remoteResource = remoteResource;
    }

    public InternalProjectId getInternalProjectId() {
        return this.internalProjectId;
    }

    public ETriggerType getTriggerType() {
        return this.triggerType;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public @Nullable ISchedulingCommit getSchedulingCommit() {
        return this.schedulingCommit;
    }

    public @Nullable CommitDescriptor getSchedulingCommitDescriptor() {
        return Optional.ofNullable(this.schedulingCommit).map(ISchedulingCommit::commit).orElse(null);
    }

    public @Nullable String getParameter() {
        return this.parameter;
    }

    public <T> T getParameterObject(Class<T> expectedClass) throws JsonSerializationException {
        return (T)JsonUtils.deserializeFromJson((String)this.parameter, expectedClass);
    }

    public boolean isRollbackRelevant() {
        return this.rollbackRelevant;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public @Nullable UUID getRollbackId() {
        return this.rollbackId;
    }

    private static boolean isTriggerCancelable(Class<? extends PrivilegedTriggerBase> triggerClass) {
        try {
            return PrivilegedTrigger.createTrigger(triggerClass.getName()).isCancelable();
        }
        catch (TriggerCompilationException e) {
            return false;
        }
    }

    public String getSchedulingReason() {
        return this.schedulingReason;
    }

    public String toString() {
        return String.valueOf(this.internalProjectId) + "/" + this.triggerName + " (@" + String.valueOf(this.getSchedulingCommitDescriptor()) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDescriptor that = (JobDescriptor)o;
        return this.rollbackRelevant == that.rollbackRelevant && this.isCritical == that.isCritical && this.internalProjectId.equals((Object)that.internalProjectId) && this.triggerType == that.triggerType && this.triggerName.equals(that.triggerName) && Objects.equals(this.schedulingCommit, that.schedulingCommit) && Objects.equals(this.parameter, that.parameter) && Objects.equals(this.schedulingReason, that.schedulingReason) && Objects.equals(this.rollbackId, that.rollbackId) && Objects.equals(this.cancelable, that.cancelable) && Objects.equals(this.remoteResource, that.remoteResource);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.internalProjectId, this.triggerType, this.triggerName, this.schedulingCommit, this.parameter, this.rollbackRelevant, this.isCritical, this.schedulingReason, this.rollbackId, this.cancelable, this.remoteResource});
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public @Nullable RateLimitableResource getRemoteResource() {
        return this.remoteResource;
    }

    public IRequireSchedulingReason toBuilder() {
        JobDescriptorBuilder builder = new JobDescriptorBuilder(this.internalProjectId);
        builder.triggerType = this.triggerType;
        builder.triggerName = this.triggerName;
        builder.rollbackRelevant = this.rollbackRelevant;
        builder.cancelable = this.cancelable;
        builder.schedulingCommit = this.schedulingCommit;
        builder.parameter = this.parameter;
        builder.isCritical = this.isCritical;
        builder.rollbackId = this.rollbackId;
        builder.remoteResource = this.remoteResource;
        return builder;
    }

    public static IRequireTrigger forProject(InternalProjectId internalProjectId) {
        return new JobDescriptorBuilder(internalProjectId);
    }

    public static IRequireTrigger forMaintenanceProject() {
        return new JobDescriptorBuilder(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID);
    }

    public static interface IRequireTrigger {
        public IRequireSchedulingReason withTrigger(ETriggerType var1, String var2);

        public IRequireSchedulingReason withTrigger(AnalysisTrigger var1);

        public IRequireSchedulingReason withPrivilegedTrigger(Class<? extends PrivilegedTriggerBase> var1);
    }

    public static interface IRequireSchedulingReason {
        public IOptionalParameters withSchedulingReason(String var1);

        public IOptionalParameters withoutSchedulingReason();
    }

    public static interface IOptionalParameters {
        public IOptionalParameters withCommit(@Nullable ISchedulingCommit var1);

        public IOptionalParameters withCommit(@Nullable CommitDescriptor var1);

        public IOptionalParameters withParameter(@Nullable String var1);

        public IOptionalParameters withParameter(@Nullable Object var1);

        public IOptionalParameters markCritical();

        public IOptionalParameters markRollbackRelevant();

        public IOptionalParameters withRollbackRelevant(boolean var1);

        public IOptionalParameters withCancelable(boolean var1);

        public IOptionalParameters withRollbackId(UUID var1);

        public IOptionalParameters withRemoteResource(@Nullable RateLimitableResource var1);

        public JobDescriptor build();
    }

    static class JobDescriptorBuilder
    implements IRequireTrigger,
    IRequireSchedulingReason,
    IOptionalParameters {
        private final InternalProjectId internalProjectId;
        private @Nullable ETriggerType triggerType;
        private @Nullable Class<? extends PrivilegedTriggerBase> triggerClass;
        private @Nullable String triggerName;
        private @Nullable String schedulingReason;
        private @Nullable ISchedulingCommit schedulingCommit = null;
        private @Nullable Object parameter = null;
        private boolean isCritical = false;
        private @Nullable UUID rollbackId = null;
        private @Nullable Boolean rollbackRelevant = null;
        private @Nullable Boolean cancelable = null;
        private @Nullable RateLimitableResource remoteResource = null;

        JobDescriptorBuilder(InternalProjectId internalProjectId) {
            this.internalProjectId = internalProjectId;
        }

        @Override
        public IRequireSchedulingReason withTrigger(ETriggerType triggerType, String triggerName) {
            this.triggerType = triggerType;
            this.triggerName = triggerName;
            return this;
        }

        @Override
        public IRequireSchedulingReason withTrigger(AnalysisTrigger trigger) {
            this.triggerType = ETriggerType.BLOCK;
            this.triggerName = trigger.getName();
            this.rollbackRelevant = trigger.isRollbackRelevant();
            this.cancelable = trigger.isCancelable();
            this.remoteResource = trigger.getRemoteResource();
            return this;
        }

        @Override
        public IRequireSchedulingReason withPrivilegedTrigger(Class<? extends PrivilegedTriggerBase> triggerClass) {
            this.triggerClass = triggerClass;
            this.triggerType = ETriggerType.PRIVILEGED;
            this.triggerName = triggerClass.getName();
            return this;
        }

        @Override
        public IOptionalParameters withSchedulingReason(String schedulingReason) {
            this.schedulingReason = schedulingReason;
            return this;
        }

        @Override
        public IOptionalParameters withoutSchedulingReason() {
            this.schedulingReason = "";
            return this;
        }

        @Override
        public IOptionalParameters withCommit(@Nullable ISchedulingCommit schedulingCommit) {
            this.schedulingCommit = schedulingCommit;
            return this;
        }

        @Override
        public IOptionalParameters withCommit(@Nullable CommitDescriptor commit) {
            this.schedulingCommit = Optional.ofNullable(commit).map(ISchedulingCommit::plain).orElse(null);
            return this;
        }

        @Override
        public IOptionalParameters withParameter(@Nullable String parameter) {
            this.parameter = parameter;
            return this;
        }

        @Override
        public IOptionalParameters withParameter(@Nullable Object parameter) {
            this.parameter = parameter;
            return this;
        }

        @Override
        public IOptionalParameters markCritical() {
            this.isCritical = true;
            return this;
        }

        @Override
        public IOptionalParameters markRollbackRelevant() {
            this.rollbackRelevant = true;
            return this;
        }

        @Override
        public IOptionalParameters withRollbackRelevant(boolean rollbackRelevant) {
            this.rollbackRelevant = rollbackRelevant;
            return this;
        }

        @Override
        public IOptionalParameters withCancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        @Override
        public IOptionalParameters withRollbackId(UUID rollbackId) {
            this.rollbackId = rollbackId;
            return this;
        }

        @Override
        public IOptionalParameters withRemoteResource(@Nullable RateLimitableResource remoteResource) {
            this.remoteResource = remoteResource;
            return this;
        }

        @Override
        public JobDescriptor build() {
            boolean finalRollbackRelevant = Objects.requireNonNullElseGet(this.rollbackRelevant, () -> this.triggerType == ETriggerType.PRIVILEGED);
            boolean finalCancelable = Objects.requireNonNullElseGet(this.cancelable, this::computeCancelableFromTrigger);
            return new JobDescriptor(this.internalProjectId, this.triggerType, this.triggerName, this.schedulingCommit, finalRollbackRelevant, this.parameter, this.isCritical, this.schedulingReason, this.rollbackId, finalCancelable, this.remoteResource);
        }

        private boolean computeCancelableFromTrigger() {
            if (this.triggerClass == null) {
                return true;
            }
            return JobDescriptor.isTriggerCancelable(this.triggerClass);
        }
    }
}

