/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepFieldAccessorBase;
import com.teamscale.core.runtime.impl.analysis.step.IIndexName;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.util.List;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;

public class AnalysisStepBranchingLayerAccess
extends AnalysisStepFieldAccessorBase {
    private final IIndexName indexName;

    private AnalysisStepBranchingLayerAccess(Field field, List<Field> fieldStack, IIndexName indexName) throws TriggerCompilationException {
        if (!IBranchingLayer.class.equals(field.getType())) {
            throw new TriggerCompilationException("May use branching layer access annotation only for fields of type " + IBranchingLayer.class.getSimpleName() + ", not for " + field.getType().getSimpleName());
        }
        super(field, fieldStack);
        this.indexName = indexName;
    }

    static AnalysisStepBranchingLayerAccess ofBranchingLayer(Field field, List<Field> fieldStack, BranchingLayerAccess branchingLayerAccess) throws TriggerCompilationException {
        IIndexName.Fixed indexName = (IIndexName.Fixed)AnalysisStepBranchingLayerAccess.resolveIndexNameFromIndexClass(branchingLayerAccess.value(), field, null);
        return new AnalysisStepBranchingLayerAccess(field, fieldStack, indexName);
    }

    static AnalysisStepBranchingLayerAccess ofNamedBranchingLayer(Field field, List<Field> fieldStack, BranchingLayerAccess.Named branchingLayerAccess) throws TriggerCompilationException {
        return new AnalysisStepBranchingLayerAccess(field, fieldStack, new IIndexName.Fixed(branchingLayerAccess.name()));
    }

    static AnalysisStepBranchingLayerAccess ofDynamicBranchingLayer(Field field, List<Field> fieldStack, BranchingLayerAccess.Dynamic branchingLayerAccess) throws TriggerCompilationException {
        IIndexName.Placeholder indexName = (IIndexName.Placeholder)AnalysisStepBranchingLayerAccess.resolveIndexNameFromIndexClass(branchingLayerAccess.value(), field, branchingLayerAccess.placeholder());
        return new AnalysisStepBranchingLayerAccess(field, fieldStack, indexName);
    }

    public IIndexName getIndexName() {
        return this.indexName;
    }

    @Override
    protected String getToStringPrefix() {
        return "branching layer access: " + String.valueOf(this.indexName);
    }

    public void setValue(AnalysisStepBase instance, IBranchingLayer value) {
        this.set(instance, value);
    }
}

