/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.IDeltaTranslatingIndex;
import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepFieldAccessorBase;
import com.teamscale.core.runtime.impl.analysis.step.IIndexName;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IProjectIndexBase;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.jetbrains.annotations.VisibleForTesting;

public class AnalysisStepDeltaSource<T extends IProjectIndexBase>
extends AnalysisStepFieldAccessorBase {
    private final IIndexName indexName;
    private final Class<? extends T> indexClass;

    private AnalysisStepDeltaSource(Field field, List<Field> fieldStack, IIndexName indexName, Class<? extends T> indexClass) throws TriggerCompilationException {
        AnalysisStepDeltaSource.checkType(field, indexClass);
        super(field, fieldStack);
        this.indexName = indexName;
        this.indexClass = indexClass;
    }

    @VisibleForTesting
    static void checkType(Field field, Class<? extends IStorageIndex> indexType) throws TriggerCompilationException {
        Type expectedType = IDeltaTranslatingIndex.getDeltaType(indexType);
        if (!TypeUtils.isAssignable((Type)expectedType, (Type)field.getGenericType())) {
            throw new TriggerCompilationException("Field " + String.valueOf(field) + " is annotated with " + DeltaSource.class.getSimpleName() + " and thus should be assignable to " + String.valueOf(expectedType));
        }
    }

    static AnalysisStepDeltaSource<IProjectIndex> ofDeltaSource(Field field, List<Field> fieldStack, DeltaSource deltaSource) throws TriggerCompilationException {
        Class<? extends IProjectIndex> indexClass = deltaSource.value();
        IIndexName.Fixed indexName = (IIndexName.Fixed)AnalysisStepDeltaSource.resolveIndexNameFromIndexClass(indexClass, field, null);
        return new AnalysisStepDeltaSource<IProjectIndex>(field, fieldStack, indexName, indexClass);
    }

    static AnalysisStepDeltaSource<IProjectIndexWithDynamicName> ofNamedDeltaSource(Field field, List<Field> fieldStack, DeltaSource.Named deltaSource) throws TriggerCompilationException {
        return new AnalysisStepDeltaSource<IProjectIndexWithDynamicName>(field, fieldStack, new IIndexName.Fixed(deltaSource.name()), deltaSource.index());
    }

    static AnalysisStepDeltaSource<IProjectIndexWithDynamicName> ofDynamicDeltaSource(Field field, List<Field> fieldStack, DeltaSource.Dynamic deltaSource) throws TriggerCompilationException {
        Class<? extends IProjectIndexWithDynamicName> indexClass = deltaSource.value();
        IIndexName.Placeholder indexName = (IIndexName.Placeholder)AnalysisStepDeltaSource.resolveIndexNameFromIndexClass(indexClass, field, deltaSource.placeholder());
        return new AnalysisStepDeltaSource<IProjectIndexWithDynamicName>(field, fieldStack, indexName, indexClass);
    }

    public IIndexName getIndexName() {
        return this.indexName;
    }

    public Class<? extends T> getIndexClass() {
        return this.indexClass;
    }

    @Override
    protected String getToStringPrefix() {
        return "delta source: " + String.valueOf(this.indexName);
    }

    public void setDelta(AnalysisStepBase instance, IIndexDelta delta) {
        this.set(instance, delta);
    }
}

