/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepIndexAccessBase;
import com.teamscale.core.runtime.impl.analysis.step.IIndexName;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;

public final class AnalysisStepGlobalIndexAccess
extends AnalysisStepIndexAccessBase<IGlobalIndex> {
    private final EIndexAccessMode accessMode;
    private final IIndexName.Fixed indexName;
    private final Class<? extends IGlobalIndex> indexType;

    AnalysisStepGlobalIndexAccess(Field field, List<Field> fieldStack, GlobalIndexAccess indexAccess) throws TriggerCompilationException {
        super(field, fieldStack);
        this.accessMode = switch (indexAccess.value()) {
            default -> throw new MatchException(null, null);
            case EIndexAccessMode.READ_ONLY -> EIndexAccessMode.READ_ONLY;
            case EIndexAccessMode.READ_WRITE -> EIndexAccessMode.READ_WRITE;
            case EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY -> throw new TriggerCompilationException("Global index access does not support %s for %s".formatted(new Object[]{indexAccess.value(), field}));
        };
        this.indexType = AnalysisStepGlobalIndexAccess.resolveIndexClass(field, IGlobalIndex.class, this.accessMode);
        this.indexName = (IIndexName.Fixed)AnalysisStepGlobalIndexAccess.resolveIndexNameFromIndexClass(this.indexType, field, null);
    }

    @Override
    public EIndexAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public IIndexName.Fixed getIndexName() {
        return this.indexName;
    }

    @Override
    public Class<? extends IGlobalIndex> getIndexClass() {
        return this.indexType;
    }

    @Override
    protected String getToStringPrefix() {
        return "global index access: " + String.valueOf(this.indexName);
    }
}

