/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepFieldAccessorBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepGlobalIndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepParameter;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepProjectIndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.IIndexName;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.util.List;
import org.conqat.engine.persistence.index.IStorageIndex;

public abstract sealed class AnalysisStepIndexAccessBase<T extends IStorageIndex>
extends AnalysisStepFieldAccessorBase
permits AnalysisStepGlobalIndexAccess, AnalysisStepProjectIndexAccess {
    protected AnalysisStepIndexAccessBase(Field field, List<Field> fieldStack) throws TriggerCompilationException {
        super(field, fieldStack);
    }

    protected static <T extends IStorageIndex> Class<? extends T> resolveIndexClass(Field field, Class<T> expectedSuperType, EIndexAccessMode accessMode) throws TriggerCompilationException {
        return switch (accessMode) {
            default -> throw new MatchException(null, null);
            case EIndexAccessMode.READ_ONLY, EIndexAccessMode.READ_WRITE, EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY -> AnalysisStepIndexAccessBase.asTypedIndex(field, field.getType(), expectedSuperType);
            case EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY -> {
                if (!field.getType().equals(List.class)) {
                    throw new TriggerCompilationException("Field %s annotated with mode %s must be of type List".formatted(new Object[]{field, EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY}));
                }
                yield AnalysisStepIndexAccessBase.asTypedIndex(field, AnalysisStepParameter.getNthGenericTypeArgument(field, 0), expectedSuperType);
            }
        };
    }

    private static <T extends IStorageIndex> Class<? extends T> asTypedIndex(Field field, Class<?> indexClass, Class<T> expected) throws TriggerCompilationException {
        if (!expected.isAssignableFrom(indexClass)) {
            throw new TriggerCompilationException("Field %s.%s has index type %s which does not implement %s".formatted(field.getDeclaringClass().getSimpleName(), field.getName(), indexClass.getSimpleName(), expected.getSimpleName()));
        }
        return indexClass.asSubclass(expected);
    }

    public abstract IIndexName getIndexName();

    public abstract EIndexAccessMode getAccessMode();

    public abstract Class<? extends T> getIndexClass();

    public void setValue(AnalysisStepBase instance, Object value) {
        this.set(instance, value);
    }
}

