/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepIndexAccessBase;
import com.teamscale.core.runtime.impl.analysis.step.IIndexName;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IProjectIndexBase;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;

public final class AnalysisStepProjectIndexAccess<T extends IProjectIndexBase>
extends AnalysisStepIndexAccessBase<T> {
    private final EIndexAccessMode accessMode;
    private final IIndexName indexName;
    private final boolean skipDeltaCreation;
    private final Class<? extends T> indexClass;

    private AnalysisStepProjectIndexAccess(Field field, List<Field> fieldStack, EIndexAccessMode accessMode, IIndexName indexName, boolean skipDeltaCreation, Class<? extends T> indexClass) throws TriggerCompilationException {
        super(field, fieldStack);
        this.accessMode = accessMode;
        this.indexName = indexName;
        this.skipDeltaCreation = skipDeltaCreation;
        this.indexClass = indexClass;
    }

    static AnalysisStepProjectIndexAccess<IProjectIndex> ofIndexAccess(Field field, List<Field> fieldStack, IndexAccess indexAccess) throws TriggerCompilationException {
        Class<IProjectIndex> indexClass = AnalysisStepProjectIndexAccess.resolveIndexClass(field, IProjectIndex.class, indexAccess.value());
        IIndexName.Fixed indexName = (IIndexName.Fixed)AnalysisStepProjectIndexAccess.resolveIndexNameFromIndexClass(indexClass, field, null);
        return new AnalysisStepProjectIndexAccess<IProjectIndex>(field, fieldStack, indexAccess.value(), indexName, indexAccess.skipDeltaCreation(), indexClass);
    }

    static AnalysisStepProjectIndexAccess<IProjectIndexWithDynamicName> ofNamedIndexAccess(Field field, List<Field> fieldStack, IndexAccess.Named namedIndexAccess) throws TriggerCompilationException {
        Class<IProjectIndexWithDynamicName> indexClass = AnalysisStepProjectIndexAccess.resolveIndexClass(field, IProjectIndexWithDynamicName.class, namedIndexAccess.mode());
        IIndexName.Fixed indexName = new IIndexName.Fixed(namedIndexAccess.name());
        return new AnalysisStepProjectIndexAccess<IProjectIndexWithDynamicName>(field, fieldStack, namedIndexAccess.mode(), indexName, namedIndexAccess.skipDeltaCreation(), indexClass);
    }

    static AnalysisStepProjectIndexAccess<IProjectIndexWithDynamicName> ofDynamicIndexAccess(Field field, List<Field> fieldStack, IndexAccess.Dynamic dynamicIndexAccess) throws TriggerCompilationException {
        Class<IProjectIndexWithDynamicName> indexClass = AnalysisStepProjectIndexAccess.resolveIndexClass(field, IProjectIndexWithDynamicName.class, dynamicIndexAccess.value());
        IIndexName.Placeholder indexName = (IIndexName.Placeholder)AnalysisStepProjectIndexAccess.resolveIndexNameFromIndexClass(indexClass, field, dynamicIndexAccess.placeholder());
        return new AnalysisStepProjectIndexAccess<IProjectIndexWithDynamicName>(field, fieldStack, dynamicIndexAccess.value(), indexName, dynamicIndexAccess.skipDeltaCreation(), indexClass);
    }

    @Override
    public EIndexAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public Class<? extends T> getIndexClass() {
        return this.indexClass;
    }

    @Override
    public IIndexName getIndexName() {
        return this.indexName;
    }

    public boolean shouldCreateDelta() {
        return this.getAccessMode() == EIndexAccessMode.READ_WRITE && !this.skipDeltaCreation;
    }

    @Override
    protected String getToStringPrefix() {
        return "index access: " + String.valueOf(this.indexName);
    }
}

