/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.trigger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.runtime.impl.analysis.RateLimitableResource;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepInitializer;
import com.teamscale.core.runtime.impl.analysis.step.IIndexName;
import com.teamscale.core.runtime.impl.analysis.trigger.ConcurrentSchedulingLimit;
import com.teamscale.core.runtime.impl.analysis.trigger.EStorageAccessAttribute;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.BidirectionalMap;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.enums.EnumUtils;
import org.jspecify.annotations.Nullable;

public final class AnalysisTrigger
implements ITrigger {
    public static final int DEFAULT_DELTA_SIZE = 500;
    private final String name;
    private final TriggerDescription description;
    private final Class<? extends AnalysisStepBase> analysisStepClass;
    private final Set<String> readOnlyStores = new HashSet<String>();
    private final Set<String> readOnlyPreviousStores = new HashSet<String>();
    private final Set<String> readOnlyPreviousStoresAllParents = new HashSet<String>();
    private final Set<String> readBranchingLayerStores = new HashSet<String>();
    private final Set<String> readWriteStores = new HashSet<String>();
    private final Set<String> readWriteVirtualStores = new HashSet<String>();
    private final Set<String> transitiveWriteStores = new HashSet<String>();
    private final Set<String> transitiveWriteBlockingReadStores = new HashSet<String>();
    private final Set<String> crossCommitBlockingWriteStores = new HashSet<String>();
    private final Set<String> expectedDeltas = new HashSet<String>();
    private final BidirectionalMap<String, String> placeholderToIndexName = new BidirectionalMap();
    private int expectedOverallCost = -1;
    private ETriggerCost cost = ETriggerCost.NORMAL;
    private int maxOutputDeltaSize = 500;
    private int periodSeconds = 0;
    private int warmUpIterations = 0;
    private ETriggerConcurrency concurrency = ETriggerConcurrency.ISOLATED;
    private ConcurrentSchedulingLimit concurrentSchedulingLimit;
    private boolean runToExhaustion = false;
    private boolean mergeInputDeltas = false;
    private boolean rollbackRelevant = true;
    private int rescheduleDelaySeconds = 0;
    private boolean lowPrio = false;
    private boolean cancelable = true;
    private boolean runPostBuildCompleteness = false;
    private @Nullable RateLimitableResource remoteResource = null;
    private final AnalysisStepInitializer analysisStepInitializer;
    private boolean commitsNeedParentAdjustmentForPreviouslyForkedCommits = false;

    public AnalysisTrigger(String triggerName, TriggerDescription description, AnalysisStepInitializer analysisStepInitializer, Class<? extends AnalysisStepBase> analysisStepClass) throws TriggerCompilationException {
        this.name = triggerName;
        this.description = description;
        this.analysisStepInitializer = analysisStepInitializer;
        this.analysisStepClass = analysisStepClass;
        Optional<AnalysisStep> analysisStepParameters = analysisStepInitializer.getSchedulingHints();
        if (analysisStepParameters.isPresent()) {
            this.processAnalysisStepParameters(analysisStepParameters.get());
        }
        TriggerDescription.Parameters<ESchedulingParameter> schedulingParameters = description.getSchedulingParameters();
        for (ESchedulingParameter parameter : schedulingParameters.getParameterKeys()) {
            this.processParameter(parameter, schedulingParameters.getParameter(parameter).orElseThrow().getValue());
        }
        this.fillPlaceholderMapping(triggerName, (Map<String, String>)description.getResolvedIndexByPlaceholder());
    }

    private void processAnalysisStepParameters(AnalysisStep analysisStepParameters) throws TriggerCompilationException {
        block6: for (EAnalysisStepParameter hint : analysisStepParameters.hints()) {
            switch (hint) {
                case MERGE_INPUT_DELTAS: {
                    this.mergeInputDeltas = true;
                    continue block6;
                }
                case IGNORE_FOR_ROLLBACK: {
                    this.rollbackRelevant = false;
                    continue block6;
                }
                case LIMIT_CONCURRENT_EXECUTIONS: {
                    this.applyConcurrentSchedulingLimit(analysisStepParameters);
                    continue block6;
                }
                case COMMITS_NEED_PARENT_ADJUSTMENT_FOR_PREVIOUSLY_FORKED_COMMITS: {
                    this.commitsNeedParentAdjustmentForPreviouslyForkedCommits = true;
                    continue block6;
                }
                default: {
                    throw new TriggerCompilationException("Unknown scheduling hint: " + String.valueOf((Object)hint));
                }
            }
        }
    }

    private void applyConcurrentSchedulingLimit(AnalysisStep analysisStepParameters) throws TriggerCompilationException {
        try {
            this.concurrentSchedulingLimit = ConcurrentSchedulingLimit.of(analysisStepParameters);
        }
        catch (ConQATException e) {
            throw new TriggerCompilationException(e);
        }
    }

    private void processParameter(ESchedulingParameter parameter, JsonNode value) throws TriggerCompilationException {
        Object ignored = switch (parameter) {
            default -> throw new MatchException(null, null);
            case ESchedulingParameter.MAX_DELTA_SIZE -> {
                this.maxOutputDeltaSize = this.parsePositiveIntParameter(parameter.getParameterName(), value);
                yield this.maxOutputDeltaSize;
            }
            case ESchedulingParameter.PERIOD -> {
                this.periodSeconds = (int)this.parsePositiveDurationParameter(parameter.getParameterName(), value).toSeconds();
                yield this.periodSeconds;
            }
            case ESchedulingParameter.WARM_UP_ITERATIONS -> {
                this.warmUpIterations = this.parsePositiveIntParameter(parameter.getParameterName(), value);
                yield this.warmUpIterations;
            }
            case ESchedulingParameter.CONCURRENCY -> {
                this.concurrency = this.getTriggerConcurrency(value);
                yield this.concurrency;
            }
            case ESchedulingParameter.COST -> {
                this.cost = this.getTriggerCost(value);
                yield this.cost;
            }
            case ESchedulingParameter.RUN_TO_EXHAUSTION -> {
                this.runToExhaustion = value.asBoolean();
                yield this.runToExhaustion;
            }
            case ESchedulingParameter.LOW_PRIO -> {
                this.lowPrio = value.asBoolean();
                yield this.lowPrio;
            }
            case ESchedulingParameter.CANCELABLE -> {
                this.cancelable = value.asBoolean();
                yield this.cancelable;
            }
            case ESchedulingParameter.RUN_POST_BUILD_COMPLETENESS -> {
                this.runPostBuildCompleteness = value.asBoolean();
                yield this.runPostBuildCompleteness;
            }
            case ESchedulingParameter.REMOTE_RESOURCE -> {
                this.remoteResource = this.parseRemoteResource(parameter.getParameterName(), value);
                yield this.remoteResource;
            }
        };
    }

    private RateLimitableResource parseRemoteResource(String key, JsonNode value) throws TriggerCompilationException {
        try {
            return (RateLimitableResource)JsonUtils.getObjectMapper().treeToValue((TreeNode)value, RateLimitableResource.class);
        }
        catch (JsonProcessingException e) {
            throw new TriggerCompilationException("Trigger parameter " + key + " in " + this.name + " must be a valid RateLimitableResource!", e);
        }
    }

    private ETriggerConcurrency getTriggerConcurrency(JsonNode value) throws TriggerCompilationException {
        ETriggerConcurrency concurrencyValue = (ETriggerConcurrency)EnumUtils.valueOfIgnoreCase(ETriggerConcurrency.class, (String)value.textValue());
        if (concurrencyValue == null) {
            throw new TriggerCompilationException("Unknown concurrency mode for trigger " + this.name + ": " + String.valueOf(value));
        }
        return concurrencyValue;
    }

    private ETriggerCost getTriggerCost(JsonNode value) throws TriggerCompilationException {
        ETriggerCost costValue = (ETriggerCost)EnumUtils.valueOfIgnoreCase(ETriggerCost.class, (String)value.textValue());
        if (costValue == null) {
            throw new TriggerCompilationException("Unknown cost value for trigger " + this.name + ": " + String.valueOf(value));
        }
        return costValue;
    }

    private int parsePositiveIntParameter(String key, JsonNode value) throws TriggerCompilationException {
        try {
            int intValue;
            int n = intValue = value.isNumber() ? value.asInt() : Integer.parseInt(value.asText());
            if (intValue <= 0) {
                throw new TriggerCompilationException("Trigger parameter " + key + " in " + this.name + " must be positive!");
            }
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new TriggerCompilationException("Trigger parameter " + key + " in " + this.name + " must be a valid number!");
        }
    }

    private Duration parsePositiveDurationParameter(String key, JsonNode value) throws TriggerCompilationException {
        try {
            Duration duration = (Duration)JsonUtils.getObjectMapper().treeToValue((TreeNode)value, Duration.class);
            if (duration.isNegative() || duration.isZero()) {
                throw new TriggerCompilationException("Trigger parameter " + key + " in " + this.name + " must be positive!");
            }
            return duration;
        }
        catch (JsonProcessingException e) {
            throw new TriggerCompilationException("Trigger parameter " + key + " in " + this.name + " must be a valid Duration!", e);
        }
    }

    private void fillPlaceholderMapping(String triggerName, Map<String, String> resolvedIndexByPlaceholder) throws TriggerCompilationException {
        for (Map.Entry<String, String> entry : resolvedIndexByPlaceholder.entrySet()) {
            if (this.placeholderToIndexName.containsFirst((Object)entry.getKey())) {
                throw new TriggerCompilationException("Trigger %s contains duplicate placeholder %s".formatted(triggerName, entry.getKey()));
            }
            if (this.placeholderToIndexName.containsSecond((Object)entry.getValue())) {
                throw new TriggerCompilationException("Trigger %s resolves multiple placeholders to same store %s".formatted(triggerName, entry.getValue()));
            }
            this.placeholderToIndexName.put((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    public String getName() {
        return this.name;
    }

    public TriggerDescription getDescription() {
        return this.description;
    }

    public Class<? extends AnalysisStepBase> getAnalysisStepClass() {
        return this.analysisStepClass;
    }

    @Override
    public int getExecutionOrderIndex() {
        return 0;
    }

    @Override
    public int getPriority() {
        if (this.lowPrio) {
            return -1;
        }
        return this.getTransitiveWriteStores().size() + this.getTransitiveWriteBlockingReadStores().size();
    }

    @Override
    public boolean isPeriodic() {
        return this.periodSeconds > 0;
    }

    @Override
    public boolean commitsNeedParentAdjustmentForPreviouslyForkedCommits() {
        return this.commitsNeedParentAdjustmentForPreviouslyForkedCommits;
    }

    @Override
    public ETriggerConcurrency getConcurrency() {
        return this.concurrency;
    }

    @Override
    public Optional<ConcurrentSchedulingLimit> getConcurrentSchedulingLimit() {
        return Optional.ofNullable(this.concurrentSchedulingLimit);
    }

    @Override
    public boolean isRunToExhaustion() {
        return this.runToExhaustion;
    }

    @Override
    public boolean isMergeInputDeltas() {
        return this.mergeInputDeltas;
    }

    public int getMaxOutputDeltaSize() {
        return this.maxOutputDeltaSize;
    }

    public int getPeriodSeconds() {
        return this.periodSeconds;
    }

    public boolean isInWarmUp(int executionsSoFar) {
        return executionsSoFar < this.warmUpIterations;
    }

    public boolean isExternalDataTrigger() {
        return this.isPeriodic() && this.warmUpIterations > 0;
    }

    public boolean shouldRunPostBuildCompleteness() {
        return this.runPostBuildCompleteness;
    }

    public @Nullable RateLimitableResource getRemoteResource() {
        return this.remoteResource;
    }

    public UnmodifiableSet<String> getExpectedDeltaStoreNames() {
        return CollectionUtils.asUnmodifiable(this.expectedDeltas);
    }

    public UnmodifiableSet<String> getReadOnlyStores() {
        return CollectionUtils.asUnmodifiable(this.readOnlyStores);
    }

    public UnmodifiableSet<String> getReadOnlyPreviousStores() {
        return CollectionUtils.asUnmodifiable(this.readOnlyPreviousStores);
    }

    public boolean isReadOnlyPreviousAllParentsStore(String storeName) {
        return this.readOnlyPreviousStoresAllParents.contains(storeName);
    }

    @Override
    public Set<String> getReadStores() {
        return CollectionUtils.unionSet(this.readOnlyStores, (Collection[])new Collection[]{this.readBranchingLayerStores, this.expectedDeltas});
    }

    public UnmodifiableSet<String> getWriteStores() {
        return CollectionUtils.asUnmodifiable(this.readWriteStores);
    }

    public UnmodifiableSet<String> getWriteVirtualStores() {
        return CollectionUtils.asUnmodifiable(this.readWriteVirtualStores);
    }

    public UnmodifiableSet<String> getTransitiveWriteStores() {
        return CollectionUtils.asUnmodifiable(this.transitiveWriteStores);
    }

    void addTransitiveWriteStores(Collection<String> stores) {
        this.transitiveWriteStores.addAll(stores);
    }

    public UnmodifiableSet<String> getTransitiveWriteBlockingReadStores() {
        return CollectionUtils.asUnmodifiable(this.transitiveWriteBlockingReadStores);
    }

    void addTransitiveWriteBlockingReadStores(Collection<String> stores) {
        this.transitiveWriteBlockingReadStores.addAll(stores);
    }

    public UnmodifiableSet<String> getCrossCommitBlockingWriteStores() {
        return CollectionUtils.asUnmodifiable(this.crossCommitBlockingWriteStores);
    }

    void addCrossCommitWriteBlockingStore(String store) {
        this.crossCommitBlockingWriteStores.add(store);
    }

    public UnmodifiableSet<String> getReadBranchingLayerStores() {
        return CollectionUtils.asUnmodifiable(this.readBranchingLayerStores);
    }

    public Set<String> getAllInputStoresForCurrentRevision() {
        return CollectionUtils.unionSet(this.readOnlyStores, (Collection[])new Collection[]{this.readBranchingLayerStores, this.expectedDeltas});
    }

    void addStorageAccess(EStorageAccessAttribute accessAttribute, String storeName, boolean virtual) {
        switch (accessAttribute) {
            case READ_ONLY_INDEX_ATTRIBUTE_NAME: {
                this.readOnlyStores.add(storeName);
                break;
            }
            case READ_ONLY_ALL_PARENT_INDEXES_ATTRIBUTE_NAME: {
                this.readOnlyPreviousStoresAllParents.add(storeName);
            }
            case READ_ONLY_PREVIOUS_INDEX_ATTRIBUTE_NAME: {
                this.readOnlyPreviousStores.add(storeName);
                break;
            }
            case READ_WRITE_INDEX_ATTRIBUTE_NAME: {
                this.readWriteStores.add(storeName);
                if (!virtual) break;
                this.readWriteVirtualStores.add(storeName);
                break;
            }
            case BRANCHING_LAYER_ATTRIBUTE_NAME: {
                this.readBranchingLayerStores.add(storeName);
                break;
            }
            case DELTA_ATTRIBUTE_NAME: {
                this.expectedDeltas.add(storeName);
                break;
            }
            case READ_ONLY_GLOBAL_STORE_ATTRIBUTE_NAME: 
            case READ_WRITE_GLOBAL_STORE_ATTRIBUTE_NAME: {
                break;
            }
            default: {
                CCSMAssert.fail((String)("Unsupported access attribute: " + String.valueOf((Object)accessAttribute)));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resolveIndexName(IIndexName indexName) {
        String string;
        IIndexName iIndexName = indexName;
        Objects.requireNonNull(iIndexName);
        IIndexName iIndexName2 = iIndexName;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IIndexName.Fixed.class, IIndexName.Placeholder.class}, (IIndexName)iIndexName2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                IIndexName.Fixed fixed2 = (IIndexName.Fixed)iIndexName2;
                try {
                    String string2;
                    String fixed;
                    string = fixed = (string2 = fixed2.name());
                    return string;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        IIndexName.Placeholder placeholder = (IIndexName.Placeholder)iIndexName2;
        {
            String string3;
            String placeholder2 = string3 = placeholder.placeholder();
            string = this.resolvePlaceholder(placeholder2);
        }
        return string;
    }

    private String resolvePlaceholder(String placeholder) {
        return Optional.ofNullable((String)this.placeholderToIndexName.getSecond((Object)placeholder)).orElseThrow(() -> new IllegalStateException("Could not find resolved store for placeholder '%s'. Did you forget to resolve the index name with TriggerBuilder::resolveIndexNamePlaceholder?".formatted(placeholder)));
    }

    public String toString() {
        return this.getName();
    }

    public boolean isRollbackRelevant() {
        return this.rollbackRelevant;
    }

    @Override
    public int getRescheduleDelaySeconds() {
        return this.rescheduleDelaySeconds;
    }

    @Override
    public void setRescheduleDelaySeconds(int seconds) {
        this.rescheduleDelaySeconds = seconds;
    }

    @Override
    public ETriggerCost getExpectedCost() {
        return this.cost;
    }

    void setExpectedOverallCost(int expectedOverallCost) {
        this.expectedOverallCost = expectedOverallCost;
    }

    @Override
    public int getExpectedOverallCost() {
        return Math.max(this.expectedOverallCost, this.getExpectedCost().getCost());
    }

    @Override
    public boolean isCancelable() {
        return this.cancelable;
    }

    public AnalysisStepInitializer getAnalysisStepInitializer() {
        return this.analysisStepInitializer;
    }

    @Override
    public boolean isPreAnnouncingTrigger() {
        return this.analysisStepInitializer.isPreAnnouncingAnalysisStep();
    }

    @Override
    public boolean isPostBuildCompletenessTrigger() {
        return this.runPostBuildCompleteness;
    }
}

