/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.trigger;

import com.teamscale.core.analysis.trigger.IAnalysisStep;
import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.runtime.impl.analysis.trigger.ConcurrentSchedulingLimit;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public final class PrivilegedTrigger
implements ITrigger {
    private final PrivilegedTriggerBase delegate;
    private int rescheduleDelayInSeconds;

    public PrivilegedTrigger(PrivilegedTriggerBase delegate) {
        this.delegate = delegate;
    }

    public static PrivilegedTrigger createTrigger(String triggerName) throws TriggerCompilationException {
        try {
            Class<?> triggerClass = Class.forName(triggerName, true, Thread.currentThread().getContextClassLoader());
            if (!PrivilegedTriggerBase.class.isAssignableFrom(triggerClass)) {
                throw new TriggerCompilationException("Trigger class %s is not of type %s".formatted(triggerClass, PrivilegedTriggerBase.class));
            }
            return new PrivilegedTrigger((PrivilegedTriggerBase)triggerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TriggerCompilationException(e);
        }
    }

    @Override
    public ETriggerConcurrency getConcurrency() {
        return this.delegate.getConcurrency();
    }

    @Override
    public Optional<ConcurrentSchedulingLimit> getConcurrentSchedulingLimit() {
        return Optional.empty();
    }

    @Override
    public Class<? extends IAnalysisStep> getAnalysisStepClass() {
        return this.delegate.getClass();
    }

    @Override
    public int getExecutionOrderIndex() {
        return this.delegate.getExecutionOrderIndex();
    }

    @Override
    public ETriggerCost getExpectedCost() {
        return this.delegate.getExpectedCost();
    }

    @Override
    public int getExpectedOverallCost() {
        return this.delegate.getExpectedCost().getCost();
    }

    @Override
    public boolean isRunToExhaustion() {
        return false;
    }

    @Override
    public boolean isMergeInputDeltas() {
        return false;
    }

    @Override
    public boolean isPeriodic() {
        return this.delegate.isPeriodic();
    }

    @Override
    public boolean commitsNeedParentAdjustmentForPreviouslyForkedCommits() {
        return false;
    }

    @Override
    public Set<String> getReadStores() {
        return this.delegate.getReadStores();
    }

    @Override
    public Set<String> getReadOnlyPreviousStores() {
        return this.delegate.getReadOnlyPreviousStores();
    }

    @Override
    public Set<String> getWriteStores() {
        return this.delegate.getWriteStores();
    }

    @Override
    public Set<String> getWriteVirtualStores() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getTransitiveWriteStores() {
        return this.delegate.getTransitiveWriteStores();
    }

    @Override
    public Set<String> getTransitiveWriteBlockingReadStores() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getCrossCommitBlockingWriteStores() {
        return this.delegate.getCrossCommitBlockingWriteStores();
    }

    @Override
    public int getRescheduleDelaySeconds() {
        return this.rescheduleDelayInSeconds;
    }

    @Override
    public void setRescheduleDelaySeconds(int seconds) {
        this.rescheduleDelayInSeconds = seconds;
    }

    @Override
    public boolean canCauseSchedulingConflicts() {
        return this.delegate.canCauseSchedulingConflicts();
    }

    @Override
    public boolean preserveInCaseOfRollback() {
        return this.delegate.preserveInCaseOfRollback();
    }

    @Override
    public boolean isPreAnnouncingTrigger() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return this.delegate.isCancelable();
    }

    @Override
    public boolean isPostBuildCompletenessTrigger() {
        return false;
    }

    public PrivilegedTriggerBase getTriggerImplementation() {
        return this.delegate;
    }
}

