/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.progress;

import com.google.common.collect.Sets;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.rollback.RollbackTrigger;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyValueCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.compare.ComparableUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@Index(name="branch-analysis-state-index", valueClasses={AnalysisState.class})
public class BranchAnalysisStateIndex
extends IndexBase
implements IProjectIndex,
IRollbackableIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String INDEX_NAME = "branch-analysis-state-index";
    private static final String EARLIEST_ROLLBACK_BY_BRANCH = "###earliest-rollback-by-branch###";
    private static final String UPDATE_STATE_LOCK_NAME = "update-state";

    public BranchAnalysisStateIndex(IStore store) {
        super(store);
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        this.runLocked(UPDATE_STATE_LOCK_NAME, () -> {
            BranchesAnalysisState branchesAnalysisState = this.getBranchesAnalysisState(timestampByBranch.keySet());
            HashMap<String, Long> earliestRollbacksByBranch = branchesAnalysisState.earliestRollbackByBranch;
            HashMap<String, AnalysisState> rollbackStatesByBranch = new HashMap<String, AnalysisState>();
            branchesAnalysisState.analysisStateByBranch.forEach((branch, currentState) -> BranchAnalysisStateIndex.performRollbackOnBranch(timestampByBranch, earliestRollbacksByBranch, rollbackStatesByBranch, branch, currentState, rollbackId));
            this.setAnalysisStates(rollbackStatesByBranch, earliestRollbacksByBranch);
        });
    }

    private static void performRollbackOnBranch(Map<String, Long> timestampByBranch, HashMap<String, Long> earliestRollbacksByBranch, Map<String, AnalysisState> rollbackStatesByBranch, String branch, AnalysisState currentBranchState, UUID rollbackId) {
        long rollbackToTimestamp = timestampByBranch.get(branch);
        long existingRollbackTimestamp = earliestRollbacksByBranch.getOrDefault(branch, Long.MAX_VALUE);
        if (existingRollbackTimestamp < rollbackToTimestamp) {
            return;
        }
        long currentBranchStateTimestamp = currentBranchState.getTimestamp();
        if (currentBranchStateTimestamp < rollbackToTimestamp) {
            if (currentBranchState.getState() == EAnalysisState.ROLLBACK_ANALYSIS) {
                earliestRollbacksByBranch.put(branch, currentBranchStateTimestamp);
            }
            return;
        }
        rollbackStatesByBranch.put(branch, new AnalysisState(rollbackToTimestamp, EAnalysisState.getAnalysisStateAfterRollback(currentBranchState.getState()), rollbackId));
        earliestRollbacksByBranch.put(branch, rollbackToTimestamp);
    }

    public @Nullable AnalysisState getAnalysisState(String branch) throws StorageException {
        return (AnalysisState)StorageUtils.deserialize((byte[])this.store.getWithString(branch));
    }

    private BranchesAnalysisState getBranchesAnalysisState(Set<String> branches) throws StorageException {
        ArrayList<String> keys = new ArrayList<String>(branches);
        keys.add(EARLIEST_ROLLBACK_BY_BRANCH);
        List serializedAnalysisStates = this.store.getWithStrings(keys);
        HashMap<String, AnalysisState> analysisStatesByBranch = new HashMap<String, AnalysisState>();
        for (int i = 0; i < keys.size() - 1; ++i) {
            AnalysisState analysisState = (AnalysisState)StorageUtils.deserialize((byte[])((byte[])serializedAnalysisStates.get(i)));
            if (analysisState == null) continue;
            analysisStatesByBranch.put((String)keys.get(i), analysisState);
        }
        HashMap earliestRollbackByBranch = (HashMap)StorageUtils.deserialize((byte[])((byte[])serializedAnalysisStates.getLast()));
        return new BranchesAnalysisState(analysisStatesByBranch, Optional.ofNullable(earliestRollbackByBranch).orElse(new HashMap()));
    }

    public void updateBranchAnalysisStates(Set<String> branchesToUpdate, Set<ParentedCommitDescriptor> finishedCommits, Set<ParentedCommitDescriptor> unfinishedCommits, Set<CommitDescriptor> firstPreAnnouncedCommits, ScheduledJob completedJob) throws StorageException {
        unfinishedCommits = CollectionUtils.filterToSet(unfinishedCommits, commit -> branchesToUpdate.contains(commit.getBranchName()));
        firstPreAnnouncedCommits = CollectionUtils.filterToSet(firstPreAnnouncedCommits, commit -> branchesToUpdate.contains(commit.getBranchName()));
        Map<String, IUnfinishedCommit> earliestUnfinishedTimestampsByBranch = BranchAnalysisStateIndex.getEarliestUnfinishedTimestampsByBranch(unfinishedCommits, firstPreAnnouncedCommits);
        Map<String, ParentedCommitDescriptor> oldestFinishedCommitByBranch = BranchAnalysisStateIndex.getOldestCommitByBranch(finishedCommits);
        this.runLocked(UPDATE_STATE_LOCK_NAME, () -> {
            BranchesAnalysisState branchesAnalysisState = this.getBranchesAnalysisState(branchesToUpdate);
            Map<String, AnalysisState> newStates = this.collectNewStates(completedJob, earliestUnfinishedTimestampsByBranch, oldestFinishedCommitByBranch, branchesAnalysisState);
            newStates.entrySet().removeIf(entry -> Objects.equals(branchesAnalysisState.analysisStateByBranch.get(entry.getKey()), entry.getValue()));
            newStates.forEach((branchName, analysisState) -> {
                if (analysisState.getState() != EAnalysisState.ROLLBACK_ANALYSIS) {
                    branchesAnalysisState.earliestRollbackByBranch.remove(branchName);
                }
            });
            this.setAnalysisStates(newStates, branchesAnalysisState.earliestRollbackByBranch);
        });
    }

    private Map<String, AnalysisState> collectNewStates(ScheduledJob completedJob, Map<String, IUnfinishedCommit> earliestUnfinishedTimestampsByBranch, Map<String, ParentedCommitDescriptor> oldestFinishedCommitByBranch, BranchesAnalysisState branchesAnalysisState) throws StorageException {
        HashMap<String, AnalysisState> newStates = new HashMap<String, AnalysisState>();
        BranchesAnalysisState oldBranchesAnalysisState = this.getBranchesAnalysisState((Set<String>)Sets.union(oldestFinishedCommitByBranch.keySet(), earliestUnfinishedTimestampsByBranch.keySet()));
        Optional<UUID> jobRollbackId = Optional.ofNullable(completedJob.getJob().getRollbackId());
        for (Map.Entry<String, ParentedCommitDescriptor> entry : oldestFinishedCommitByBranch.entrySet()) {
            ParentedCommitDescriptor commitDescriptor = entry.getValue();
            UUID rollbackId = jobRollbackId.orElse(BranchAnalysisStateIndex.findExistingRollbackId(oldBranchesAnalysisState, entry.getKey()).orElse(null));
            if (earliestUnfinishedTimestampsByBranch.containsKey(commitDescriptor.getBranchName())) {
                EAnalysisState nextAnalysisState = this.getNextAnalysisState(branchesAnalysisState, new IUnfinishedCommit.KnownCommit(commitDescriptor));
                if (nextAnalysisState == null) {
                    LOGGER.error("Analysis state for branch " + commitDescriptor.getBranchName() + " is null. Should never happen, as we don't expect updates on pre-announcements.");
                    continue;
                }
                newStates.put(entry.getKey(), new AnalysisState(commitDescriptor.getTimestamp(), nextAnalysisState, rollbackId));
                continue;
            }
            if (completedJob.getJob().getTriggerName().equals(RollbackTrigger.class.getName())) continue;
            newStates.put(entry.getKey(), new AnalysisState(commitDescriptor.getTimestamp(), EAnalysisState.LIVE_ANALYSIS, rollbackId));
        }
        for (Map.Entry<String, Object> entry : earliestUnfinishedTimestampsByBranch.entrySet()) {
            if (oldestFinishedCommitByBranch.containsKey(entry.getKey()) || branchesAnalysisState.analysisStateByBranch.containsKey(entry.getKey())) continue;
            UUID rollbackId = jobRollbackId.orElse(BranchAnalysisStateIndex.findExistingRollbackId(oldBranchesAnalysisState, entry.getKey()).orElse(null));
            EAnalysisState nextAnalysisState = this.getNextAnalysisState(branchesAnalysisState, (IUnfinishedCommit)entry.getValue());
            if (nextAnalysisState == null) continue;
            newStates.put(entry.getKey(), new AnalysisState(0L, nextAnalysisState, rollbackId));
        }
        return newStates;
    }

    private static Optional<UUID> findExistingRollbackId(BranchesAnalysisState oldBranchesAnalysisState, String branchName) {
        return Optional.ofNullable(oldBranchesAnalysisState.analysisStateByBranch.get(branchName)).map(AnalysisState::getRollbackId);
    }

    private static Map<String, ParentedCommitDescriptor> getOldestCommitByBranch(Collection<ParentedCommitDescriptor> finishedCommits) {
        HashMap<String, ParentedCommitDescriptor> result = new HashMap<String, ParentedCommitDescriptor>();
        for (ParentedCommitDescriptor commit : finishedCommits) {
            result.merge(commit.getBranchName(), commit, (x$0, x$1) -> (ParentedCommitDescriptor)ComparableUtils.min((Comparable)x$0, (Comparable)x$1, (Comparable[])new ParentedCommitDescriptor[0]));
        }
        return result;
    }

    /*
     * Loose catch block
     */
    private EAnalysisState getNextAnalysisState(BranchesAnalysisState branchesAnalysisState, IUnfinishedCommit unfinishedCommit) throws StorageException {
        EAnalysisState oldState;
        AnalysisState previousState = branchesAnalysisState.analysisStateByBranch.get(unfinishedCommit.commit().getBranchName());
        if (previousState != null) {
            oldState = previousState.getState();
        } else {
            IUnfinishedCommit iUnfinishedCommit = unfinishedCommit;
            Objects.requireNonNull(iUnfinishedCommit);
            IUnfinishedCommit iUnfinishedCommit2 = iUnfinishedCommit;
            int n = 0;
            block13: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IUnfinishedCommit.KnownCommit.class, IUnfinishedCommit.KnownCommit.class, IUnfinishedCommit.PreAnnouncement.class}, (IUnfinishedCommit)iUnfinishedCommit2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        IUnfinishedCommit.KnownCommit knownCommit;
                        IUnfinishedCommit.KnownCommit knownCommit2 = (IUnfinishedCommit.KnownCommit)iUnfinishedCommit2;
                        IUnfinishedCommit.KnownCommit parentedCommit = knownCommit = knownCommit2.parentedCommit();
                        if (!parentedCommit.isStartCommit()) {
                            n = 1;
                            continue block13;
                        }
                        return EAnalysisState.INITIAL_ANALYSIS;
                    }
                    case 1: {
                        ParentedCommitDescriptor parentedCommitDescriptor;
                        IUnfinishedCommit.KnownCommit knownCommit = (IUnfinishedCommit.KnownCommit)iUnfinishedCommit2;
                        ParentedCommitDescriptor parentedCommit = parentedCommitDescriptor = knownCommit.parentedCommit();
                        oldState = this.getParentsState(branchesAnalysisState, parentedCommit);
                        break block13;
                    }
                    case 2: {
                        return null;
                    }
                }
                break;
            }
        }
        return switch (oldState) {
            default -> throw new MatchException(null, null);
            case EAnalysisState.ROLLBACK_ANALYSIS -> EAnalysisState.ROLLBACK_ANALYSIS;
            case EAnalysisState.LIVE_ANALYSIS, EAnalysisState.CATCHUP_LIVE_ANALYSIS -> EAnalysisState.CATCHUP_LIVE_ANALYSIS;
            case EAnalysisState.INITIAL_ANALYSIS, EAnalysisState.HISTORY_ANALYSIS -> EAnalysisState.HISTORY_ANALYSIS;
        };
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private @NonNull EAnalysisState getParentsState(BranchesAnalysisState branchesAnalysisState, ParentedCommitDescriptor parentCommit) throws StorageException {
        AnalysisState potentialParentState = branchesAnalysisState.analysisStateByBranch.get(parentCommit.getFirstParentCommit().getBranchName());
        if (potentialParentState != null) {
            return potentialParentState.getState();
        }
        potentialParentState = this.getAnalysisState(parentCommit.getFirstParentCommit().getBranchName());
        if (potentialParentState != null) {
            return potentialParentState.getState();
        }
        return EAnalysisState.INITIAL_ANALYSIS;
    }

    private static void updateWithMinimumTimestamp(Map<String, IUnfinishedCommit> earliestUnfinishedCommitTimestampByBranch, IUnfinishedCommit commit) {
        earliestUnfinishedCommitTimestampByBranch.merge(commit.commit().getBranchName(), commit, (x$0, x$1) -> (IUnfinishedCommit)ComparableUtils.min((Comparable)x$0, (Comparable)x$1, (Comparable[])new IUnfinishedCommit[0]));
    }

    private static Map<String, IUnfinishedCommit> getEarliestUnfinishedTimestampsByBranch(Set<ParentedCommitDescriptor> unfinishedCommits, Set<CommitDescriptor> preAnnouncedCommits) {
        HashMap<String, IUnfinishedCommit> earliestUnfinishedCommitTimestampByBranch = new HashMap<String, IUnfinishedCommit>();
        unfinishedCommits.forEach(commit -> BranchAnalysisStateIndex.updateWithMinimumTimestamp(earliestUnfinishedCommitTimestampByBranch, new IUnfinishedCommit.KnownCommit((ParentedCommitDescriptor)commit)));
        preAnnouncedCommits.forEach(commit -> BranchAnalysisStateIndex.updateWithMinimumTimestamp(earliestUnfinishedCommitTimestampByBranch, new IUnfinishedCommit.PreAnnouncement((CommitDescriptor)commit)));
        return earliestUnfinishedCommitTimestampByBranch;
    }

    private void setAnalysisStates(Map<String, AnalysisState> newStates, HashMap<String, Long> earliestRollbackByBranch) throws StorageException {
        PairList updatedData = new PairList();
        for (Map.Entry<String, AnalysisState> entry : newStates.entrySet()) {
            updatedData.add((Object)entry.getKey(), (Object)StorageUtils.serialize((Serializable)entry.getValue()));
        }
        updatedData.add((Object)EARLIEST_ROLLBACK_BY_BRANCH, (Object)StorageUtils.serialize(earliestRollbackByBranch));
        this.store.putWithStrings(updatedData);
    }

    @TestOnly
    public void setAnalysisStateForTesting(CommitDescriptor commit, EAnalysisState analysisState) throws StorageException {
        this.store.putWithString(commit.getBranchName(), StorageUtils.serialize((Serializable)new AnalysisState(commit.getTimestamp(), analysisState, UUID.fromString("00000000-1111-2222-3333-444444444444"))));
    }

    public Set<String> getBranchesInRollback() throws StorageException {
        HashSet<String> branchNames = new HashSet<String>();
        PairList rawAnalysisStates = new PairList();
        this.store.scan("", (IKeyValueCallback)new KeyValueCollectingCallback(rawAnalysisStates));
        for (Pair rawAnalysisState : rawAnalysisStates) {
            AnalysisState analysisState;
            String deserializedKey = StringUtils.bytesToString((byte[])((byte[])rawAnalysisState.getFirst()));
            if (deserializedKey.equals(EARLIEST_ROLLBACK_BY_BRANCH) || (analysisState = (AnalysisState)StorageUtils.deserialize((byte[])((byte[])rawAnalysisState.getSecond()))).getState() != EAnalysisState.ROLLBACK_ANALYSIS) continue;
            branchNames.add(deserializedKey);
        }
        return branchNames;
    }

    public void setBranchToLive(String branch) throws StorageException {
        AnalysisState analysisState = this.getAnalysisState(branch);
        this.store.putWithString(branch, StorageUtils.serialize((Serializable)new AnalysisState(Optional.ofNullable(analysisState).map(AnalysisState::getTimestamp).orElse(0L), EAnalysisState.LIVE_ANALYSIS, null)));
    }

    public boolean isCommitProcessed(UnresolvedCommitDescriptor commit) throws StorageException {
        if (commit.getBranchName() == null) {
            throw new StorageException("Cannot determine if commit is processed without branch name");
        }
        AnalysisState analysisState = this.getAnalysisState(commit.getBranchName());
        if (analysisState == null) {
            return false;
        }
        if (analysisState.getState() == EAnalysisState.LIVE_ANALYSIS) {
            return true;
        }
        return analysisState.getTimestamp() >= commit.getTimestamp();
    }

    private record BranchesAnalysisState(Map<String, @Nullable AnalysisState> analysisStateByBranch, HashMap<String, Long> earliestRollbackByBranch) {
    }

    @NullMarked
    private static sealed interface IUnfinishedCommit
    extends Comparable<IUnfinishedCommit> {
        public CommitDescriptor commit();

        @Override
        default public int compareTo(IUnfinishedCommit o) {
            return this.commit().compareTo(o.commit());
        }

        public record PreAnnouncement(CommitDescriptor commit) implements IUnfinishedCommit
        {
        }

        public record KnownCommit(ParentedCommitDescriptor parentedCommit) implements IUnfinishedCommit
        {
            @Override
            public CommitDescriptor commit() {
                return this.parentedCommit.getCommit();
            }
        }
    }
}

