/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.project;

import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.IndexSchemaCache;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.rollback.StoreRollbackUtils;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.RemovalCostCapability;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class ReanalyzeProjectTrigger
extends PrivilegedTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String TEMPORARY_STORAGE_PREFIX = "re_analyze_temp_partition_";
    public static final String PROJECT_STORE_LOCK_PREFIX = "re_analyze_project_store_";
    public static final String TEMPORARY_STORE_LOCK_PREFIX = "re_analyze_temp_store_";
    private static final UnmodifiableSet<String> STORES_TO_KEEP_AFTER_REANALYSIS = CollectionUtils.asUnmodifiable((Set)CollectionUtils.asHashSet((Object[])new String[]{"_meta", "string-abbreviation", "project-critical-event-worker-log", "project-critical-event-log"}));

    @Override
    public void execute() throws StorageException {
        IStorageSystemProvider rawStorageSystemProvider = this.indexLayer.getRawStorageSystemProvider();
        String projectName = this.jobDescriptor.getInternalProjectId().toString();
        IStorageSystem partition = rawStorageSystemProvider.openStorageSystem(projectName);
        IndexSchema schema = IndexSchema.load((IStorageSystem)partition, (SynchronizedCacheAccess)IndexSchemaCache.UNCACHED_ACCESS);
        this.addPostTriggerAction(new IPostTriggerAction.DiscardScheduledJobs(Collections.emptyMap()));
        Optional removalCostCapability = rawStorageSystemProvider.getCapability(RemovalCostCapability.class);
        if (removalCostCapability.isPresent() && ((RemovalCostCapability)removalCostCapability.get()).storeRemovalCheap()) {
            ReanalyzeProjectTrigger.reanalyzeUsingStoreDelete(partition, schema);
            this.rollbackRollbackableStoresInBackupAndInvalidateCaches(partition, schema);
        } else {
            try {
                this.reanalyzeUsingPartitionDelete(rawStorageSystemProvider, partition, schema);
            }
            catch (Throwable t) {
                this.restoreMetaIndex(rawStorageSystemProvider);
                throw t;
            }
            finally {
                this.rollbackRollbackableStoresInBackupAndInvalidateCaches(rawStorageSystemProvider.openStorageSystem(projectName), schema);
            }
        }
    }

    private void rollbackRollbackableStoresInBackupAndInvalidateCaches(IStorageSystem partition, IndexSchema schema) throws StorageException {
        StorageCacheProvider.StorageSystemCacheProvider cacheProvider = this.indexLayer.getStorageCacheProvider().getCacheProvider(this.jobDescriptor.getInternalProjectId().toString());
        SchemaAwareStorageSystem storageSystem = new SchemaAwareStorageSystem(partition, schema, cacheProvider);
        for (String storeName : schema.getEntryNames()) {
            if (!schema.isStoreUsingOption(storeName, EStorageOption.BACKUP) || schema.isStoreUsingOption(storeName, EStorageOption.NO_ROLLBACK)) continue;
            StoreRollbackUtils.performRollback((SchemaAwareStorageSystem)storageSystem, (String)storeName, (IndexSchema)schema, Collections.emptyMap(), (UUID)this.jobDescriptor.getRollbackId());
        }
        cacheProvider.invalidateCaches();
    }

    private static void reanalyzeUsingStoreDelete(IStorageSystem partition, IndexSchema schema) throws StorageException {
        for (String storeName : schema.getEntryNames()) {
            if (ReanalyzeProjectTrigger.isBackupedOrMetaStore(storeName, schema)) continue;
            partition.removeStore(storeName);
        }
    }

    private void restoreMetaIndex(IStorageSystemProvider rawStorageSystemProvider) {
        try {
            IStorageSystem partition = rawStorageSystemProvider.openStorageSystem(this.jobDescriptor.getInternalProjectId().toString());
            IStorageSystem tmpPartition = rawStorageSystemProvider.openStorageSystem(this.getTempPartitionName());
            StorageUtils.copyStore((IStore)tmpPartition.openStore("_meta"), (IStore)partition.openStore("_meta"));
        }
        catch (StorageException e) {
            LOGGER.error("Could not restore meta index: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reanalyzeUsingPartitionDelete(IStorageSystemProvider rawStorageSystemProvider, IStorageSystem partition, IndexSchema schema) throws StorageException {
        IStorageSystem tmpPartition;
        ArrayList<String> backupedStoreNames = new ArrayList<String>();
        Lock tempPartitionLock = this.lockProvider.obtainLock(TEMPORARY_STORE_LOCK_PREFIX + String.valueOf(this.jobDescriptor.getInternalProjectId()));
        tempPartitionLock.lock();
        try {
            tmpPartition = rawStorageSystemProvider.openStorageSystem(this.getTempPartitionName());
            for (String storeName : schema.getEntryNames()) {
                if (!ReanalyzeProjectTrigger.isBackupedOrMetaStore(storeName, schema)) continue;
                StorageUtils.copyStore((IStore)partition.openStore(storeName), (IStore)tmpPartition.openStore(storeName));
                backupedStoreNames.add(storeName);
            }
        }
        finally {
            tempPartitionLock.unlock();
        }
        this.overwriteProjectStorageWithTmpPartition(rawStorageSystemProvider, tmpPartition, backupedStoreNames, tempPartitionLock);
    }

    private static boolean isBackupedOrMetaStore(String storeName, IndexSchema schema) {
        return STORES_TO_KEEP_AFTER_REANALYSIS.contains((Object)storeName) || schema.isStoreUsingOption(storeName, EStorageOption.BACKUP);
    }

    private String getTempPartitionName() {
        return TEMPORARY_STORAGE_PREFIX + String.valueOf(this.jobDescriptor.getInternalProjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void overwriteProjectStorageWithTmpPartition(IStorageSystemProvider rawStorageSystemProvider, IStorageSystem tmpPartition, List<String> backupedStoreNames, Lock tempPartitionLock) throws StorageException {
        Lock projectPartitionLock = this.lockProvider.obtainLock(PROJECT_STORE_LOCK_PREFIX + String.valueOf(this.jobDescriptor.getInternalProjectId()));
        projectPartitionLock.lock();
        try {
            rawStorageSystemProvider.removeStorageSystem(this.jobDescriptor.getInternalProjectId().toString());
            IStorageSystem partition = rawStorageSystemProvider.openStorageSystem(this.jobDescriptor.getInternalProjectId().toString());
            for (String storeName : backupedStoreNames) {
                StorageUtils.copyStore((IStore)tmpPartition.openStore(storeName), (IStore)partition.openStore(storeName));
            }
        }
        finally {
            projectPartitionLock.unlock();
        }
        tempPartitionLock.lock();
        try {
            rawStorageSystemProvider.removeStorageSystem(this.getTempPartitionName());
        }
        finally {
            tempPartitionLock.unlock();
        }
    }

    @Override
    public int getExecutionOrderIndex() {
        return -2;
    }

    @Override
    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.PRIORITY_FULLY_ISOLATED;
    }

    @Override
    public ETriggerCost getExpectedCost() {
        return ETriggerCost.EXPENSIVE;
    }

    @Override
    public boolean shouldRescheduleOnError() {
        return true;
    }
}

