/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.rollback;

import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.debug.DebugDumperBase;
import com.teamscale.core.debug.DebugDumperRegistry;
import com.teamscale.core.debug.EDebugDumpEvent;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.impl.rollback.IRollbackTrigger;
import com.teamscale.core.runtime.impl.rollback.RollbackLogIndex;
import io.prometheus.metrics.core.datapoints.DistributionDataPoint;
import io.prometheus.metrics.core.metrics.Summary;
import java.io.PrintWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.rollback.StoreRollbackUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.jspecify.annotations.Nullable;

public final class RollbackTrigger
extends PrivilegedTriggerBase
implements IRollbackTrigger {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ALL_BRANCHES = "#all-branches#";
    private static final Summary ROLLBACK_SUMMARY = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.builder().name("executed_rollback_size")).help("The size of rollbacks in commits.")).labelNames(new String[]{"project"})).numberOfAgeBuckets(24).maxAgeSeconds(Duration.ofDays(1L).toSeconds()).quantile(0.5, 0.005).quantile(0.9, 0.005).quantile(0.95, 0.005).register();
    private static final Summary ROLLBACK_DURATION = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.builder().name("executed_rollback_duration_seconds")).help("The duration of rollbacks in seconds.")).labelNames(new String[]{"project"})).numberOfAgeBuckets(24).maxAgeSeconds(Duration.ofDays(1L).toSeconds()).quantile(0.5, 0.005).quantile(0.9, 0.005).quantile(0.95, 0.005).register();

    @Override
    public void execute() throws StorageException, JsonSerializationException {
        long start = System.currentTimeMillis();
        InternalProjectId projectId = this.jobDescriptor.getInternalProjectId();
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)projectId);
        RollbackRequest rollbackRequest = this.jobDescriptor.getParameterObject(RollbackRequest.class);
        ProjectInfo projectInfo = this.indexLayer.openProjectIndex().resolveProject((IProjectId)projectId);
        this.signalPreRollback(projectInfo, rollbackRequest, this.jobDescriptor.getRollbackId());
        Map<String, Long> timestampForBranch = RollbackTrigger.buildRollbackTimestampForBranchMap(rollbackRequest, projectStorageSystem);
        CounterSet<ECommitTreeNodeState> rolledBackStateCount = RollbackTrigger.determineRolledBackStateCount(projectStorageSystem, timestampForBranch);
        LOGGER.info("Performing rollback {}", (Object)rollbackRequest);
        StoreRollbackUtils.performRollback((SchemaAwareStorageSystem)projectStorageSystem, timestampForBranch, (UUID)this.jobDescriptor.getRollbackId());
        this.addPostTriggerAction(new IPostTriggerAction.DiscardScheduledJobs(timestampForBranch));
        this.addPostTriggerAction(new IPostTriggerAction.SchedulePeriodicJobs());
        this.signalPostRollback(projectInfo, timestampForBranch, this.jobDescriptor.getRollbackId());
        double rollbackDurationInSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start);
        RollbackTrigger.logRollbackInfo(projectStorageSystem, timestampForBranch, rollbackDurationInSeconds, rolledBackStateCount, this.jobDescriptor.getRollbackId());
        ((DistributionDataPoint)ROLLBACK_SUMMARY.labelValues(new String[]{projectInfo.getPrimaryPublicId().projectId})).observe((double)rolledBackStateCount.getValue((Object)ECommitTreeNodeState.PROCESSED));
        ((DistributionDataPoint)ROLLBACK_DURATION.labelValues(new String[]{projectInfo.getPrimaryPublicId().projectId})).observe(rollbackDurationInSeconds);
    }

    private static void logRollbackInfo(ProjectStorageSystem projectStorage, Map<String, Long> timestampForBranch, double executionTime, CounterSet<ECommitTreeNodeState> rolledBackStateCount, UUID rollbackId) throws StorageException {
        long minimalTimestamp = timestampForBranch.values().stream().mapToLong(x -> x).min().orElse(System.currentTimeMillis());
        RollbackLogIndex.RollbackLogEntry logEntry = new RollbackLogIndex.RollbackLogEntry(timestampForBranch.keySet(), rolledBackStateCount, minimalTimestamp, executionTime, rollbackId);
        ((RollbackLogIndex)projectStorage.openProjectIndex(RollbackLogIndex.class, null)).addLogEntry(logEntry);
    }

    public static CounterSet<ECommitTreeNodeState> determineRolledBackStateCount(ProjectStorageSystem projectStorage, Map<String, Long> timestampForBranch) throws StorageException {
        CounterSet rolledBackStateCount = new CounterSet();
        CommitTreeIndex.listCommitTrees(projectStorage).forEach((storeName, commitTree) -> {
            for (ICommitTreeNode iCommitTreeNode : commitTree.getAllNodes()) {
                if (timestampForBranch.getOrDefault(iCommitTreeNode.getBranchName(), Long.MAX_VALUE) >= iCommitTreeNode.getAdjustedTimestamp().orElse(0L)) continue;
                rolledBackStateCount.inc((Object)iCommitTreeNode.getState());
            }
        });
        return rolledBackStateCount;
    }

    private void signalPreRollback(ProjectInfo projectInfo, final RollbackRequest rollbackRequest, @Nullable UUID rollbackId) {
        DebugDumperBase inputCommitDumper = new DebugDumperBase(this, "rollback-request", true){
            {
                Objects.requireNonNull(this$0);
                super(name, projectSpecific);
            }

            @Override
            public void dump(IndexLayer indexLayer, InternalProjectId projectId, PrintWriter writer) {
                writer.println(rollbackRequest);
            }
        };
        DebugDumperRegistry.getInstance().signalEvent(EDebugDumpEvent.PRE_ROLLBACK, projectInfo, this.indexLayer, rollbackId, inputCommitDumper);
    }

    private void signalPostRollback(ProjectInfo projectInfo, final Map<String, Long> timestampForBranch, @Nullable UUID rollbackId) {
        DebugDumperBase timestampForBranchDumper = new DebugDumperBase(this, "rollback-map", true){
            {
                Objects.requireNonNull(this$0);
                super(name, projectSpecific);
            }

            @Override
            public void dump(IndexLayer indexLayer, InternalProjectId projectId, PrintWriter writer) {
                timestampForBranch.forEach((key, value) -> writer.println(key + " -> " + value));
            }
        };
        DebugDumperRegistry.getInstance().signalEvent(EDebugDumpEvent.POST_ROLLBACK, projectInfo, this.indexLayer, rollbackId, timestampForBranchDumper);
    }

    public static Map<String, Long> buildRollbackTimestampForBranchMap(RollbackRequest rollbackRequest, ProjectStorageSystem projectStorageSystem) throws StorageException {
        if (PreCommitUtils.isPrecommitBranch(rollbackRequest.schedulingCommit().getBranchName())) {
            return Collections.singletonMap(rollbackRequest.schedulingCommit().getBranchName(), rollbackRequest.schedulingCommit().getTimestamp());
        }
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        ArrayList<ParentedCommitDescriptor> allCommits = new ArrayList<ParentedCommitDescriptor>(commitDescriptorIndex.getAllCommits());
        allCommits.addAll(RollbackTrigger.extractCommitsFromCommitTrees(projectStorageSystem));
        Map<String, Long> timestampForBranch = RollbackTrigger.prepareTimestampByBranchName(rollbackRequest, allCommits);
        RollbackTrigger.ensureRollbackConsistency(timestampForBranch, allCommits);
        return timestampForBranch;
    }

    private static List<ParentedCommitDescriptor> extractCommitsFromCommitTrees(ProjectStorageSystem projectStorage) throws StorageException {
        ArrayList<ParentedCommitDescriptor> allCommits = new ArrayList<ParentedCommitDescriptor>();
        CommitTreeIndex.listCommitTrees(projectStorage).forEach((storeName, commitTree) -> {
            for (ICommitTreeNode iCommitTreeNode : commitTree.getAllNodes()) {
                if (!iCommitTreeNode.getAdjustedTimestamp().isPresent()) continue;
                LOGGER.debug("Trying to create a parented commit descriptor for node: {}; parents: {}", (Object)iCommitTreeNode, iCommitTreeNode.getParents());
                ParentedCommitDescriptor commit = new ParentedCommitDescriptor(RollbackTrigger.getAdjustedCommitDescriptor(iCommitTreeNode), CollectionUtils.map(iCommitTreeNode.getParents(), RollbackTrigger::getAdjustedCommitDescriptor));
                allCommits.add(commit);
            }
        });
        return allCommits;
    }

    private static CommitDescriptor getAdjustedCommitDescriptor(ICommitTreeNode node) {
        if (node.getAdjustedTimestamp().isPresent()) {
            return node.getCommitDescriptorWithAdjustedTimestamp();
        }
        return node.getCommitDescriptorWithOriginalTimestamp();
    }

    private static Map<String, Long> prepareTimestampByBranchName(RollbackRequest rollbackRequest, List<ParentedCommitDescriptor> allCommits) {
        HashMap<String, Long> timestampForBranch = new HashMap<String, Long>();
        if (ALL_BRANCHES.equals(rollbackRequest.schedulingCommit().getBranchName())) {
            allCommits.stream().map(ParentedCommitDescriptor::getCommit).map(CommitDescriptor::getBranchName).distinct().forEach(branchName -> timestampForBranch.put((String)branchName, rollbackRequest.schedulingCommit().getTimestamp()));
        } else {
            for (CommitDescriptor commit : rollbackRequest.rollbackCommits()) {
                timestampForBranch.merge(commit.getBranchName(), commit.getTimestamp(), Math::min);
            }
        }
        return timestampForBranch;
    }

    private static void ensureRollbackConsistency(Map<String, Long> timestampForBranch, List<ParentedCommitDescriptor> allCommits) {
        allCommits.sort(Comparator.naturalOrder());
        boolean changed = true;
        while (changed) {
            changed = false;
            for (ParentedCommitDescriptor commit : allCommits) {
                if (RollbackTrigger.shouldBeDeleted(commit.getCommit(), timestampForBranch) || !RollbackTrigger.shouldAnyBeDeleted((Collection<CommitDescriptor>)commit.getParentCommits(), timestampForBranch)) continue;
                changed = true;
                timestampForBranch.merge(commit.getBranchName(), commit.getTimestamp() - 1L, Math::min);
            }
        }
    }

    private static boolean shouldAnyBeDeleted(Collection<CommitDescriptor> commits, Map<String, Long> timestampForBranch) {
        for (CommitDescriptor commit : commits) {
            if (!RollbackTrigger.shouldBeDeleted(commit, timestampForBranch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getExecutionOrderIndex() {
        return -2;
    }

    @Override
    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.ROLLBACK_ISOLATED;
    }

    @Override
    public ETriggerCost getExpectedCost() {
        return ETriggerCost.EXPENSIVE;
    }

    public static boolean shouldBeDeleted(CommitDescriptor commit, Map<String, Long> timestampByBranch) {
        Long cutOffTimestamp = timestampByBranch.get(commit.getBranchName());
        return cutOffTimestamp != null && commit.getTimestamp() > cutOffTimestamp;
    }
}

