/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.ScheduleOptionUtils;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.progress.AnalysisProgressIndexBase;
import com.teamscale.core.runtime.impl.scheduling.PeriodicMaintenanceJobRegistry;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.SchedulingHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.collections.DurableCounterSet;
import org.conqat.engine.persistence.index.collections.DurableDistributedList;
import org.conqat.engine.persistence.index.collections.DurableSet;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;

public class PeriodicJobSupport {
    private static final Logger LOGGER = LogManager.getLogger();
    private final InternalProjectId projectId;
    private final DurableSet<String> exhaustedTriggers;
    private final DurableDistributedList<String> externallyScheduledTriggers;
    private final DurableDistributedList<JobDescriptor> externallyScheduledJobs;
    private final DurableCounterSet<String> periodicExecutionCounts;
    private final SchedulingHelper schedulingHelper;
    private final IndexLayer indexLayer;
    private volatile boolean invalid;

    public PeriodicJobSupport(InternalProjectId projectId, AnalysisProgressIndexBase progressIndex, SchedulingHelper schedulingHelper, IndexLayer indexLayer) throws StorageException {
        this.projectId = projectId;
        this.exhaustedTriggers = progressIndex.createExhaustedTriggersSet();
        this.externallyScheduledTriggers = progressIndex.createExternallyScheduledTriggersSet(projectId, indexLayer.getMessageBroker());
        this.externallyScheduledJobs = progressIndex.createExternallyScheduledJobsSet(projectId, indexLayer.getMessageBroker());
        this.periodicExecutionCounts = progressIndex.createPeriodicExecutionCountsSet();
        this.schedulingHelper = schedulingHelper;
        this.indexLayer = indexLayer;
    }

    public void schedulePeriodicJobs(long seconds, boolean force) throws StorageException {
        this.scheduleExternalJobs();
        if (SchedulingConstants.isMaintenance((IProjectId)this.projectId)) {
            this.schedulePeriodicMaintenanceTriggers(seconds);
            return;
        }
        if (this.periodicExecutionCounts.getTotal() == 0) {
            seconds = 0L;
        }
        HashSet externallyScheduledTriggers = new HashSet(this.externallyScheduledTriggers.getAllAndClear());
        for (AnalysisTrigger trigger : this.schedulingHelper.getTriggerCache().getPeriodicTriggers()) {
            boolean isExternallyScheduled;
            if (!this.shouldBeScheduledForPeriod(trigger, seconds, force, isExternallyScheduled = externallyScheduledTriggers.remove(trigger.getName()))) continue;
            this.periodicExecutionCounts.inc((Serializable)((Object)trigger.getName()), 1);
            this.schedulingHelper.scheduleJob(JobDescriptor.forProject(this.schedulingHelper.getInternalProjectId()).withTrigger(trigger).withSchedulingReason("Scheduled as periodic job.").build());
        }
    }

    private void scheduleExternalJobs() throws StorageException {
        SetMap externalJobsSchedulingCommitToJobsMapping = new SetMap();
        for (JobDescriptor job : this.externallyScheduledJobs.getAllAndClear()) {
            externalJobsSchedulingCommitToJobsMapping.add((Object)job.getSchedulingCommitDescriptor(), (Object)job);
        }
        for (Map.Entry entry : externalJobsSchedulingCommitToJobsMapping.entrySet()) {
            Set scheduledJobsForCommit = CollectionUtils.mapToSet(this.schedulingHelper.getJobQueue().getJobsForCommit((CommitDescriptor)entry.getKey()), ScheduledJob::getJob);
            for (JobDescriptor externalJobToSchedule : (Set)entry.getValue()) {
                if (!scheduledJobsForCommit.add(externalJobToSchedule)) continue;
                this.schedulingHelper.scheduleJob(externalJobToSchedule);
            }
        }
    }

    private void schedulePeriodicMaintenanceTriggers(long currentTimeSeconds) throws StorageException {
        if (currentTimeSeconds <= 0L || currentTimeSeconds % 60L != 0L) {
            return;
        }
        PeriodicJobSupport.getOptionScheduledJobs(currentTimeSeconds * 1000L, this.indexLayer).forEach(this.schedulingHelper::scheduleJob);
        PeriodicMaintenanceJobRegistry.getInstance().getScheduledJobs(currentTimeSeconds * 1000L).forEach(this.schedulingHelper::scheduleJob);
    }

    private static List<JobDescriptor> getOptionScheduledJobs(long currentTimeMillis, IndexLayer indexLayer) throws StorageException {
        SetMap<String, Class<? extends OptionScheduledTriggerBase>> optionsWithTriggerClasses = ScheduleOptionUtils.getOptionScheduledTriggers(currentTimeMillis, indexLayer);
        ArrayList<JobDescriptor> jobs = new ArrayList<JobDescriptor>();
        for (Map.Entry optionWithTriggerClasses : optionsWithTriggerClasses) {
            String optionName = (String)optionWithTriggerClasses.getKey();
            for (Class triggerClass : (Set)optionWithTriggerClasses.getValue()) {
                jobs.add(JobDescriptor.forMaintenanceProject().withPrivilegedTrigger(triggerClass).withSchedulingReason("Scheduled due to option: " + optionName).withParameter(optionName).build());
            }
        }
        return jobs;
    }

    private boolean shouldBeScheduledForPeriod(AnalysisTrigger trigger, long seconds, boolean force, boolean isExternallyScheduled) {
        boolean isRegularlyScheduled;
        String triggerName = trigger.getName();
        if (!trigger.isPeriodic() || this.exhaustedTriggers.contains((Object)triggerName)) {
            return false;
        }
        if (force) {
            return true;
        }
        boolean bl = isRegularlyScheduled = trigger.isInWarmUp(this.periodicExecutionCounts.getValue((Serializable)((Object)triggerName))) || this.isRegularlyScheduled(seconds, trigger.getPeriodSeconds());
        if (!isExternallyScheduled && !isRegularlyScheduled) {
            return false;
        }
        if (this.schedulingHelper.existsJob(triggerName, null, !isExternallyScheduled)) {
            return false;
        }
        return trigger.isRollbackRelevant() || !this.schedulingHelper.existsJob(triggerName, null, true);
    }

    private boolean isRegularlyScheduled(long seconds, int triggerPeriod) {
        if (seconds == 0L) {
            return true;
        }
        return seconds % (long)triggerPeriod == (long)this.schedulingHelper.getSchedulingOffset(triggerPeriod);
    }

    public void markTriggerAsExhausted(String triggerName) {
        LOGGER.info("Marking trigger " + triggerName + " as exhausted");
        this.exhaustedTriggers.add((Serializable)((Object)triggerName));
    }

    public void resetExecutionCounts() {
        this.periodicExecutionCounts.clear();
    }

    public InternalProjectId getProjectId() {
        return this.projectId;
    }

    public SchedulingHelper getSchedulingHelper() {
        return this.schedulingHelper;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void markInvalid() {
        this.invalid = true;
    }
}

