/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.commons.annotation.ClassIndexUtils;
import com.teamscale.core.analysis.PeriodicMaintenanceJob;
import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.cron.CronExpression;
import com.teamscale.core.cron.InvalidCronPatternException;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;

public class PeriodicMaintenanceJobRegistry {
    public static final String DAILY_CRON_EXPRESSION_VALUE = "0 0 * * *";
    public static final CronExpression DAILY_CRON_EXPRESSION = CronExpression.of("0 0 * * *");
    public static final String HOURLY_CRON_EXPRESSION = "0 * * * *";
    private static final Logger LOGGER = LogManager.getLogger();
    private static PeriodicMaintenanceJobRegistry instance;
    private final PairList<CronExpression, Class<? extends PrivilegedTriggerBase>> scheduledTriggers = new PairList();

    private PeriodicMaintenanceJobRegistry() {
        List periodicMaintenanceJobClasses = ClassIndexUtils.getAnnotated(PeriodicMaintenanceJob.class);
        for (Class periodicMaintenanceJobClass : periodicMaintenanceJobClasses) {
            if (!PrivilegedTriggerBase.class.isAssignableFrom(periodicMaintenanceJobClass)) {
                LOGGER.error("Expected " + String.valueOf(periodicMaintenanceJobClass) + " to extend " + String.valueOf(PrivilegedTriggerBase.class));
                continue;
            }
            PeriodicMaintenanceJob periodicMaintenanceJobAnnotation = periodicMaintenanceJobClass.getAnnotation(PeriodicMaintenanceJob.class);
            try {
                this.addScheduledTrigger(CronExpression.parse(periodicMaintenanceJobAnnotation.cronExpression()), periodicMaintenanceJobClass.asSubclass(PrivilegedTriggerBase.class));
            }
            catch (InvalidCronPatternException e) {
                LOGGER.error("Invalid cron expression detected on: " + String.valueOf(periodicMaintenanceJobClass), (Throwable)e);
            }
        }
    }

    public static synchronized PeriodicMaintenanceJobRegistry getInstance() {
        if (instance == null) {
            instance = new PeriodicMaintenanceJobRegistry();
        }
        return instance;
    }

    public synchronized void addScheduledTrigger(CronExpression cronExpression, Class<? extends PrivilegedTriggerBase> triggerClass) {
        this.scheduledTriggers.add((Object)cronExpression, triggerClass);
    }

    public synchronized void removeFirstScheduledTriggerByClass(Class<? extends PrivilegedTriggerBase> triggerClass) {
        int index = this.scheduledTriggers.extractSecondList().indexOf(triggerClass);
        if (index != -1) {
            this.scheduledTriggers.remove(index);
        }
    }

    public synchronized List<JobDescriptor> getScheduledJobs(long timeMillis) {
        ArrayList<JobDescriptor> jobs = new ArrayList<JobDescriptor>();
        for (int i = 0; i < this.scheduledTriggers.size(); ++i) {
            if (!((CronExpression)this.scheduledTriggers.getFirst(i)).matches(DateTimeUtils.atZone((long)timeMillis))) continue;
            jobs.add(JobDescriptor.forMaintenanceProject().withPrivilegedTrigger((Class)this.scheduledTriggers.getSecond(i)).withSchedulingReason("Scheduled as regular maintenance job.").build());
        }
        return jobs;
    }
}

