/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class PeriodicSchedulingData {
    @VisibleForTesting
    long lastPeriodicSchedulingTimestamp = 0L;
    private final Object lastPeriodicSchedulingLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getPeriodicSchedulingTicks() {
        long nowMillis = DateTimeUtils.millisNow();
        int nowSeconds = (int)(nowMillis / 1000L);
        if (this.lastPeriodicSchedulingTimestamp / 1000L == (long)nowSeconds) {
            return Collections.emptyList();
        }
        Object object = this.lastPeriodicSchedulingLock;
        synchronized (object) {
            int lastSeconds = (int)(this.lastPeriodicSchedulingTimestamp / 1000L);
            if (lastSeconds == nowSeconds) {
                return Collections.emptyList();
            }
            this.lastPeriodicSchedulingTimestamp = nowMillis;
            if (lastSeconds == 0) {
                return List.of(Integer.valueOf(nowSeconds));
            }
            return IntStream.rangeClosed(lastSeconds + 1, nowSeconds).boxed().toList();
        }
    }

    public void forcePeriodicSchedulingOnNextRun() {
        this.lastPeriodicSchedulingTimestamp = 0L;
    }
}

