/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.RollbackLimitOption;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgress;
import com.teamscale.core.runtime.impl.rollback.ForceRollbackTrigger;
import com.teamscale.core.runtime.impl.rollback.RollbackTrigger;
import java.time.Duration;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jspecify.annotations.Nullable;

final class PostponedRollbackDecider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IndexLayer indexLayer;
    private final ProjectAnalysisProgress progress;
    private final InternalProjectId internalProjectId;
    private final Supplier<PublicProjectId> publicProjectId;

    PostponedRollbackDecider(IndexLayer indexLayer, InternalProjectId internalProjectId, java.util.function.Supplier<PublicProjectId> publicProjectId, ProjectAnalysisProgress progress) {
        this.indexLayer = indexLayer;
        this.internalProjectId = internalProjectId;
        this.publicProjectId = publicProjectId::get;
        this.progress = progress;
    }

    public boolean rollbackShouldBePostponed(RollbackRequest rollbackRequest, @Nullable JobDescriptor rollbackJob) throws StorageException {
        if (PostponedRollbackDecider.isForcedRollback(rollbackJob)) {
            LOGGER.debug("{}: Not postponing rollback '{}', as it was forced by a user.", new Supplier[]{this.publicProjectId, () -> rollbackRequest});
            return false;
        }
        if (rollbackRequest.neverPostpone()) {
            LOGGER.debug("{}: Not postponing rollback '{}', as it may not be postponed.", new Supplier[]{this.publicProjectId, () -> rollbackRequest});
            return false;
        }
        if (this.progress.getAnalysisState() == EAnalysisState.HISTORY_ANALYSIS) {
            LOGGER.debug("{}: Not postponing rollback '{}', as we never reached HEAD before.", new Supplier[]{this.publicProjectId, () -> rollbackRequest});
            return false;
        }
        if (PostponedRollbackDecider.isPrecommitOnlyRollback(rollbackRequest)) {
            LOGGER.debug("{}: Not postponing rollback '{}', because only pre-commits are rolled back.", new Supplier[]{this.publicProjectId, () -> rollbackRequest});
            return false;
        }
        if (this.isSmallRollback(rollbackRequest)) {
            LOGGER.debug("{}: Not postponing rollback '{}', as it is small.", new Supplier[]{this.publicProjectId, () -> rollbackRequest});
            return false;
        }
        if (this.isWithinAcceptedRollbackTimeWindow(rollbackRequest)) {
            LOGGER.debug("{}: Not postponing rollback '{}', as it is within the accepted rollback time window.", new Supplier[]{this.publicProjectId, () -> rollbackRequest});
            return false;
        }
        return true;
    }

    private static boolean isPrecommitOnlyRollback(RollbackRequest rollbackRequest) {
        return CollectionUtils.allMatch(rollbackRequest.rollbackCommits(), PreCommitUtils::isPrecommitCommit);
    }

    private static boolean isForcedRollback(@Nullable JobDescriptor rollbackJob) {
        return rollbackJob != null && ForceRollbackTrigger.class.getName().equals(rollbackJob.getTriggerName());
    }

    private boolean isWithinAcceptedRollbackTimeWindow(RollbackRequest rollbackRequest) throws StorageException {
        long limitTimestamp;
        ServerOptionIndex serverOptionIndex = this.indexLayer.openGlobalIndex(ServerOptionIndex.class);
        int maxHours = RollbackLimitOption.getAgeThresholdHours(serverOptionIndex);
        long oldestTimestamp = rollbackRequest.rollbackCommits().stream().mapToLong(CommitDescriptor::getTimestamp).min().orElseThrow();
        return oldestTimestamp >= (limitTimestamp = DateTimeUtils.now().minus(Duration.ofHours(maxHours)).toEpochMilli());
    }

    private boolean isSmallRollback(RollbackRequest rollbackRequest) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)this.internalProjectId);
        Map<String, Long> timestampForBranch = RollbackTrigger.buildRollbackTimestampForBranchMap(rollbackRequest, projectStorageSystem);
        CounterSet<ECommitTreeNodeState> rolledBackStateCount = RollbackTrigger.determineRolledBackStateCount(projectStorageSystem, timestampForBranch);
        ServerOptionIndex serverOptionIndex = this.indexLayer.openGlobalIndex(ServerOptionIndex.class);
        if (rolledBackStateCount.getValue((Object)ECommitTreeNodeState.PROCESSED) <= RollbackLimitOption.getCommitCountThreshold(serverOptionIndex)) {
            LOGGER.debug("{}: Rollback '{}' has size '{}'", new Supplier[]{this.publicProjectId, () -> rollbackRequest, () -> rolledBackStateCount.getValue((Object)ECommitTreeNodeState.PROCESSED)});
            return true;
        }
        return false;
    }
}

