/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.runtime.impl.analysis.RateLimitableResource;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class RateLimitingSupport {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ConcurrentMap<RateLimitableResource, Instant> rateLimitedResources = new ConcurrentHashMap<RateLimitableResource, Instant>();

    public boolean isRateLimited(RateLimitableResource remoteResource) {
        return this.getEarliestAllowedAccess(remoteResource) != null;
    }

    public void signalRateLimiting(RateLimitableResource remoteResource, Instant earliestAllowedAccess) {
        CCSMAssert.isNotNull((Object)remoteResource, (String)"Remote resource must not be null");
        CCSMAssert.isNotNull((Object)earliestAllowedAccess, (String)"Earliest allowed access must not be null");
        this.rateLimitedResources.compute(remoteResource, (rateLimitableResource, existingValue) -> {
            if (existingValue == null || earliestAllowedAccess.isAfter((Instant)existingValue)) {
                LOGGER.trace("Signalling that remote resource {} is rate-limited until {}", (Object)remoteResource, (Object)earliestAllowedAccess);
                return earliestAllowedAccess;
            }
            return existingValue;
        });
    }

    public @Nullable Instant getEarliestAllowedAccess(RateLimitableResource remoteResource) {
        CCSMAssert.isNotNull((Object)remoteResource, (String)"Remote resource must not be null");
        return this.rateLimitedResources.computeIfPresent(remoteResource, (rateLimitableResource, value) -> {
            if (value.isBefore(DateTimeUtils.now())) {
                return null;
            }
            return value;
        });
    }

    @TestOnly
    public void clearRateLimits() {
        this.rateLimitedResources.clear();
    }
}

