/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.api.performance.PerformanceMetricsIndex;
import com.teamscale.core.runtime.api.scheduling.ESchedulerCommand;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.scheduling.PeriodicSchedulingData;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingData;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.core.runtime.impl.scheduling.RateLimitingSupport;
import com.teamscale.core.runtime.impl.scheduling.SchedulerCommunicator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.index.collections.DurableIdGenerator;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class SchedulingData {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String PROJECT_INVALIDATION_CHANNEL = "project-invalidation";
    private static final Duration PROJECT_DISCOVERY_INTERVAL = DurationUtils.ONE_MINUTE;
    private static final Duration PROGRESS_REPORTING_INTERVAL = DurationUtils.ONE_SECOND;
    private static final Duration DEAD_CONNECTOR_CHECK_INTERVAL = Duration.ofMinutes(10L);
    private final Object creationLock = new Object();
    private final NavigableMap<InternalProjectId, ProjectSchedulingData> projectData = Collections.synchronizedNavigableMap(new TreeMap(Comparator.comparingInt(projectId -> SchedulingConstants.isMaintenance((IProjectId)projectId) ? 0 : 1).thenComparing(Comparator.naturalOrder())));
    private final List<ProjectSchedulingData> projectDataList = new ArrayList<ProjectSchedulingData>();
    private int projectDataListIndex = 0;
    private final IndexLayer indexLayer;
    private final int localWorkerCount;
    private long lastProjectDiscoveryTimestamp = 0L;
    private final Object lastProjectDiscoveryLock = new Object();
    private final PeriodicSchedulingData periodicSchedulingData;
    private long lastProgressReportingTimestamp = 0L;
    private final Object lastProgressReportingLock = new Object();
    private long lastDeadConnectorCheckTimestamp = 0L;
    private final Object lastDeadConnectorCheckLock = new Object();
    private final DurableIdGenerator idGenerator;
    private final PerformanceMetricsIndex.CompletedRevisionSupport completedRevisionSupport = new PerformanceMetricsIndex.CompletedRevisionSupport();
    private final RateLimitingSupport rateLimitingSupport;

    public SchedulingData(IndexLayer indexLayer, DurableIdGenerator idGenerator, int localWorkerCount) {
        this(indexLayer, idGenerator, localWorkerCount, new PeriodicSchedulingData(), new RateLimitingSupport());
    }

    @VisibleForTesting
    SchedulingData(IndexLayer indexLayer, DurableIdGenerator idGenerator, int localWorkerCount, PeriodicSchedulingData periodicSchedulingData, RateLimitingSupport rateLimitingSupport) {
        this.indexLayer = indexLayer;
        this.idGenerator = idGenerator;
        this.localWorkerCount = localWorkerCount;
        this.periodicSchedulingData = periodicSchedulingData;
        this.rateLimitingSupport = rateLimitingSupport;
        this.registerProjectDiscoveryListener(indexLayer);
        indexLayer.getMessageBroker().registerListener(PROJECT_INVALIDATION_CHANNEL, projectId -> Optional.ofNullable((ProjectSchedulingData)this.projectData.get(new InternalProjectId(projectId))).ifPresent(ProjectSchedulingData::markInvalid));
    }

    private void registerProjectDiscoveryListener(IndexLayer indexLayer) {
        indexLayer.getMessageBroker().registerListener("scheduler-commands", this::handleSchedulerCommand);
        String aliasChannel = StorageCacheProvider.buildMessageChannelId((String)"__global__", ProjectIndex.ProjectInfoCache.class);
        indexLayer.getMessageBroker().registerListener(aliasChannel, command -> {
            Object object = this.lastProjectDiscoveryLock;
            synchronized (object) {
                this.lastProjectDiscoveryTimestamp = 0L;
            }
        });
    }

    private void handleSchedulerCommand(String command) {
        Pair<ESchedulerCommand, Object> parsedCommand = SchedulerCommunicator.parseSchedulerCommand(command);
        switch ((ESchedulerCommand)((Object)parsedCommand.getFirst())) {
            case RELOAD: {
                String projectId = (String)parsedCommand.getSecond();
                this.processReloadSchedulerCommand(projectId);
                break;
            }
            case SET_JOB_READY: {
                SetJobReadyParameters parameters = (SetJobReadyParameters)parsedCommand.getSecond();
                this.processSetJobReadyCommand(parameters.projectId(), parameters.schedulingCommit(), parameters.triggerName());
                break;
            }
            default: {
                CCSMAssert.fail((String)("Invalid scheduler command '" + command + "'."));
            }
        }
    }

    private void processSetJobReadyCommand(InternalProjectId projectId, CommitDescriptor schedulingCommit, String triggerName) {
        LOGGER.debug("Setting job '{}' on project '{}' at commit '{}' to ready now.", (Object)triggerName, (Object)projectId, (Object)schedulingCommit);
        ((ProjectSchedulingData)this.projectData.get(projectId)).rescheduleJobNow(triggerName, schedulingCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReloadSchedulerCommand(@Nullable String project) {
        if (project != null) {
            ProjectSchedulingData projectSchedulingData = (ProjectSchedulingData)this.projectData.get(new InternalProjectId(project));
            if (projectSchedulingData != null) {
                projectSchedulingData.markForTriggerReload();
            }
        } else {
            Object object = this.lastProjectDiscoveryLock;
            synchronized (object) {
                this.lastProjectDiscoveryTimestamp = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectSchedulingData getOrCreateProjectSchedulingData(InternalProjectId projectId) throws StorageException, TriggerCompilationException {
        ProjectSchedulingData result = (ProjectSchedulingData)this.projectData.get(projectId);
        if (result != null) {
            return result;
        }
        Object object = this.creationLock;
        synchronized (object) {
            result = (ProjectSchedulingData)this.projectData.get(projectId);
            if (result == null) {
                result = new ProjectSchedulingData(projectId, this.indexLayer, this.idGenerator, this.completedRevisionSupport, this);
                this.projectData.put(projectId, result);
                List<ProjectSchedulingData> list = this.projectDataList;
                synchronized (list) {
                    this.projectDataList.add(result);
                }
            }
            return result;
        }
    }

    public void runOnAllProjects(Consumer<ProjectSchedulingData> action) {
        List<ProjectSchedulingData> projects = this.getProjectSchedulingDataSnapshot();
        ArrayList<ProjectSchedulingData> secondRun = new ArrayList<ProjectSchedulingData>();
        for (ProjectSchedulingData project : projects) {
            if (project.isInvalid()) continue;
            if (project.isPartiallyLocked()) {
                secondRun.add(project);
                continue;
            }
            action.accept(project);
        }
        for (ProjectSchedulingData project : secondRun) {
            if (project.isInvalid()) continue;
            action.accept(project);
        }
    }

    public boolean isProjectDiscoveryNeeded() {
        return SchedulingData.checkTimeHasPassed(PROJECT_DISCOVERY_INTERVAL, () -> this.lastProjectDiscoveryTimestamp, timestamp -> {
            this.lastProjectDiscoveryTimestamp = timestamp;
        }, this.lastProjectDiscoveryLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkTimeHasPassed(Duration amountOfTimePassed, LongSupplier lastTimestampGetter, LongConsumer lastTimestampSetter, Object lock) {
        long now = System.currentTimeMillis();
        Object object = lock;
        synchronized (object) {
            if (now - lastTimestampGetter.getAsLong() > amountOfTimePassed.toMillis()) {
                lastTimestampSetter.accept(now);
                return true;
            }
            return false;
        }
    }

    public PeriodicSchedulingData getPeriodicSchedulingData() {
        return this.periodicSchedulingData;
    }

    public boolean isProgressReportingNeeded() {
        return SchedulingData.checkTimeHasPassed(PROGRESS_REPORTING_INTERVAL, () -> this.lastProgressReportingTimestamp, timestamp -> {
            this.lastProgressReportingTimestamp = timestamp;
        }, this.lastProgressReportingLock);
    }

    public boolean isDeadConnectorCheckNeeded() {
        return SchedulingData.checkTimeHasPassed(DEAD_CONNECTOR_CHECK_INTERVAL, () -> this.lastDeadConnectorCheckTimestamp, timestamp -> {
            this.lastDeadConnectorCheckTimestamp = timestamp;
        }, this.lastDeadConnectorCheckLock);
    }

    public void updateLastDeadConnectorCheckTimesteamp() {
        this.lastDeadConnectorCheckTimestamp = System.currentTimeMillis();
    }

    public int getProjectCount() {
        return this.projectData.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ProjectSchedulingData> getNextUnlockedProject(ProjectSchedulingFilter schedulingFilter, boolean firstCall) {
        ProjectSchedulingData maintenanceProject;
        LOGGER.traceEntry("Get next unlocked project. Scheduling filter: {} First call: {}", new Object[]{schedulingFilter, firstCall});
        if (firstCall && this.projectData.containsKey(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID) && this.shouldPreferMaintenanceJobs(maintenanceProject = (ProjectSchedulingData)this.projectData.get(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID), schedulingFilter)) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = maintenanceProject::loadPublicProjectId;
            LOGGER.trace("Exit with: {}", supplierArray);
            return Optional.of(maintenanceProject);
        }
        List<ProjectSchedulingData> list = this.projectDataList;
        synchronized (list) {
            if (this.projectDataListIndex >= this.projectDataList.size()) {
                this.projectDataListIndex = 0;
            }
            for (int i = 0; i < this.projectDataList.size(); ++i) {
                ProjectSchedulingData result = this.projectDataList.get(this.projectDataListIndex);
                this.projectDataListIndex = (this.projectDataListIndex + 1) % this.projectDataList.size();
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = result::loadPublicProjectId;
                supplierArray[1] = result::getInternalProjectId;
                LOGGER.trace("Trying project {} ({})", supplierArray);
                if (!schedulingFilter.isSchedulable(result.getInternalProjectId())) {
                    LOGGER.trace("Not schedulable by filter");
                    continue;
                }
                boolean partiallyLocked = result.isPartiallyLocked();
                boolean invalid = result.isInvalid();
                if (!partiallyLocked && !invalid) {
                    return (Optional)LOGGER.traceExit("Exit with: {}", Optional.of(result));
                }
                LOGGER.trace("Not schedulable because partiallyLocked ({}) or invalid ({})", (Object)partiallyLocked, (Object)invalid);
            }
        }
        return (Optional)LOGGER.traceExit("Unable to find unlocked project: {}", Optional.empty());
    }

    private boolean shouldPreferMaintenanceJobs(ProjectSchedulingData maintenanceProject, ProjectSchedulingFilter filter) {
        int maxMaintenanceJobs;
        if (maintenanceProject.isPartiallyLocked() || !filter.isSchedulable(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID)) {
            return false;
        }
        int runningMaintenanceProjects = maintenanceProject.getAssignedJobCount();
        return runningMaintenanceProjects < (maxMaintenanceJobs = Math.max(1, this.localWorkerCount / 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeProjects(Set<InternalProjectId> expectedProjects) throws StorageException, TriggerCompilationException {
        for (InternalProjectId projectId : expectedProjects) {
            if (!this.isProjectReady(projectId)) continue;
            this.getOrCreateProjectSchedulingData(projectId);
        }
        List<ProjectSchedulingData> list = this.projectDataList;
        synchronized (list) {
            for (ProjectSchedulingData projectEntry : this.projectDataList) {
                if (expectedProjects.contains(projectEntry.getInternalProjectId())) continue;
                this.projectData.remove(projectEntry.getInternalProjectId());
            }
            this.projectDataList.clear();
            this.projectDataList.addAll(this.projectData.values());
        }
    }

    private boolean isProjectReady(InternalProjectId projectId) throws StorageException {
        if (SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            return true;
        }
        return this.indexLayer.openRawProjectStorageSystem(projectId).openStore("_meta").get(StringUtils.stringToBytes((String)IndexSchema.class.getName())) != null;
    }

    public boolean hasNonperiodicJobsScheduled() throws TriggerCompilationException {
        for (ProjectSchedulingData project : this.getProjectSchedulingDataSnapshot()) {
            if (project.getAssignedJobCount() <= 0 && !project.hasNonperiodicJobsScheduled()) continue;
            return true;
        }
        return false;
    }

    public int getOverallJobQueueSize() {
        return this.getProjectSchedulingDataSnapshot().stream().mapToInt(ProjectSchedulingData::getJobQueueSize).sum();
    }

    public int getOverallDelayedJobQueueSize() {
        return this.getProjectSchedulingDataSnapshot().stream().mapToInt(ProjectSchedulingData::getDelayedJobQueueSize).sum();
    }

    public List<JobDescriptor> getOverallAssignedJobs() {
        ArrayList<JobDescriptor> assignedJobs = new ArrayList<JobDescriptor>();
        for (ProjectSchedulingData projectSchedulingData : this.getProjectSchedulingDataSnapshot()) {
            assignedJobs.addAll(projectSchedulingData.getAssignedJobs());
        }
        return assignedJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProjectSchedulingData> getProjectSchedulingDataSnapshot() {
        List<ProjectSchedulingData> list = this.projectDataList;
        synchronized (list) {
            return new ArrayList<ProjectSchedulingData>(this.projectDataList);
        }
    }

    public PerformanceMetricsIndex.CompletedRevisionSupport getCompletedRevisionSupport() {
        return this.completedRevisionSupport;
    }

    public RateLimitingSupport getRateLimitingSupport() {
        return this.rateLimitingSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateProject(InternalProjectId projectId) {
        List<ProjectSchedulingData> list = this.projectDataList;
        synchronized (list) {
            if (this.projectData.remove(projectId) != null) {
                this.projectDataList.removeIf(projectData -> projectId.equals((Object)projectData.getInternalProjectId()));
            }
        }
        this.lastProjectDiscoveryTimestamp = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getProjectOffsetFactor(InternalProjectId projectId) {
        if (SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            return 0.0;
        }
        NavigableMap<InternalProjectId, ProjectSchedulingData> navigableMap = this.projectData;
        synchronized (navigableMap) {
            NavigableMap<InternalProjectId, ProjectSchedulingData> projectOnlyMap = this.projectData.tailMap(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, false);
            int projectIndex = projectOnlyMap.headMap(projectId, false).size();
            return (double)projectIndex / (double)projectOnlyMap.size();
        }
    }

    public record SetJobReadyParameters(InternalProjectId projectId, CommitDescriptor schedulingCommit, String triggerName) {
    }
}

