/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.trigger.AnalysisStepContext;
import com.teamscale.core.analysis.trigger.IAnalysisStep;
import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.CriticalSystemStateIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.impl.analysis.trigger.PrivilegedTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.worker.AnalysisTriggerExecutorBase;
import com.teamscale.core.runtime.impl.worker.ITriggerExecutionResultState;
import com.teamscale.core.runtime.impl.worker.TriggerExecutionResult;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedSet;
import java.util.function.Function;
import org.apache.logging.log4j.core.LogEvent;
import org.conqat.engine.core.logging.TeamscaleLogAppender;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.lang.SilentAutoClosable;
import org.jspecify.annotations.NonNull;

final class PrivilegedTriggerExecutor {
    private final ScheduledJob scheduledJob;
    private final IndexLayer indexLayer;
    private final ILockProvider lockProvider;
    private final InstanceConfiguration instanceConfiguration;
    private final Path tempDirectory;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final IProfilingMonitor profilingMonitor;
    private final PrivilegedTrigger trigger;
    private final SequencedSet<IPostTriggerAction> postTriggerActions = new LinkedHashSet<IPostTriggerAction>();

    public PrivilegedTriggerExecutor(ScheduledJob scheduledJob, IndexLayer indexLayer, ILockProvider lockProvider, InstanceConfiguration instanceConfiguration, Path tempDirectory, IParallelTaskExecutor parallelTaskExecutor, IProfilingMonitor profilingMonitor) throws TriggerCompilationException {
        this.scheduledJob = scheduledJob;
        this.indexLayer = indexLayer;
        this.lockProvider = lockProvider;
        this.instanceConfiguration = instanceConfiguration;
        this.tempDirectory = tempDirectory;
        this.parallelTaskExecutor = parallelTaskExecutor;
        this.profilingMonitor = profilingMonitor;
        this.trigger = PrivilegedTrigger.createTrigger(scheduledJob.getTriggerName());
    }

    public TriggerExecutionResult execute(Function<IAnalysisStep, SilentAutoClosable> wrapper) throws StorageException, IOException {
        PrivilegedTriggerBase runtimeDelegate = this.trigger.getTriggerImplementation();
        runtimeDelegate.init(this.scheduledJob.getJob(), this.indexLayer, this.lockProvider, this.instanceConfiguration, this.createContext(), this.scheduledJob.getRetryCount());
        TeamscaleLogAppender.init();
        try (SilentAutoClosable ignoredCleanup = wrapper.apply(runtimeDelegate);){
            ITriggerExecutionResultState executionResultState = AnalysisTriggerExecutorBase.executeAndHandleExceptions(runtimeDelegate, this.indexLayer.openGlobalIndex(CriticalSystemStateIndex.class), this.postTriggerActions, this.scheduledJob.getJob().getRemoteResource());
            TriggerExecutionResult triggerExecutionResult = new TriggerExecutionResult(executionResultState, (List<LogEvent>)TeamscaleLogAppender.getLogEvents(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
            return triggerExecutionResult;
        }
    }

    private @NonNull AnalysisStepContext createContext() throws IOException, StorageException {
        return new AnalysisStepContext(this.scheduledJob.getTriggerName(), this.scheduledJob.getSchedulingCommit(), this.indexLayer.resolveToPrimaryPublicProjectId((IProjectId)this.scheduledJob.getJob().getInternalProjectId()), this.profilingMonitor, this.postTriggerActions::add, this.tempDirectory, this.parallelTaskExecutor, this.lockProvider);
    }
}

