/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.runtime.impl.worker.ITriggerExecutionResultState;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.LogEvent;
import org.conqat.engine.core.logging.ELogLevel;
import org.jetbrains.annotations.TestOnly;

public record TriggerExecutionResult(ITriggerExecutionResultState state, List<LogEvent> loggingEvents, Map<String, IIndexDelta> inputDeltas, Map<String, List<IIndexDelta>> outputDeltas, Map<String, Long> writtenVirtualStores) {
    public TriggerExecutionResult {
        Objects.requireNonNull(state, "state");
        loggingEvents = List.copyOf((Collection)Objects.requireNonNull(loggingEvents, "loggingEvents"));
        inputDeltas = Map.copyOf(Objects.requireNonNull(inputDeltas, "inputDeltas"));
        outputDeltas = Map.copyOf(Objects.requireNonNull(outputDeltas, "outputDeltas").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> List.copyOf((Collection)e.getValue()))));
        writtenVirtualStores = Map.copyOf(Objects.requireNonNull(writtenVirtualStores, "writtenVirtualStores"));
    }

    public Stream<LogEvent> loggingEvents(Collection<ELogLevel> levels) {
        Set log4jLevels = levels.stream().map(ELogLevel::getLog4JLevel).collect(Collectors.toSet());
        return this.loggingEvents.stream().filter(logEvent -> log4jLevels.contains(logEvent.getLevel()));
    }

    @TestOnly
    public Map<String, IIndexDelta> getCombinedOutputDeltas() {
        HashMap<String, IIndexDelta> result = HashMap.newHashMap(this.outputDeltas.size());
        for (Map.Entry<String, List<IIndexDelta>> entry : this.outputDeltas.entrySet()) {
            result.put(entry.getKey(), IIndexDelta.combineAll(entry.getValue()));
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TestOnly
    public Collection<IPostTriggerAction> getPostTriggerActions() {
        SequencedCollection<IPostTriggerAction> sequencedCollection;
        ITriggerExecutionResultState iTriggerExecutionResultState = this.state;
        Objects.requireNonNull(iTriggerExecutionResultState);
        ITriggerExecutionResultState iTriggerExecutionResultState2 = iTriggerExecutionResultState;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ITriggerExecutionResultState.RunSuccessfully.class, ITriggerExecutionResultState.RescheduleRequested.class}, (ITriggerExecutionResultState)iTriggerExecutionResultState2, n)) {
            case 0: {
                ITriggerExecutionResultState.RunSuccessfully runSuccessfully = (ITriggerExecutionResultState.RunSuccessfully)iTriggerExecutionResultState2;
                try {
                    SequencedSet<IPostTriggerAction> sequencedSet;
                    SequencedSet<IPostTriggerAction> postTriggerActions = sequencedSet = runSuccessfully.postTriggerActions();
                    sequencedCollection = postTriggerActions;
                    return sequencedCollection;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                Object rateLimitingActions;
                ITriggerExecutionResultState.RescheduleRequested rescheduleRequested = (ITriggerExecutionResultState.RescheduleRequested)iTriggerExecutionResultState2;
                {
                    Object object = rescheduleRequested.earliestReschedule();
                    rateLimitingActions = object = rescheduleRequested.rateLimitingActions();
                }
                sequencedCollection = Collections.unmodifiableSequencedSet(rateLimitingActions);
                return sequencedCollection;
            }
        }
        sequencedCollection = Collections.emptyList();
        return sequencedCollection;
    }
}

