/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.analysis.IDeltaTranslatingIndex;
import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.runtime.impl.analysis.DeltaIndex;
import com.teamscale.core.runtime.impl.analysis.ISchedulingCommit;
import com.teamscale.core.runtime.impl.analysis.VirtualStoreIndex;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.worker.AnalysisTriggerExecutorBase;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.collections.DurableIdGenerator;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.ReadOnlyStore;
import org.conqat.lib.commons.assertion.CCSMAssert;

final class WorkerAnalysisTriggerExecutor
extends AnalysisTriggerExecutorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ScheduledJob scheduledJob;
    private final Path tempDir;
    private final DeltaIndex deltaIndex;
    private final VirtualStoreIndex virtualStoreIndex;
    private final Map<String, Long> writtenVirtualStoreNameToId = new HashMap<String, Long>();
    private final DurableIdGenerator idGenerator;

    public WorkerAnalysisTriggerExecutor(ScheduledJob scheduledJob, TriggerDescription triggerDescriptor, Path tempDir, DeltaIndex deltaIndex, VirtualStoreIndex virtualStoreIndex, DurableIdGenerator idGenerator, ProjectStorageSystem projectStorageSystem, IParallelTaskExecutor parallelTaskExecutor, ILockProvider lockProvider) throws StorageException {
        super(scheduledJob.getJob().getTriggerName(), scheduledJob.getJob().getInternalProjectId(), WorkerAnalysisTriggerExecutor.resolveExecutionCommit(scheduledJob.getSchedulingCommit(), projectStorageSystem), triggerDescriptor, parallelTaskExecutor, lockProvider);
        this.scheduledJob = scheduledJob;
        this.tempDir = tempDir;
        this.deltaIndex = deltaIndex;
        this.virtualStoreIndex = virtualStoreIndex;
        this.idGenerator = idGenerator;
        this.addExpectedDeltas((Collection<String>)scheduledJob.getRequiredDeltas());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ParentedCommitDescriptor resolveExecutionCommit(ISchedulingCommit schedulingCommit, ProjectStorageSystem projectStorageSystem) throws StorageException {
        if (schedulingCommit == null) {
            return null;
        }
        ParentedCommitDescriptor verifiedCommit = ((CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null)).getCommit(schedulingCommit.commit());
        if (verifiedCommit != null) {
            return verifiedCommit;
        }
        if (!(schedulingCommit instanceof ISchedulingCommit.ParentedCommit)) throw new IllegalStateException("Scheduled job for non-existing commit: %s".formatted(schedulingCommit));
        ISchedulingCommit.ParentedCommit parentedCommit = (ISchedulingCommit.ParentedCommit)schedulingCommit;
        try {
            ParentedCommitDescriptor parentedCommitDescriptor = parentedCommit.parentedCommit();
            return parentedCommitDescriptor;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Override
    protected IIndexDelta getDeltaForIndex(String indexName, Class<? extends IStorageIndex> indexType) throws StorageException {
        List<Long> deltaIds = this.scheduledJob.getInputDeltaIdsForStore(indexName);
        Class<IIndexDelta> expectedDeltaClass = IDeltaTranslatingIndex.getDeltaClass(indexType);
        if (deltaIds.isEmpty()) {
            return IIndexDelta.empty(expectedDeltaClass);
        }
        List<IIndexDelta> storedDeltas = this.deltaIndex.getDeltasForIds(deltaIds);
        for (int i = 0; i < storedDeltas.size(); ++i) {
            if (storedDeltas.get(i) == null) {
                throw new AssertionError((Object)("The delta for index \"" + indexName + "\" with ID " + String.valueOf(deltaIds.get(i)) + " was not found in the store when preparing job " + this.scheduledJob.getTriggerName() + "@" + String.valueOf(this.scheduledJob.getSchedulingCommit()) + " (current time " + System.currentTimeMillis() + ")"));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Combining {} deltas for index '{}' with a total size of {}", (Object)storedDeltas.size(), (Object)indexName, (Object)storedDeltas.stream().mapToLong(IIndexDelta::size).sum());
        }
        IIndexDelta resolvedDelta = IIndexDelta.combineAll(storedDeltas);
        CCSMAssert.isTrue((boolean)expectedDeltaClass.isAssignableFrom(resolvedDelta.getClass()), () -> "Expected resolved delta class %s to be assignable to expected delta class %s for index %s (%s)".formatted(resolvedDelta.getClass(), expectedDeltaClass, indexName, indexType));
        return resolvedDelta;
    }

    @Override
    protected IStore openVirtualStore(String storeName, boolean readOnly) throws StorageException {
        if (readOnly) {
            List<Long> storeIds = this.scheduledJob.getVirtualStoreIdsForStore(storeName);
            if (storeIds.isEmpty()) {
                return new ReadOnlyStore((IStore)new InMemoryStore());
            }
            return this.virtualStoreIndex.openVirtualStoreForReading(storeIds);
        }
        Long writeId = this.writtenVirtualStoreNameToId.get(storeName);
        if (writeId == null) {
            writeId = this.idGenerator.getNextId();
            this.writtenVirtualStoreNameToId.put(storeName, writeId);
        }
        return this.virtualStoreIndex.openVirtualStoreForWriting(writeId);
    }

    @Override
    public Map<String, Long> getWrittenVirtualStoreNameToId() {
        return this.writtenVirtualStoreNameToId;
    }

    @Override
    protected Path getTempDir() {
        return this.tempDir;
    }

    @Override
    protected InternalProjectId getProjectId() {
        return this.scheduledJob.getProjectId();
    }
}

