/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.log.custom.CustomLogConfigurationIndex;
import com.teamscale.core.log.custom.CustomLogEventIndex;
import com.teamscale.core.runtime.impl.scheduling.SchedulingData;
import com.teamscale.core.runtime.impl.util.IndexRunnableBase;
import com.teamscale.core.runtime.impl.worker.ClusterStatusThread;
import com.teamscale.core.runtime.impl.worker.OptionScheduledRunnersSchedulerThread;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import com.teamscale.core.runtime.impl.worker.WorkerThread;
import com.teamscale.core.shutdown.ShutdownManagerAwareThread;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.core.logging.TeamscaleCustomLogAppender;
import org.conqat.engine.persistence.index.collections.DurableIdGenerator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DurationUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class WorkerCluster
extends IndexRunnableBase {
    @VisibleForTesting
    static final Duration MAX_RESTART_WAIT = DurationUtils.ONE_SECOND;
    private static final Logger LOGGER = LogManager.getLogger();
    private final int numWorkers;
    private final InstanceConfiguration instanceConfiguration;
    private final List<WorkerThread> workers = new ArrayList<WorkerThread>();
    private ClusterStatusThread heartbeatThread;
    private OptionScheduledRunnersSchedulerThread optionScheduledRunnersSchedulerThread;
    private Timer teamscaleCustomLogCollector;
    private SchedulingData schedulingData;
    private final String processId;

    public WorkerCluster(int numWorkers, InstanceConfiguration instanceConfiguration, String processId) {
        this.numWorkers = numWorkers;
        this.instanceConfiguration = instanceConfiguration;
        this.processId = processId;
    }

    @Override
    protected void startDemons() {
        DurableIdGenerator idGenerator = this.workerIndex.createJobAndDeltaIdGenerator();
        this.schedulingData = new SchedulingData(this.indexLayer, idGenerator, this.numWorkers);
        WorkerClusterStatus status = new WorkerClusterStatus(this.processId);
        try {
            this.heartbeatThread = new ClusterStatusThread(status, this.indexLayer, this.schedulingData);
            this.heartbeatThread.start();
        }
        catch (StorageException e) {
            LOGGER.fatal("Failed to start heartbeat: " + e.getMessage(), (Throwable)e);
        }
        this.optionScheduledRunnersSchedulerThread = new OptionScheduledRunnersSchedulerThread(this.indexLayer);
        this.optionScheduledRunnersSchedulerThread.start();
        String workerIdPrefix = this.processId + "-";
        for (int i = 0; i < this.numWorkers; ++i) {
            try {
                WorkerThread worker = new WorkerThread(workerIdPrefix + i, status, this.instanceConfiguration, this.indexLayer, this.lockProvider, this.schedulingData, idGenerator, this::wakeUpIdleWorkers);
                this.workers.add(worker);
                continue;
            }
            catch (StorageException e) {
                LOGGER.fatal("Failed to start worker: " + e.getMessage(), (Throwable)e);
            }
        }
        this.workers.forEach(Thread::start);
        try {
            this.setUpCustomLogCollector();
        }
        catch (StorageException e) {
            LOGGER.fatal("Failed to start custom log collector", (Throwable)e);
        }
    }

    private void setUpCustomLogCollector() throws StorageException {
        this.indexLayer.openGlobalIndex(CustomLogConfigurationIndex.class).replayConfiguration();
        final CustomLogEventIndex debugLogEventIndex = this.indexLayer.openGlobalIndex(CustomLogEventIndex.class);
        this.teamscaleCustomLogCollector = new Timer("Teamscale Custom Log Collector", true);
        this.teamscaleCustomLogCollector.schedule(new TimerTask(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void run() {
                try {
                    debugLogEventIndex.addLoggingEvents(LoggingEventTransport.convertFromLog4j((Collection)TeamscaleCustomLogAppender.getAndClearEvents()));
                }
                catch (StorageException e) {
                    LOGGER.error("Unable to store debug events", (Throwable)e);
                }
            }
        }, TimeUnit.SECONDS.toMillis(1L), TimeUnit.SECONDS.toMillis(1L));
    }

    public void stop() {
        LOGGER.info("Restart of worker cluster requested. Stopping...");
        this.stopDemons();
    }

    public boolean isStopped() {
        return this.workers.isEmpty();
    }

    public void start() {
        LOGGER.info("Clearing all jobs and starting...");
        this.workers.clear();
        this.startDemons();
    }

    private void stopDemons() {
        ArrayList<WorkerThread> threadsToStop = new ArrayList<WorkerThread>(this.workers);
        threadsToStop.add((WorkerThread)((Object)this.heartbeatThread));
        threadsToStop.add((WorkerThread)((Object)this.optionScheduledRunnersSchedulerThread));
        threadsToStop.forEach(ShutdownManagerAwareThread::prepareExit);
        for (Thread thread : threadsToStop) {
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.workers.clear();
        this.teamscaleCustomLogCollector.cancel();
    }

    public SchedulingData getSchedulingData() {
        return this.schedulingData;
    }

    private void wakeUpIdleWorkers() {
        this.workers.forEach(WorkerThread::interruptIfPossible);
    }

    public String toString() {
        return "Worker cluster (queue size: " + this.schedulingData.getOverallJobQueueSize() + ")";
    }
}

